

                        
      
package io.fabric8.chaosmesh.client.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.chaosmesh.v1alpha1.IoChaos;
import io.fabric8.chaosmesh.v1alpha1.IoChaosBuilder;
import io.fabric8.chaosmesh.v1alpha1.IoChaosList;

import java.util.Map;
import java.util.TreeMap;


public class IoChaosOperationsImpl extends HasMetadataOperation<IoChaos, IoChaosList, Resource<IoChaos>> {

  public IoChaosOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public IoChaosOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("chaos-mesh.org")
    .withApiGroupVersion("v1alpha1")
    .withPlural("iochaos"));
    this.type = IoChaos.class;
    this.listType = IoChaosList.class;
  }

  public IoChaosOperationsImpl newInstance(OperationContext context) {
    return new IoChaosOperationsImpl(context);
  }

  @Override
  public IoChaos edit(Visitor... visitors) {
    return patch(new IoChaosBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
