

                        

package io.fabric8.chaosmesh.client.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.chaosmesh.client.internal.TimeChaosOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.chaosmesh.v1alpha1.TimeChaos;
import io.fabric8.chaosmesh.v1alpha1.TimeChaosBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class TimeChaosHandler implements ResourceHandler<TimeChaos, TimeChaosBuilder> {

  @Override
  public String getKind() {
    return TimeChaos.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "chaos-mesh.org/v1alpha1";
      }

  @Override
  public TimeChaos create(OkHttpClient client, Config config, String namespace, TimeChaos item) {
    return new TimeChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public TimeChaos replace(OkHttpClient client, Config config, String namespace, TimeChaos item) {
    return new TimeChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public TimeChaos reload(OkHttpClient client, Config config, String namespace, TimeChaos item) {
    return new TimeChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public TimeChaosBuilder edit(TimeChaos item) {
    return new TimeChaosBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, TimeChaos item) {
    return new TimeChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, TimeChaos item, Watcher<TimeChaos> watcher) {
    return new TimeChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, TimeChaos item, String resourceVersion, Watcher<TimeChaos> watcher) {
    return new TimeChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, TimeChaos item, ListOptions listOptions, Watcher<TimeChaos> watcher) {
    return new TimeChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
  }

@Override
  public TimeChaos waitUntilReady(OkHttpClient client, Config config, String namespace, TimeChaos item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new TimeChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public TimeChaos waitUntilCondition(OkHttpClient client, Config config, String namespace, TimeChaos item, Predicate<TimeChaos> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new TimeChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
