

                        

package io.fabric8.chaosmesh.client.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.chaosmesh.client.internal.StressChaosOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.chaosmesh.v1alpha1.StressChaos;
import io.fabric8.chaosmesh.v1alpha1.StressChaosBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class StressChaosHandler implements ResourceHandler<StressChaos, StressChaosBuilder> {

  @Override
  public String getKind() {
    return StressChaos.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "chaos-mesh.org/v1alpha1";
      }

  @Override
  public StressChaos create(OkHttpClient client, Config config, String namespace, StressChaos item) {
    return new StressChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public StressChaos replace(OkHttpClient client, Config config, String namespace, StressChaos item) {
    return new StressChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public StressChaos reload(OkHttpClient client, Config config, String namespace, StressChaos item) {
    return new StressChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public StressChaosBuilder edit(StressChaos item) {
    return new StressChaosBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, StressChaos item) {
    return new StressChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, StressChaos item, Watcher<StressChaos> watcher) {
    return new StressChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, StressChaos item, String resourceVersion, Watcher<StressChaos> watcher) {
    return new StressChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, StressChaos item, ListOptions listOptions, Watcher<StressChaos> watcher) {
    return new StressChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
  }

@Override
  public StressChaos waitUntilReady(OkHttpClient client, Config config, String namespace, StressChaos item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new StressChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public StressChaos waitUntilCondition(OkHttpClient client, Config config, String namespace, StressChaos item, Predicate<StressChaos> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new StressChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
