

                        

package io.fabric8.chaosmesh.client.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.chaosmesh.client.internal.PodNetworkChaosOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.chaosmesh.v1alpha1.PodNetworkChaos;
import io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class PodNetworkChaosHandler implements ResourceHandler<PodNetworkChaos, PodNetworkChaosBuilder> {

  @Override
  public String getKind() {
    return PodNetworkChaos.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "chaos-mesh.org/v1alpha1";
      }

  @Override
  public PodNetworkChaos create(OkHttpClient client, Config config, String namespace, PodNetworkChaos item) {
    return new PodNetworkChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public PodNetworkChaos replace(OkHttpClient client, Config config, String namespace, PodNetworkChaos item) {
    return new PodNetworkChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public PodNetworkChaos reload(OkHttpClient client, Config config, String namespace, PodNetworkChaos item) {
    return new PodNetworkChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public PodNetworkChaosBuilder edit(PodNetworkChaos item) {
    return new PodNetworkChaosBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, PodNetworkChaos item) {
    return new PodNetworkChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PodNetworkChaos item, Watcher<PodNetworkChaos> watcher) {
    return new PodNetworkChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PodNetworkChaos item, String resourceVersion, Watcher<PodNetworkChaos> watcher) {
    return new PodNetworkChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PodNetworkChaos item, ListOptions listOptions, Watcher<PodNetworkChaos> watcher) {
    return new PodNetworkChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
  }

@Override
  public PodNetworkChaos waitUntilReady(OkHttpClient client, Config config, String namespace, PodNetworkChaos item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new PodNetworkChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public PodNetworkChaos waitUntilCondition(OkHttpClient client, Config config, String namespace, PodNetworkChaos item, Predicate<PodNetworkChaos> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new PodNetworkChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
