

                        

package io.fabric8.chaosmesh.client.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.chaosmesh.client.internal.PodChaosOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.chaosmesh.v1alpha1.PodChaos;
import io.fabric8.chaosmesh.v1alpha1.PodChaosBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class PodChaosHandler implements ResourceHandler<PodChaos, PodChaosBuilder> {

  @Override
  public String getKind() {
    return PodChaos.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "chaos-mesh.org/v1alpha1";
      }

  @Override
  public PodChaos create(OkHttpClient client, Config config, String namespace, PodChaos item) {
    return new PodChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public PodChaos replace(OkHttpClient client, Config config, String namespace, PodChaos item) {
    return new PodChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public PodChaos reload(OkHttpClient client, Config config, String namespace, PodChaos item) {
    return new PodChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public PodChaosBuilder edit(PodChaos item) {
    return new PodChaosBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, PodChaos item) {
    return new PodChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PodChaos item, Watcher<PodChaos> watcher) {
    return new PodChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PodChaos item, String resourceVersion, Watcher<PodChaos> watcher) {
    return new PodChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PodChaos item, ListOptions listOptions, Watcher<PodChaos> watcher) {
    return new PodChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
  }

@Override
  public PodChaos waitUntilReady(OkHttpClient client, Config config, String namespace, PodChaos item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new PodChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public PodChaos waitUntilCondition(OkHttpClient client, Config config, String namespace, PodChaos item, Predicate<PodChaos> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new PodChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
