

                        

package io.fabric8.chaosmesh.client.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.chaosmesh.client.internal.NetworkChaosOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.chaosmesh.v1alpha1.NetworkChaos;
import io.fabric8.chaosmesh.v1alpha1.NetworkChaosBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class NetworkChaosHandler implements ResourceHandler<NetworkChaos, NetworkChaosBuilder> {

  @Override
  public String getKind() {
    return NetworkChaos.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "chaos-mesh.org/v1alpha1";
      }

  @Override
  public NetworkChaos create(OkHttpClient client, Config config, String namespace, NetworkChaos item) {
    return new NetworkChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public NetworkChaos replace(OkHttpClient client, Config config, String namespace, NetworkChaos item) {
    return new NetworkChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public NetworkChaos reload(OkHttpClient client, Config config, String namespace, NetworkChaos item) {
    return new NetworkChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public NetworkChaosBuilder edit(NetworkChaos item) {
    return new NetworkChaosBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, NetworkChaos item) {
    return new NetworkChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, NetworkChaos item, Watcher<NetworkChaos> watcher) {
    return new NetworkChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, NetworkChaos item, String resourceVersion, Watcher<NetworkChaos> watcher) {
    return new NetworkChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, NetworkChaos item, ListOptions listOptions, Watcher<NetworkChaos> watcher) {
    return new NetworkChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
  }

@Override
  public NetworkChaos waitUntilReady(OkHttpClient client, Config config, String namespace, NetworkChaos item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new NetworkChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public NetworkChaos waitUntilCondition(OkHttpClient client, Config config, String namespace, NetworkChaos item, Predicate<NetworkChaos> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new NetworkChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
