

                        

package io.fabric8.chaosmesh.client.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.chaosmesh.client.internal.KernelChaosOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.chaosmesh.v1alpha1.KernelChaos;
import io.fabric8.chaosmesh.v1alpha1.KernelChaosBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class KernelChaosHandler implements ResourceHandler<KernelChaos, KernelChaosBuilder> {

  @Override
  public String getKind() {
    return KernelChaos.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "chaos-mesh.org/v1alpha1";
      }

  @Override
  public KernelChaos create(OkHttpClient client, Config config, String namespace, KernelChaos item) {
    return new KernelChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public KernelChaos replace(OkHttpClient client, Config config, String namespace, KernelChaos item) {
    return new KernelChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public KernelChaos reload(OkHttpClient client, Config config, String namespace, KernelChaos item) {
    return new KernelChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public KernelChaosBuilder edit(KernelChaos item) {
    return new KernelChaosBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, KernelChaos item) {
    return new KernelChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, KernelChaos item, Watcher<KernelChaos> watcher) {
    return new KernelChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, KernelChaos item, String resourceVersion, Watcher<KernelChaos> watcher) {
    return new KernelChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, KernelChaos item, ListOptions listOptions, Watcher<KernelChaos> watcher) {
    return new KernelChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
  }

@Override
  public KernelChaos waitUntilReady(OkHttpClient client, Config config, String namespace, KernelChaos item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new KernelChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public KernelChaos waitUntilCondition(OkHttpClient client, Config config, String namespace, KernelChaos item, Predicate<KernelChaos> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new KernelChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
