

                        

package io.fabric8.chaosmesh.client.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.chaosmesh.client.internal.IoChaosOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.chaosmesh.v1alpha1.IoChaos;
import io.fabric8.chaosmesh.v1alpha1.IoChaosBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class IoChaosHandler implements ResourceHandler<IoChaos, IoChaosBuilder> {

  @Override
  public String getKind() {
    return IoChaos.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "chaos-mesh.org/v1alpha1";
      }

  @Override
  public IoChaos create(OkHttpClient client, Config config, String namespace, IoChaos item) {
    return new IoChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public IoChaos replace(OkHttpClient client, Config config, String namespace, IoChaos item) {
    return new IoChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public IoChaos reload(OkHttpClient client, Config config, String namespace, IoChaos item) {
    return new IoChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public IoChaosBuilder edit(IoChaos item) {
    return new IoChaosBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, IoChaos item) {
    return new IoChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, IoChaos item, Watcher<IoChaos> watcher) {
    return new IoChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, IoChaos item, String resourceVersion, Watcher<IoChaos> watcher) {
    return new IoChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, IoChaos item, ListOptions listOptions, Watcher<IoChaos> watcher) {
    return new IoChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
  }

@Override
  public IoChaos waitUntilReady(OkHttpClient client, Config config, String namespace, IoChaos item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new IoChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public IoChaos waitUntilCondition(OkHttpClient client, Config config, String namespace, IoChaos item, Predicate<IoChaos> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new IoChaosOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
