package io.fabric8.certmanager.api.model.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class VaultIssuerBuilder extends VaultIssuerFluent<VaultIssuerBuilder> implements VisitableBuilder<VaultIssuer,VaultIssuerBuilder>{
  public VaultIssuerBuilder() {
    this(new VaultIssuer());
  }
  
  public VaultIssuerBuilder(VaultIssuerFluent<?> fluent) {
    this(fluent, new VaultIssuer());
  }
  
  public VaultIssuerBuilder(VaultIssuerFluent<?> fluent,VaultIssuer instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public VaultIssuerBuilder(VaultIssuer instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  VaultIssuerFluent<?> fluent;
  
  public VaultIssuer build() {
    VaultIssuer buildable = new VaultIssuer(fluent.buildAuth(),fluent.getCaBundle(),fluent.getNamespace(),fluent.getPath(),fluent.getServer());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}