package io.fabric8.certmanager.api.model.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class JKSKeystoreBuilder extends JKSKeystoreFluent<JKSKeystoreBuilder> implements VisitableBuilder<JKSKeystore,JKSKeystoreBuilder>{
  public JKSKeystoreBuilder() {
    this(new JKSKeystore());
  }
  
  public JKSKeystoreBuilder(JKSKeystoreFluent<?> fluent) {
    this(fluent, new JKSKeystore());
  }
  
  public JKSKeystoreBuilder(JKSKeystoreFluent<?> fluent,JKSKeystore instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public JKSKeystoreBuilder(JKSKeystore instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  JKSKeystoreFluent<?> fluent;
  
  public JKSKeystore build() {
    JKSKeystore buildable = new JKSKeystore(fluent.getCreate(),fluent.buildPasswordSecretRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}