package io.fabric8.certmanager.api.model.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class CAIssuerBuilder extends CAIssuerFluent<CAIssuerBuilder> implements VisitableBuilder<CAIssuer,CAIssuerBuilder>{
  public CAIssuerBuilder() {
    this(new CAIssuer());
  }
  
  public CAIssuerBuilder(CAIssuerFluent<?> fluent) {
    this(fluent, new CAIssuer());
  }
  
  public CAIssuerBuilder(CAIssuerFluent<?> fluent,CAIssuer instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public CAIssuerBuilder(CAIssuer instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  CAIssuerFluent<?> fluent;
  
  public CAIssuer build() {
    CAIssuer buildable = new CAIssuer(fluent.getCrlDistributionPoints(),fluent.getOcspServers(),fluent.getSecretName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}