package io.fabric8.certmanager.api.model.acme.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class OrderSpecBuilder extends OrderSpecFluent<OrderSpecBuilder> implements VisitableBuilder<OrderSpec,OrderSpecBuilder>{
  public OrderSpecBuilder() {
    this(new OrderSpec());
  }
  
  public OrderSpecBuilder(OrderSpecFluent<?> fluent) {
    this(fluent, new OrderSpec());
  }
  
  public OrderSpecBuilder(OrderSpecFluent<?> fluent,OrderSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public OrderSpecBuilder(OrderSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  OrderSpecFluent<?> fluent;
  
  public OrderSpec build() {
    OrderSpec buildable = new OrderSpec(fluent.getCommonName(),fluent.getDnsNames(),fluent.getDuration(),fluent.getIpAddresses(),fluent.buildIssuerRef(),fluent.getRequest());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}