package io.fabric8.certmanager.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class CertmanagerSchemaBuilder extends CertmanagerSchemaFluent<CertmanagerSchemaBuilder> implements VisitableBuilder<CertmanagerSchema,CertmanagerSchemaBuilder>{
  public CertmanagerSchemaBuilder() {
    this(new CertmanagerSchema());
  }
  
  public CertmanagerSchemaBuilder(CertmanagerSchemaFluent<?> fluent) {
    this(fluent, new CertmanagerSchema());
  }
  
  public CertmanagerSchemaBuilder(CertmanagerSchemaFluent<?> fluent,CertmanagerSchema instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public CertmanagerSchemaBuilder(CertmanagerSchema instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  CertmanagerSchemaFluent<?> fluent;
  
  public CertmanagerSchema build() {
    CertmanagerSchema buildable = new CertmanagerSchema(fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEAuthorization(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallenge(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolver(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverDNS01(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01GatewayHTTPRoute(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01Ingress(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01IngressObjectMeta(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01IngressPodObjectMeta(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01IngressPodSpec(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01IngressPodTemplate(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEChallengeSolverHTTP01IngressTemplate(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEExternalAccountBinding(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuer(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderAcmeDNS(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderAkamai(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderAzureDNS(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderCloudDNS(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderCloudflare(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderDigitalOcean(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderRFC2136(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderRoute53(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerDNS01ProviderWebhook(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1beta1ACMEIssuerStatus(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1beta1AzureManagedIdentity(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1beta1CertificateDNSNameSelector(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1beta1Challenge(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1beta1ChallengeList(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1beta1ChallengeSpec(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1beta1ChallengeStatus(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1beta1Order(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1beta1OrderList(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1beta1OrderSpec(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1beta1OrderStatus(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CAIssuer(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1beta1Certificate(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateCondition(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateKeystores(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateList(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificatePrivateKey(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateRequest(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateRequestCondition(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateRequestList(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateRequestSpec(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateRequestStatus(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateSecretTemplate(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateSpec(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1beta1CertificateStatus(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1beta1ClusterIssuer(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1beta1ClusterIssuerList(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1beta1Issuer(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1beta1IssuerCondition(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1beta1IssuerList(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1beta1IssuerSpec(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1beta1IssuerStatus(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1beta1JKSKeystore(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1beta1PKCS12Keystore(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1beta1SelfSignedIssuer(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VaultAppRole(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VaultAuth(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VaultIssuer(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VaultKubernetesAuth(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VenafiCloud(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VenafiIssuer(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1beta1VenafiTPP(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1beta1X509Subject(),fluent.buildGithubComJetstackCertManagerPkgApisMetaV1LocalObjectReference(),fluent.buildGithubComJetstackCertManagerPkgApisMetaV1ObjectReference(),fluent.buildGithubComJetstackCertManagerPkgApisMetaV1SecretKeySelector());
    return buildable;
  }
  

}