/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.v1beta1;

import io.fabric8.certmanager.api.model.v1beta1.SelfSignedIssuer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class SelfSignedIssuerFluent<A extends SelfSignedIssuerFluent<A>>
extends BaseFluent<A> {
    private List<String> crlDistributionPoints = new ArrayList<String>();

    public SelfSignedIssuerFluent() {
    }

    public SelfSignedIssuerFluent(SelfSignedIssuer instance) {
        SelfSignedIssuer selfSignedIssuer = instance = instance != null ? instance : new SelfSignedIssuer();
        if (instance != null) {
            this.withCrlDistributionPoints(instance.getCrlDistributionPoints());
            this.withCrlDistributionPoints(instance.getCrlDistributionPoints());
        }
    }

    public A addToCrlDistributionPoints(int index, String item) {
        if (this.crlDistributionPoints == null) {
            this.crlDistributionPoints = new ArrayList<String>();
        }
        this.crlDistributionPoints.add(index, item);
        return (A)((Object)this);
    }

    public A setToCrlDistributionPoints(int index, String item) {
        if (this.crlDistributionPoints == null) {
            this.crlDistributionPoints = new ArrayList<String>();
        }
        this.crlDistributionPoints.set(index, item);
        return (A)((Object)this);
    }

    public A addToCrlDistributionPoints(String ... items) {
        if (this.crlDistributionPoints == null) {
            this.crlDistributionPoints = new ArrayList<String>();
        }
        for (String item : items) {
            this.crlDistributionPoints.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToCrlDistributionPoints(Collection<String> items) {
        if (this.crlDistributionPoints == null) {
            this.crlDistributionPoints = new ArrayList<String>();
        }
        for (String item : items) {
            this.crlDistributionPoints.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromCrlDistributionPoints(String ... items) {
        if (this.crlDistributionPoints == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.crlDistributionPoints.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromCrlDistributionPoints(Collection<String> items) {
        if (this.crlDistributionPoints == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.crlDistributionPoints.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getCrlDistributionPoints() {
        return this.crlDistributionPoints;
    }

    public String getCrlDistributionPoint(int index) {
        return this.crlDistributionPoints.get(index);
    }

    public String getFirstCrlDistributionPoint() {
        return this.crlDistributionPoints.get(0);
    }

    public String getLastCrlDistributionPoint() {
        return this.crlDistributionPoints.get(this.crlDistributionPoints.size() - 1);
    }

    public String getMatchingCrlDistributionPoint(Predicate<String> predicate) {
        for (String item : this.crlDistributionPoints) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCrlDistributionPoint(Predicate<String> predicate) {
        for (String item : this.crlDistributionPoints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCrlDistributionPoints(List<String> crlDistributionPoints) {
        if (crlDistributionPoints != null) {
            this.crlDistributionPoints = new ArrayList<String>();
            for (String item : crlDistributionPoints) {
                this.addToCrlDistributionPoints(item);
            }
        } else {
            this.crlDistributionPoints = null;
        }
        return (A)((Object)this);
    }

    public A withCrlDistributionPoints(String ... crlDistributionPoints) {
        if (this.crlDistributionPoints != null) {
            this.crlDistributionPoints.clear();
            this._visitables.remove((Object)"crlDistributionPoints");
        }
        if (crlDistributionPoints != null) {
            for (String item : crlDistributionPoints) {
                this.addToCrlDistributionPoints(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasCrlDistributionPoints() {
        return this.crlDistributionPoints != null && !this.crlDistributionPoints.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SelfSignedIssuerFluent that = (SelfSignedIssuerFluent)((Object)o);
        return Objects.equals(this.crlDistributionPoints, that.crlDistributionPoints);
    }

    public int hashCode() {
        return Objects.hash(this.crlDistributionPoints, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.crlDistributionPoints != null && !this.crlDistributionPoints.isEmpty()) {
            sb.append("crlDistributionPoints:");
            sb.append(this.crlDistributionPoints);
        }
        sb.append("}");
        return sb.toString();
    }
}

