/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.v1beta1;

import io.fabric8.certmanager.api.model.meta.v1.ObjectReference;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceFluent;
import io.fabric8.certmanager.api.model.v1beta1.CertificateRequestSpec;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class CertificateRequestSpecFluent<A extends CertificateRequestSpecFluent<A>>
extends BaseFluent<A> {
    private Duration duration;
    private Boolean isCA;
    private ObjectReferenceBuilder issuerRef;
    private String request;
    private List<String> usages;

    public CertificateRequestSpecFluent() {
    }

    public CertificateRequestSpecFluent(CertificateRequestSpec instance) {
        CertificateRequestSpec certificateRequestSpec = instance = instance != null ? instance : new CertificateRequestSpec();
        if (instance != null) {
            this.withDuration(instance.getDuration());
            this.withIsCA(instance.getIsCA());
            this.withIssuerRef(instance.getIssuerRef());
            this.withRequest(instance.getRequest());
            this.withUsages(instance.getUsages());
            this.withDuration(instance.getDuration());
            this.withIsCA(instance.getIsCA());
            this.withIssuerRef(instance.getIssuerRef());
            this.withRequest(instance.getRequest());
            this.withUsages(instance.getUsages());
        }
    }

    public Duration getDuration() {
        return this.duration;
    }

    public A withDuration(Duration duration) {
        this.duration = duration;
        return (A)((Object)this);
    }

    public boolean hasDuration() {
        return this.duration != null;
    }

    public Boolean getIsCA() {
        return this.isCA;
    }

    public A withIsCA(Boolean isCA) {
        this.isCA = isCA;
        return (A)((Object)this);
    }

    public boolean hasIsCA() {
        return this.isCA != null;
    }

    public ObjectReference buildIssuerRef() {
        return this.issuerRef != null ? this.issuerRef.build() : null;
    }

    public A withIssuerRef(ObjectReference issuerRef) {
        this._visitables.get((Object)"issuerRef").remove((Object)this.issuerRef);
        if (issuerRef != null) {
            this.issuerRef = new ObjectReferenceBuilder(issuerRef);
            this._visitables.get((Object)"issuerRef").add(this.issuerRef);
        } else {
            this.issuerRef = null;
            this._visitables.get((Object)"issuerRef").remove((Object)this.issuerRef);
        }
        return (A)((Object)this);
    }

    public boolean hasIssuerRef() {
        return this.issuerRef != null;
    }

    public A withNewIssuerRef(String group, String kind, String name) {
        return this.withIssuerRef(new ObjectReference(group, kind, name));
    }

    public IssuerRefNested<A> withNewIssuerRef() {
        return new IssuerRefNested(null);
    }

    public IssuerRefNested<A> withNewIssuerRefLike(ObjectReference item) {
        return new IssuerRefNested(item);
    }

    public IssuerRefNested<A> editIssuerRef() {
        return this.withNewIssuerRefLike(Optional.ofNullable(this.buildIssuerRef()).orElse(null));
    }

    public IssuerRefNested<A> editOrNewIssuerRef() {
        return this.withNewIssuerRefLike(Optional.ofNullable(this.buildIssuerRef()).orElse(new ObjectReferenceBuilder().build()));
    }

    public IssuerRefNested<A> editOrNewIssuerRefLike(ObjectReference item) {
        return this.withNewIssuerRefLike(Optional.ofNullable(this.buildIssuerRef()).orElse(item));
    }

    public String getRequest() {
        return this.request;
    }

    public A withRequest(String request) {
        this.request = request;
        return (A)((Object)this);
    }

    public boolean hasRequest() {
        return this.request != null;
    }

    public A addToUsages(int index, String item) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        this.usages.add(index, item);
        return (A)((Object)this);
    }

    public A setToUsages(int index, String item) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        this.usages.set(index, item);
        return (A)((Object)this);
    }

    public A addToUsages(String ... items) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        for (String item : items) {
            this.usages.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToUsages(Collection<String> items) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        for (String item : items) {
            this.usages.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromUsages(String ... items) {
        if (this.usages == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.usages.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromUsages(Collection<String> items) {
        if (this.usages == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.usages.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getUsages() {
        return this.usages;
    }

    public String getUsage(int index) {
        return this.usages.get(index);
    }

    public String getFirstUsage() {
        return this.usages.get(0);
    }

    public String getLastUsage() {
        return this.usages.get(this.usages.size() - 1);
    }

    public String getMatchingUsage(Predicate<String> predicate) {
        for (String item : this.usages) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingUsage(Predicate<String> predicate) {
        for (String item : this.usages) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withUsages(List<String> usages) {
        if (usages != null) {
            this.usages = new ArrayList<String>();
            for (String item : usages) {
                this.addToUsages(item);
            }
        } else {
            this.usages = null;
        }
        return (A)((Object)this);
    }

    public A withUsages(String ... usages) {
        if (this.usages != null) {
            this.usages.clear();
            this._visitables.remove((Object)"usages");
        }
        if (usages != null) {
            for (String item : usages) {
                this.addToUsages(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasUsages() {
        return this.usages != null && !this.usages.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CertificateRequestSpecFluent that = (CertificateRequestSpecFluent)((Object)o);
        if (!Objects.equals(this.duration, that.duration)) {
            return false;
        }
        if (!Objects.equals(this.isCA, that.isCA)) {
            return false;
        }
        if (!Objects.equals((Object)this.issuerRef, (Object)that.issuerRef)) {
            return false;
        }
        if (!Objects.equals(this.request, that.request)) {
            return false;
        }
        return Objects.equals(this.usages, that.usages);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.duration, this.isCA, this.issuerRef, this.request, this.usages, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.duration != null) {
            sb.append("duration:");
            sb.append(this.duration + ",");
        }
        if (this.isCA != null) {
            sb.append("isCA:");
            sb.append(this.isCA + ",");
        }
        if (this.issuerRef != null) {
            sb.append("issuerRef:");
            sb.append((Object)((Object)this.issuerRef) + ",");
        }
        if (this.request != null) {
            sb.append("request:");
            sb.append(this.request + ",");
        }
        if (this.usages != null && !this.usages.isEmpty()) {
            sb.append("usages:");
            sb.append(this.usages);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withIsCA() {
        return this.withIsCA(true);
    }

    public class IssuerRefNested<N>
    extends ObjectReferenceFluent<IssuerRefNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        IssuerRefNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        public N and() {
            return (N)CertificateRequestSpecFluent.this.withIssuerRef(this.builder.build());
        }

        public N endIssuerRef() {
            return this.and();
        }
    }
}

