/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.acme.v1beta1;

import io.fabric8.certmanager.api.model.acme.v1beta1.ACMEExternalAccountBinding;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;
import java.util.Optional;

public class ACMEExternalAccountBindingFluent<A extends ACMEExternalAccountBindingFluent<A>>
extends BaseFluent<A> {
    private String keyAlgorithm;
    private String keyID;
    private SecretKeySelectorBuilder keySecretRef;

    public ACMEExternalAccountBindingFluent() {
    }

    public ACMEExternalAccountBindingFluent(ACMEExternalAccountBinding instance) {
        ACMEExternalAccountBinding aCMEExternalAccountBinding = instance = instance != null ? instance : new ACMEExternalAccountBinding();
        if (instance != null) {
            this.withKeyAlgorithm(instance.getKeyAlgorithm());
            this.withKeyID(instance.getKeyID());
            this.withKeySecretRef(instance.getKeySecretRef());
            this.withKeyAlgorithm(instance.getKeyAlgorithm());
            this.withKeyID(instance.getKeyID());
            this.withKeySecretRef(instance.getKeySecretRef());
        }
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public A withKeyAlgorithm(String keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
        return (A)((Object)this);
    }

    public boolean hasKeyAlgorithm() {
        return this.keyAlgorithm != null;
    }

    public String getKeyID() {
        return this.keyID;
    }

    public A withKeyID(String keyID) {
        this.keyID = keyID;
        return (A)((Object)this);
    }

    public boolean hasKeyID() {
        return this.keyID != null;
    }

    public SecretKeySelector buildKeySecretRef() {
        return this.keySecretRef != null ? this.keySecretRef.build() : null;
    }

    public A withKeySecretRef(SecretKeySelector keySecretRef) {
        this._visitables.get((Object)"keySecretRef").remove((Object)this.keySecretRef);
        if (keySecretRef != null) {
            this.keySecretRef = new SecretKeySelectorBuilder(keySecretRef);
            this._visitables.get((Object)"keySecretRef").add(this.keySecretRef);
        } else {
            this.keySecretRef = null;
            this._visitables.get((Object)"keySecretRef").remove((Object)this.keySecretRef);
        }
        return (A)((Object)this);
    }

    public boolean hasKeySecretRef() {
        return this.keySecretRef != null;
    }

    public A withNewKeySecretRef(String key, String name) {
        return this.withKeySecretRef(new SecretKeySelector(key, name));
    }

    public KeySecretRefNested<A> withNewKeySecretRef() {
        return new KeySecretRefNested(null);
    }

    public KeySecretRefNested<A> withNewKeySecretRefLike(SecretKeySelector item) {
        return new KeySecretRefNested(item);
    }

    public KeySecretRefNested<A> editKeySecretRef() {
        return this.withNewKeySecretRefLike(Optional.ofNullable(this.buildKeySecretRef()).orElse(null));
    }

    public KeySecretRefNested<A> editOrNewKeySecretRef() {
        return this.withNewKeySecretRefLike(Optional.ofNullable(this.buildKeySecretRef()).orElse(new SecretKeySelectorBuilder().build()));
    }

    public KeySecretRefNested<A> editOrNewKeySecretRefLike(SecretKeySelector item) {
        return this.withNewKeySecretRefLike(Optional.ofNullable(this.buildKeySecretRef()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ACMEExternalAccountBindingFluent that = (ACMEExternalAccountBindingFluent)((Object)o);
        if (!Objects.equals(this.keyAlgorithm, that.keyAlgorithm)) {
            return false;
        }
        if (!Objects.equals(this.keyID, that.keyID)) {
            return false;
        }
        return Objects.equals((Object)this.keySecretRef, (Object)that.keySecretRef);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.keyAlgorithm, this.keyID, this.keySecretRef, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.keyAlgorithm != null) {
            sb.append("keyAlgorithm:");
            sb.append(this.keyAlgorithm + ",");
        }
        if (this.keyID != null) {
            sb.append("keyID:");
            sb.append(this.keyID + ",");
        }
        if (this.keySecretRef != null) {
            sb.append("keySecretRef:");
            sb.append((Object)this.keySecretRef);
        }
        sb.append("}");
        return sb.toString();
    }

    public class KeySecretRefNested<N>
    extends SecretKeySelectorFluent<KeySecretRefNested<N>>
    implements Nested<N> {
        SecretKeySelectorBuilder builder;

        KeySecretRefNested(SecretKeySelector item) {
            this.builder = new SecretKeySelectorBuilder(this, item);
        }

        public N and() {
            return (N)ACMEExternalAccountBindingFluent.this.withKeySecretRef(this.builder.build());
        }

        public N endKeySecretRef() {
            return this.and();
        }
    }
}

