/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.v1beta1;

import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluentImpl;
import io.fabric8.certmanager.api.model.v1beta1.PKCS12Keystore;
import io.fabric8.certmanager.api.model.v1beta1.PKCS12KeystoreFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;

public class PKCS12KeystoreFluentImpl<A extends PKCS12KeystoreFluent<A>>
extends BaseFluent<A>
implements PKCS12KeystoreFluent<A> {
    private Boolean create;
    private SecretKeySelectorBuilder passwordSecretRef;

    public PKCS12KeystoreFluentImpl() {
    }

    public PKCS12KeystoreFluentImpl(PKCS12Keystore instance) {
        if (instance != null) {
            this.withCreate(instance.getCreate());
            this.withPasswordSecretRef(instance.getPasswordSecretRef());
        }
    }

    @Override
    public Boolean getCreate() {
        return this.create;
    }

    @Override
    public A withCreate(Boolean create) {
        this.create = create;
        return (A)this;
    }

    @Override
    public Boolean hasCreate() {
        return this.create != null;
    }

    @Override
    @Deprecated
    public SecretKeySelector getPasswordSecretRef() {
        return this.passwordSecretRef != null ? this.passwordSecretRef.build() : null;
    }

    @Override
    public SecretKeySelector buildPasswordSecretRef() {
        return this.passwordSecretRef != null ? this.passwordSecretRef.build() : null;
    }

    @Override
    public A withPasswordSecretRef(SecretKeySelector passwordSecretRef) {
        this._visitables.get((Object)"passwordSecretRef").remove(this.passwordSecretRef);
        if (passwordSecretRef != null) {
            this.passwordSecretRef = new SecretKeySelectorBuilder(passwordSecretRef);
            this._visitables.get((Object)"passwordSecretRef").add(this.passwordSecretRef);
        } else {
            this.passwordSecretRef = null;
            this._visitables.get((Object)"passwordSecretRef").remove(this.passwordSecretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPasswordSecretRef() {
        return this.passwordSecretRef != null;
    }

    @Override
    public A withNewPasswordSecretRef(String key, String name) {
        return this.withPasswordSecretRef(new SecretKeySelector(key, name));
    }

    @Override
    public PKCS12KeystoreFluent.PasswordSecretRefNested<A> withNewPasswordSecretRef() {
        return new PasswordSecretRefNestedImpl();
    }

    @Override
    public PKCS12KeystoreFluent.PasswordSecretRefNested<A> withNewPasswordSecretRefLike(SecretKeySelector item) {
        return new PasswordSecretRefNestedImpl(item);
    }

    @Override
    public PKCS12KeystoreFluent.PasswordSecretRefNested<A> editPasswordSecretRef() {
        return this.withNewPasswordSecretRefLike(this.getPasswordSecretRef());
    }

    @Override
    public PKCS12KeystoreFluent.PasswordSecretRefNested<A> editOrNewPasswordSecretRef() {
        return this.withNewPasswordSecretRefLike(this.getPasswordSecretRef() != null ? this.getPasswordSecretRef() : new SecretKeySelectorBuilder().build());
    }

    @Override
    public PKCS12KeystoreFluent.PasswordSecretRefNested<A> editOrNewPasswordSecretRefLike(SecretKeySelector item) {
        return this.withNewPasswordSecretRefLike(this.getPasswordSecretRef() != null ? this.getPasswordSecretRef() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PKCS12KeystoreFluentImpl that = (PKCS12KeystoreFluentImpl)o;
        if (!Objects.equals(this.create, that.create)) {
            return false;
        }
        return Objects.equals(this.passwordSecretRef, that.passwordSecretRef);
    }

    public int hashCode() {
        return Objects.hash(this.create, this.passwordSecretRef, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.create != null) {
            sb.append("create:");
            sb.append(this.create + ",");
        }
        if (this.passwordSecretRef != null) {
            sb.append("passwordSecretRef:");
            sb.append(this.passwordSecretRef);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withCreate() {
        return this.withCreate(true);
    }

    class PasswordSecretRefNestedImpl<N>
    extends SecretKeySelectorFluentImpl<PKCS12KeystoreFluent.PasswordSecretRefNested<N>>
    implements PKCS12KeystoreFluent.PasswordSecretRefNested<N>,
    Nested<N> {
        SecretKeySelectorBuilder builder;

        PasswordSecretRefNestedImpl(SecretKeySelector item) {
            this.builder = new SecretKeySelectorBuilder(this, item);
        }

        PasswordSecretRefNestedImpl() {
            this.builder = new SecretKeySelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)PKCS12KeystoreFluentImpl.this.withPasswordSecretRef(this.builder.build());
        }

        @Override
        public N endPasswordSecretRef() {
            return this.and();
        }
    }
}

