/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.acme.v1beta1;

import io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorization;
import io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorizationBuilder;
import io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorizationFluentImpl;
import io.fabric8.certmanager.api.model.acme.v1beta1.OrderStatus;
import io.fabric8.certmanager.api.model.acme.v1beta1.OrderStatusFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class OrderStatusFluentImpl<A extends OrderStatusFluent<A>>
extends BaseFluent<A>
implements OrderStatusFluent<A> {
    private ArrayList<ACMEAuthorizationBuilder> authorizations = new ArrayList();
    private String certificate;
    private String failureTime;
    private String finalizeURL;
    private String reason;
    private String state;
    private String url;

    public OrderStatusFluentImpl() {
    }

    public OrderStatusFluentImpl(OrderStatus instance) {
        if (instance != null) {
            this.withAuthorizations(instance.getAuthorizations());
            this.withCertificate(instance.getCertificate());
            this.withFailureTime(instance.getFailureTime());
            this.withFinalizeURL(instance.getFinalizeURL());
            this.withReason(instance.getReason());
            this.withState(instance.getState());
            this.withUrl(instance.getUrl());
        }
    }

    @Override
    public A addToAuthorizations(int index, ACMEAuthorization item) {
        if (this.authorizations == null) {
            this.authorizations = new ArrayList();
        }
        ACMEAuthorizationBuilder builder = new ACMEAuthorizationBuilder(item);
        if (index < 0 || index >= this.authorizations.size()) {
            this._visitables.get((Object)"authorizations").add(builder);
            this.authorizations.add(builder);
        } else {
            this._visitables.get((Object)"authorizations").add(index, builder);
            this.authorizations.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToAuthorizations(int index, ACMEAuthorization item) {
        if (this.authorizations == null) {
            this.authorizations = new ArrayList();
        }
        ACMEAuthorizationBuilder builder = new ACMEAuthorizationBuilder(item);
        if (index < 0 || index >= this.authorizations.size()) {
            this._visitables.get((Object)"authorizations").add(builder);
            this.authorizations.add(builder);
        } else {
            this._visitables.get((Object)"authorizations").set(index, builder);
            this.authorizations.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAuthorizations(ACMEAuthorization ... items) {
        if (this.authorizations == null) {
            this.authorizations = new ArrayList();
        }
        for (ACMEAuthorization item : items) {
            ACMEAuthorizationBuilder builder = new ACMEAuthorizationBuilder(item);
            this._visitables.get((Object)"authorizations").add(builder);
            this.authorizations.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAuthorizations(Collection<ACMEAuthorization> items) {
        if (this.authorizations == null) {
            this.authorizations = new ArrayList();
        }
        for (ACMEAuthorization item : items) {
            ACMEAuthorizationBuilder builder = new ACMEAuthorizationBuilder(item);
            this._visitables.get((Object)"authorizations").add(builder);
            this.authorizations.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAuthorizations(ACMEAuthorization ... items) {
        for (ACMEAuthorization item : items) {
            ACMEAuthorizationBuilder builder = new ACMEAuthorizationBuilder(item);
            this._visitables.get((Object)"authorizations").remove(builder);
            if (this.authorizations == null) continue;
            this.authorizations.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAuthorizations(Collection<ACMEAuthorization> items) {
        for (ACMEAuthorization item : items) {
            ACMEAuthorizationBuilder builder = new ACMEAuthorizationBuilder(item);
            this._visitables.get((Object)"authorizations").remove(builder);
            if (this.authorizations == null) continue;
            this.authorizations.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromAuthorizations(Predicate<ACMEAuthorizationBuilder> predicate) {
        if (this.authorizations == null) {
            return (A)this;
        }
        Iterator<ACMEAuthorizationBuilder> each = this.authorizations.iterator();
        List visitables = this._visitables.get((Object)"authorizations");
        while (each.hasNext()) {
            ACMEAuthorizationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ACMEAuthorization> getAuthorizations() {
        return this.authorizations != null ? OrderStatusFluentImpl.build(this.authorizations) : null;
    }

    @Override
    public List<ACMEAuthorization> buildAuthorizations() {
        return this.authorizations != null ? OrderStatusFluentImpl.build(this.authorizations) : null;
    }

    @Override
    public ACMEAuthorization buildAuthorization(int index) {
        return this.authorizations.get(index).build();
    }

    @Override
    public ACMEAuthorization buildFirstAuthorization() {
        return this.authorizations.get(0).build();
    }

    @Override
    public ACMEAuthorization buildLastAuthorization() {
        return this.authorizations.get(this.authorizations.size() - 1).build();
    }

    @Override
    public ACMEAuthorization buildMatchingAuthorization(Predicate<ACMEAuthorizationBuilder> predicate) {
        for (ACMEAuthorizationBuilder item : this.authorizations) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAuthorization(Predicate<ACMEAuthorizationBuilder> predicate) {
        for (ACMEAuthorizationBuilder item : this.authorizations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAuthorizations(List<ACMEAuthorization> authorizations) {
        if (this.authorizations != null) {
            this._visitables.get((Object)"authorizations").clear();
        }
        if (authorizations != null) {
            this.authorizations = new ArrayList();
            for (ACMEAuthorization item : authorizations) {
                this.addToAuthorizations(item);
            }
        } else {
            this.authorizations = null;
        }
        return (A)this;
    }

    @Override
    public A withAuthorizations(ACMEAuthorization ... authorizations) {
        if (this.authorizations != null) {
            this.authorizations.clear();
            this._visitables.remove((Object)"authorizations");
        }
        if (authorizations != null) {
            for (ACMEAuthorization item : authorizations) {
                this.addToAuthorizations(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAuthorizations() {
        return this.authorizations != null && !this.authorizations.isEmpty();
    }

    @Override
    public OrderStatusFluent.AuthorizationsNested<A> addNewAuthorization() {
        return new AuthorizationsNestedImpl();
    }

    @Override
    public OrderStatusFluent.AuthorizationsNested<A> addNewAuthorizationLike(ACMEAuthorization item) {
        return new AuthorizationsNestedImpl(-1, item);
    }

    @Override
    public OrderStatusFluent.AuthorizationsNested<A> setNewAuthorizationLike(int index, ACMEAuthorization item) {
        return new AuthorizationsNestedImpl(index, item);
    }

    @Override
    public OrderStatusFluent.AuthorizationsNested<A> editAuthorization(int index) {
        if (this.authorizations.size() <= index) {
            throw new RuntimeException("Can't edit authorizations. Index exceeds size.");
        }
        return this.setNewAuthorizationLike(index, this.buildAuthorization(index));
    }

    @Override
    public OrderStatusFluent.AuthorizationsNested<A> editFirstAuthorization() {
        if (this.authorizations.size() == 0) {
            throw new RuntimeException("Can't edit first authorizations. The list is empty.");
        }
        return this.setNewAuthorizationLike(0, this.buildAuthorization(0));
    }

    @Override
    public OrderStatusFluent.AuthorizationsNested<A> editLastAuthorization() {
        int index = this.authorizations.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last authorizations. The list is empty.");
        }
        return this.setNewAuthorizationLike(index, this.buildAuthorization(index));
    }

    @Override
    public OrderStatusFluent.AuthorizationsNested<A> editMatchingAuthorization(Predicate<ACMEAuthorizationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.authorizations.size(); ++i) {
            if (!predicate.test(this.authorizations.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching authorizations. No match found.");
        }
        return this.setNewAuthorizationLike(index, this.buildAuthorization(index));
    }

    @Override
    public String getCertificate() {
        return this.certificate;
    }

    @Override
    public A withCertificate(String certificate) {
        this.certificate = certificate;
        return (A)this;
    }

    @Override
    public Boolean hasCertificate() {
        return this.certificate != null;
    }

    @Override
    public String getFailureTime() {
        return this.failureTime;
    }

    @Override
    public A withFailureTime(String failureTime) {
        this.failureTime = failureTime;
        return (A)this;
    }

    @Override
    public Boolean hasFailureTime() {
        return this.failureTime != null;
    }

    @Override
    public String getFinalizeURL() {
        return this.finalizeURL;
    }

    @Override
    public A withFinalizeURL(String finalizeURL) {
        this.finalizeURL = finalizeURL;
        return (A)this;
    }

    @Override
    public Boolean hasFinalizeURL() {
        return this.finalizeURL != null;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public A withReason(String reason) {
        this.reason = reason;
        return (A)this;
    }

    @Override
    public Boolean hasReason() {
        return this.reason != null;
    }

    @Override
    public String getState() {
        return this.state;
    }

    @Override
    public A withState(String state) {
        this.state = state;
        return (A)this;
    }

    @Override
    public Boolean hasState() {
        return this.state != null;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public A withUrl(String url) {
        this.url = url;
        return (A)this;
    }

    @Override
    public Boolean hasUrl() {
        return this.url != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OrderStatusFluentImpl that = (OrderStatusFluentImpl)o;
        if (!Objects.equals(this.authorizations, that.authorizations)) {
            return false;
        }
        if (!Objects.equals(this.certificate, that.certificate)) {
            return false;
        }
        if (!Objects.equals(this.failureTime, that.failureTime)) {
            return false;
        }
        if (!Objects.equals(this.finalizeURL, that.finalizeURL)) {
            return false;
        }
        if (!Objects.equals(this.reason, that.reason)) {
            return false;
        }
        if (!Objects.equals(this.state, that.state)) {
            return false;
        }
        return Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(this.authorizations, this.certificate, this.failureTime, this.finalizeURL, this.reason, this.state, this.url, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.authorizations != null) {
            sb.append("authorizations:");
            sb.append(this.authorizations + ",");
        }
        if (this.certificate != null) {
            sb.append("certificate:");
            sb.append(this.certificate + ",");
        }
        if (this.failureTime != null) {
            sb.append("failureTime:");
            sb.append(this.failureTime + ",");
        }
        if (this.finalizeURL != null) {
            sb.append("finalizeURL:");
            sb.append(this.finalizeURL + ",");
        }
        if (this.reason != null) {
            sb.append("reason:");
            sb.append(this.reason + ",");
        }
        if (this.state != null) {
            sb.append("state:");
            sb.append(this.state + ",");
        }
        if (this.url != null) {
            sb.append("url:");
            sb.append(this.url);
        }
        sb.append("}");
        return sb.toString();
    }

    class AuthorizationsNestedImpl<N>
    extends ACMEAuthorizationFluentImpl<OrderStatusFluent.AuthorizationsNested<N>>
    implements OrderStatusFluent.AuthorizationsNested<N>,
    Nested<N> {
        ACMEAuthorizationBuilder builder;
        int index;

        AuthorizationsNestedImpl(int index, ACMEAuthorization item) {
            this.index = index;
            this.builder = new ACMEAuthorizationBuilder(this, item);
        }

        AuthorizationsNestedImpl() {
            this.index = -1;
            this.builder = new ACMEAuthorizationBuilder(this);
        }

        @Override
        public N and() {
            return (N)OrderStatusFluentImpl.this.setToAuthorizations(this.index, this.builder.build());
        }

        @Override
        public N endAuthorization() {
            return this.and();
        }
    }
}

