/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.acme.v1beta1;

import io.fabric8.certmanager.api.model.acme.v1beta1.CertificateDNSNameSelector;
import io.fabric8.certmanager.api.model.acme.v1beta1.CertificateDNSNameSelectorFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class CertificateDNSNameSelectorFluentImpl<A extends CertificateDNSNameSelectorFluent<A>>
extends BaseFluent<A>
implements CertificateDNSNameSelectorFluent<A> {
    private List<String> dnsNames = new ArrayList<String>();
    private List<String> dnsZones = new ArrayList<String>();
    private Map<String, String> matchLabels;

    public CertificateDNSNameSelectorFluentImpl() {
    }

    public CertificateDNSNameSelectorFluentImpl(CertificateDNSNameSelector instance) {
        if (instance != null) {
            this.withDnsNames(instance.getDnsNames());
            this.withDnsZones(instance.getDnsZones());
            this.withMatchLabels(instance.getMatchLabels());
        }
    }

    @Override
    public A addToDnsNames(int index, String item) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        this.dnsNames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToDnsNames(int index, String item) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        this.dnsNames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToDnsNames(String ... items) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.dnsNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToDnsNames(Collection<String> items) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.dnsNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromDnsNames(String ... items) {
        for (String item : items) {
            if (this.dnsNames == null) continue;
            this.dnsNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDnsNames(Collection<String> items) {
        for (String item : items) {
            if (this.dnsNames == null) continue;
            this.dnsNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getDnsNames() {
        return this.dnsNames;
    }

    @Override
    public String getDnsName(int index) {
        return this.dnsNames.get(index);
    }

    @Override
    public String getFirstDnsName() {
        return this.dnsNames.get(0);
    }

    @Override
    public String getLastDnsName() {
        return this.dnsNames.get(this.dnsNames.size() - 1);
    }

    @Override
    public String getMatchingDnsName(Predicate<String> predicate) {
        for (String item : this.dnsNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingDnsName(Predicate<String> predicate) {
        for (String item : this.dnsNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withDnsNames(List<String> dnsNames) {
        if (dnsNames != null) {
            this.dnsNames = new ArrayList<String>();
            for (String item : dnsNames) {
                this.addToDnsNames(item);
            }
        } else {
            this.dnsNames = null;
        }
        return (A)this;
    }

    @Override
    public A withDnsNames(String ... dnsNames) {
        if (this.dnsNames != null) {
            this.dnsNames.clear();
            this._visitables.remove((Object)"dnsNames");
        }
        if (dnsNames != null) {
            for (String item : dnsNames) {
                this.addToDnsNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDnsNames() {
        return this.dnsNames != null && !this.dnsNames.isEmpty();
    }

    @Override
    public A addToDnsZones(int index, String item) {
        if (this.dnsZones == null) {
            this.dnsZones = new ArrayList<String>();
        }
        this.dnsZones.add(index, item);
        return (A)this;
    }

    @Override
    public A setToDnsZones(int index, String item) {
        if (this.dnsZones == null) {
            this.dnsZones = new ArrayList<String>();
        }
        this.dnsZones.set(index, item);
        return (A)this;
    }

    @Override
    public A addToDnsZones(String ... items) {
        if (this.dnsZones == null) {
            this.dnsZones = new ArrayList<String>();
        }
        for (String item : items) {
            this.dnsZones.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToDnsZones(Collection<String> items) {
        if (this.dnsZones == null) {
            this.dnsZones = new ArrayList<String>();
        }
        for (String item : items) {
            this.dnsZones.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromDnsZones(String ... items) {
        for (String item : items) {
            if (this.dnsZones == null) continue;
            this.dnsZones.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDnsZones(Collection<String> items) {
        for (String item : items) {
            if (this.dnsZones == null) continue;
            this.dnsZones.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getDnsZones() {
        return this.dnsZones;
    }

    @Override
    public String getDnsZone(int index) {
        return this.dnsZones.get(index);
    }

    @Override
    public String getFirstDnsZone() {
        return this.dnsZones.get(0);
    }

    @Override
    public String getLastDnsZone() {
        return this.dnsZones.get(this.dnsZones.size() - 1);
    }

    @Override
    public String getMatchingDnsZone(Predicate<String> predicate) {
        for (String item : this.dnsZones) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingDnsZone(Predicate<String> predicate) {
        for (String item : this.dnsZones) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withDnsZones(List<String> dnsZones) {
        if (dnsZones != null) {
            this.dnsZones = new ArrayList<String>();
            for (String item : dnsZones) {
                this.addToDnsZones(item);
            }
        } else {
            this.dnsZones = null;
        }
        return (A)this;
    }

    @Override
    public A withDnsZones(String ... dnsZones) {
        if (this.dnsZones != null) {
            this.dnsZones.clear();
            this._visitables.remove((Object)"dnsZones");
        }
        if (dnsZones != null) {
            for (String item : dnsZones) {
                this.addToDnsZones(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDnsZones() {
        return this.dnsZones != null && !this.dnsZones.isEmpty();
    }

    @Override
    public A addToMatchLabels(String key, String value) {
        if (this.matchLabels == null && key != null && value != null) {
            this.matchLabels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.matchLabels.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToMatchLabels(Map<String, String> map) {
        if (this.matchLabels == null && map != null) {
            this.matchLabels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.matchLabels.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromMatchLabels(String key) {
        if (this.matchLabels == null) {
            return (A)this;
        }
        if (key != null && this.matchLabels != null) {
            this.matchLabels.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromMatchLabels(Map<String, String> map) {
        if (this.matchLabels == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.matchLabels == null) continue;
                this.matchLabels.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getMatchLabels() {
        return this.matchLabels;
    }

    @Override
    public <K, V> A withMatchLabels(Map<String, String> matchLabels) {
        this.matchLabels = matchLabels == null ? null : new LinkedHashMap<String, String>(matchLabels);
        return (A)this;
    }

    @Override
    public Boolean hasMatchLabels() {
        return this.matchLabels != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CertificateDNSNameSelectorFluentImpl that = (CertificateDNSNameSelectorFluentImpl)o;
        if (!Objects.equals(this.dnsNames, that.dnsNames)) {
            return false;
        }
        if (!Objects.equals(this.dnsZones, that.dnsZones)) {
            return false;
        }
        return Objects.equals(this.matchLabels, that.matchLabels);
    }

    public int hashCode() {
        return Objects.hash(this.dnsNames, this.dnsZones, this.matchLabels, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dnsNames != null && !this.dnsNames.isEmpty()) {
            sb.append("dnsNames:");
            sb.append(this.dnsNames + ",");
        }
        if (this.dnsZones != null && !this.dnsZones.isEmpty()) {
            sb.append("dnsZones:");
            sb.append(this.dnsZones + ",");
        }
        if (this.matchLabels != null && !this.matchLabels.isEmpty()) {
            sb.append("matchLabels:");
            sb.append(this.matchLabels);
        }
        sb.append("}");
        return sb.toString();
    }
}

