package io.fabric8.certmanager.api.model.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VaultAuthBuilder extends VaultAuthFluentImpl<VaultAuthBuilder> implements VisitableBuilder<VaultAuth,VaultAuthBuilder>{
  public VaultAuthBuilder() {
    this(false);
  }
  public VaultAuthBuilder(Boolean validationEnabled) {
    this(new VaultAuth(), validationEnabled);
  }
  public VaultAuthBuilder(VaultAuthFluent<?> fluent) {
    this(fluent, false);
  }
  public VaultAuthBuilder(VaultAuthFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VaultAuth(), validationEnabled);
  }
  public VaultAuthBuilder(VaultAuthFluent<?> fluent,VaultAuth instance) {
    this(fluent, instance, false);
  }
  public VaultAuthBuilder(VaultAuthFluent<?> fluent,VaultAuth instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAppRole(instance.getAppRole());
      fluent.withKubernetes(instance.getKubernetes());
      fluent.withTokenSecretRef(instance.getTokenSecretRef());
    }
    this.validationEnabled = validationEnabled; 
  }
  public VaultAuthBuilder(VaultAuth instance) {
    this(instance,false);
  }
  public VaultAuthBuilder(VaultAuth instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAppRole(instance.getAppRole());
      this.withKubernetes(instance.getKubernetes());
      this.withTokenSecretRef(instance.getTokenSecretRef());
    }
    this.validationEnabled = validationEnabled; 
  }
  VaultAuthFluent<?> fluent;
  Boolean validationEnabled;
  public VaultAuth build() {
    VaultAuth buildable = new VaultAuth(fluent.getAppRole(),fluent.getKubernetes(),fluent.getTokenSecretRef());
    return buildable;
  }
  
}