package io.fabric8.certmanager.api.model.v1beta1;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReference;
import java.lang.Deprecated;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.Integer;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceFluent;
import java.util.Collection;

 /**
  * Generated
  */
public interface CertificateSpecFluent<A extends CertificateSpecFluent<A>> extends Fluent<A>{
  public String getCommonName();
  public A withCommonName(String commonName);
  public Boolean hasCommonName();
  public A addToDnsNames(int index,String item);
  public A setToDnsNames(int index,String item);
  public A addToDnsNames(java.lang.String... items);
  public A addAllToDnsNames(Collection<String> items);
  public A removeFromDnsNames(java.lang.String... items);
  public A removeAllFromDnsNames(Collection<String> items);
  public List<String> getDnsNames();
  public String getDnsName(int index);
  public String getFirstDnsName();
  public String getLastDnsName();
  public String getMatchingDnsName(Predicate<String> predicate);
  public Boolean hasMatchingDnsName(Predicate<String> predicate);
  public A withDnsNames(List<String> dnsNames);
  public A withDnsNames(java.lang.String... dnsNames);
  public Boolean hasDnsNames();
  public Duration getDuration();
  public A withDuration(Duration duration);
  public Boolean hasDuration();
  public A addToEmailSANs(int index,String item);
  public A setToEmailSANs(int index,String item);
  public A addToEmailSANs(java.lang.String... items);
  public A addAllToEmailSANs(Collection<String> items);
  public A removeFromEmailSANs(java.lang.String... items);
  public A removeAllFromEmailSANs(Collection<String> items);
  public List<String> getEmailSANs();
  public String getEmailSAN(int index);
  public String getFirstEmailSAN();
  public String getLastEmailSAN();
  public String getMatchingEmailSAN(Predicate<String> predicate);
  public Boolean hasMatchingEmailSAN(Predicate<String> predicate);
  public A withEmailSANs(List<String> emailSANs);
  public A withEmailSANs(java.lang.String... emailSANs);
  public Boolean hasEmailSANs();
  public Boolean getEncodeUsagesInRequest();
  public A withEncodeUsagesInRequest(Boolean encodeUsagesInRequest);
  public Boolean hasEncodeUsagesInRequest();
  public A addToIpAddresses(int index,String item);
  public A setToIpAddresses(int index,String item);
  public A addToIpAddresses(java.lang.String... items);
  public A addAllToIpAddresses(Collection<String> items);
  public A removeFromIpAddresses(java.lang.String... items);
  public A removeAllFromIpAddresses(Collection<String> items);
  public List<String> getIpAddresses();
  public String getIpAddress(int index);
  public String getFirstIpAddress();
  public String getLastIpAddress();
  public String getMatchingIpAddress(Predicate<String> predicate);
  public Boolean hasMatchingIpAddress(Predicate<String> predicate);
  public A withIpAddresses(List<String> ipAddresses);
  public A withIpAddresses(java.lang.String... ipAddresses);
  public Boolean hasIpAddresses();
  public Boolean getIsCA();
  public A withIsCA(Boolean isCA);
  public Boolean hasIsCA();
  
  /**
   * This method has been deprecated, please use method buildIssuerRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getIssuerRef();
  public ObjectReference buildIssuerRef();
  public A withIssuerRef(ObjectReference issuerRef);
  public Boolean hasIssuerRef();
  public A withNewIssuerRef(String group,String kind,String name);
  public CertificateSpecFluent.IssuerRefNested<A> withNewIssuerRef();
  public CertificateSpecFluent.IssuerRefNested<A> withNewIssuerRefLike(ObjectReference item);
  public CertificateSpecFluent.IssuerRefNested<A> editIssuerRef();
  public CertificateSpecFluent.IssuerRefNested<A> editOrNewIssuerRef();
  public CertificateSpecFluent.IssuerRefNested<A> editOrNewIssuerRefLike(ObjectReference item);
  
  /**
   * This method has been deprecated, please use method buildKeystores instead.
   * @return The buildable object.
   */
  @Deprecated
  public CertificateKeystores getKeystores();
  public CertificateKeystores buildKeystores();
  public A withKeystores(CertificateKeystores keystores);
  public Boolean hasKeystores();
  public CertificateSpecFluent.KeystoresNested<A> withNewKeystores();
  public CertificateSpecFluent.KeystoresNested<A> withNewKeystoresLike(CertificateKeystores item);
  public CertificateSpecFluent.KeystoresNested<A> editKeystores();
  public CertificateSpecFluent.KeystoresNested<A> editOrNewKeystores();
  public CertificateSpecFluent.KeystoresNested<A> editOrNewKeystoresLike(CertificateKeystores item);
  
  /**
   * This method has been deprecated, please use method buildPrivateKey instead.
   * @return The buildable object.
   */
  @Deprecated
  public CertificatePrivateKey getPrivateKey();
  public CertificatePrivateKey buildPrivateKey();
  public A withPrivateKey(CertificatePrivateKey privateKey);
  public Boolean hasPrivateKey();
  public A withNewPrivateKey(String algorithm,String encoding,String rotationPolicy,Integer size);
  public CertificateSpecFluent.PrivateKeyNested<A> withNewPrivateKey();
  public CertificateSpecFluent.PrivateKeyNested<A> withNewPrivateKeyLike(CertificatePrivateKey item);
  public CertificateSpecFluent.PrivateKeyNested<A> editPrivateKey();
  public CertificateSpecFluent.PrivateKeyNested<A> editOrNewPrivateKey();
  public CertificateSpecFluent.PrivateKeyNested<A> editOrNewPrivateKeyLike(CertificatePrivateKey item);
  public Duration getRenewBefore();
  public A withRenewBefore(Duration renewBefore);
  public Boolean hasRenewBefore();
  public Integer getRevisionHistoryLimit();
  public A withRevisionHistoryLimit(Integer revisionHistoryLimit);
  public Boolean hasRevisionHistoryLimit();
  public String getSecretName();
  public A withSecretName(String secretName);
  public Boolean hasSecretName();
  
  /**
   * This method has been deprecated, please use method buildSecretTemplate instead.
   * @return The buildable object.
   */
  @Deprecated
  public CertificateSecretTemplate getSecretTemplate();
  public CertificateSecretTemplate buildSecretTemplate();
  public A withSecretTemplate(CertificateSecretTemplate secretTemplate);
  public Boolean hasSecretTemplate();
  public CertificateSpecFluent.SecretTemplateNested<A> withNewSecretTemplate();
  public CertificateSpecFluent.SecretTemplateNested<A> withNewSecretTemplateLike(CertificateSecretTemplate item);
  public CertificateSpecFluent.SecretTemplateNested<A> editSecretTemplate();
  public CertificateSpecFluent.SecretTemplateNested<A> editOrNewSecretTemplate();
  public CertificateSpecFluent.SecretTemplateNested<A> editOrNewSecretTemplateLike(CertificateSecretTemplate item);
  
  /**
   * This method has been deprecated, please use method buildSubject instead.
   * @return The buildable object.
   */
  @Deprecated
  public X509Subject getSubject();
  public X509Subject buildSubject();
  public A withSubject(X509Subject subject);
  public Boolean hasSubject();
  public CertificateSpecFluent.SubjectNested<A> withNewSubject();
  public CertificateSpecFluent.SubjectNested<A> withNewSubjectLike(X509Subject item);
  public CertificateSpecFluent.SubjectNested<A> editSubject();
  public CertificateSpecFluent.SubjectNested<A> editOrNewSubject();
  public CertificateSpecFluent.SubjectNested<A> editOrNewSubjectLike(X509Subject item);
  public A addToUriSANs(int index,String item);
  public A setToUriSANs(int index,String item);
  public A addToUriSANs(java.lang.String... items);
  public A addAllToUriSANs(Collection<String> items);
  public A removeFromUriSANs(java.lang.String... items);
  public A removeAllFromUriSANs(Collection<String> items);
  public List<String> getUriSANs();
  public String getUriSAN(int index);
  public String getFirstUriSAN();
  public String getLastUriSAN();
  public String getMatchingUriSAN(Predicate<String> predicate);
  public Boolean hasMatchingUriSAN(Predicate<String> predicate);
  public A withUriSANs(List<String> uriSANs);
  public A withUriSANs(java.lang.String... uriSANs);
  public Boolean hasUriSANs();
  public A addToUsages(int index,String item);
  public A setToUsages(int index,String item);
  public A addToUsages(java.lang.String... items);
  public A addAllToUsages(Collection<String> items);
  public A removeFromUsages(java.lang.String... items);
  public A removeAllFromUsages(Collection<String> items);
  public List<String> getUsages();
  public String getUsage(int index);
  public String getFirstUsage();
  public String getLastUsage();
  public String getMatchingUsage(Predicate<String> predicate);
  public Boolean hasMatchingUsage(Predicate<String> predicate);
  public A withUsages(List<String> usages);
  public A withUsages(java.lang.String... usages);
  public Boolean hasUsages();
  public A withEncodeUsagesInRequest();
  public A withIsCA();
  public interface IssuerRefNested<N> extends Nested<N>,ObjectReferenceFluent<CertificateSpecFluent.IssuerRefNested<N>>{
    public N and();
    public N endIssuerRef();
    
  }
  public interface KeystoresNested<N> extends Nested<N>,CertificateKeystoresFluent<CertificateSpecFluent.KeystoresNested<N>>{
    public N and();
    public N endKeystores();
    
  }
  public interface PrivateKeyNested<N> extends Nested<N>,CertificatePrivateKeyFluent<CertificateSpecFluent.PrivateKeyNested<N>>{
    public N and();
    public N endPrivateKey();
    
  }
  public interface SecretTemplateNested<N> extends Nested<N>,CertificateSecretTemplateFluent<CertificateSpecFluent.SecretTemplateNested<N>>{
    public N and();
    public N endSecretTemplate();
    
  }
  public interface SubjectNested<N> extends Nested<N>,X509SubjectFluent<CertificateSpecFluent.SubjectNested<N>>{
    public N and();
    public N endSubject();
    
  }
  
}