package io.fabric8.certmanager.api.model.acme.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class OrderStatusFluentImpl<A extends OrderStatusFluent<A>> extends BaseFluent<A> implements OrderStatusFluent<A>{
  public OrderStatusFluentImpl() {
  }
  public OrderStatusFluentImpl(OrderStatus instance) {
    if (instance != null) {
      this.withAuthorizations(instance.getAuthorizations());
      this.withCertificate(instance.getCertificate());
      this.withFailureTime(instance.getFailureTime());
      this.withFinalizeURL(instance.getFinalizeURL());
      this.withReason(instance.getReason());
      this.withState(instance.getState());
      this.withUrl(instance.getUrl());
    }
  }
  private ArrayList<ACMEAuthorizationBuilder> authorizations = new ArrayList<ACMEAuthorizationBuilder>();
  private String certificate;
  private String failureTime;
  private String finalizeURL;
  private String reason;
  private String state;
  private String url;
  public A addToAuthorizations(int index,ACMEAuthorization item) {
    if (this.authorizations == null) {this.authorizations = new ArrayList<ACMEAuthorizationBuilder>();}
    ACMEAuthorizationBuilder builder = new ACMEAuthorizationBuilder(item);
    if (index < 0 || index >= authorizations.size()) { _visitables.get("authorizations").add(builder); authorizations.add(builder); } else { _visitables.get("authorizations").add(index, builder); authorizations.add(index, builder);}
    return (A)this;
  }
  public A setToAuthorizations(int index,ACMEAuthorization item) {
    if (this.authorizations == null) {this.authorizations = new ArrayList<ACMEAuthorizationBuilder>();}
    ACMEAuthorizationBuilder builder = new ACMEAuthorizationBuilder(item);
    if (index < 0 || index >= authorizations.size()) { _visitables.get("authorizations").add(builder); authorizations.add(builder); } else { _visitables.get("authorizations").set(index, builder); authorizations.set(index, builder);}
    return (A)this;
  }
  public A addToAuthorizations(io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorization... items) {
    if (this.authorizations == null) {this.authorizations = new ArrayList<ACMEAuthorizationBuilder>();}
    for (ACMEAuthorization item : items) {ACMEAuthorizationBuilder builder = new ACMEAuthorizationBuilder(item);_visitables.get("authorizations").add(builder);this.authorizations.add(builder);} return (A)this;
  }
  public A addAllToAuthorizations(Collection<ACMEAuthorization> items) {
    if (this.authorizations == null) {this.authorizations = new ArrayList<ACMEAuthorizationBuilder>();}
    for (ACMEAuthorization item : items) {ACMEAuthorizationBuilder builder = new ACMEAuthorizationBuilder(item);_visitables.get("authorizations").add(builder);this.authorizations.add(builder);} return (A)this;
  }
  public A removeFromAuthorizations(io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorization... items) {
    for (ACMEAuthorization item : items) {ACMEAuthorizationBuilder builder = new ACMEAuthorizationBuilder(item);_visitables.get("authorizations").remove(builder);if (this.authorizations != null) {this.authorizations.remove(builder);}} return (A)this;
  }
  public A removeAllFromAuthorizations(Collection<ACMEAuthorization> items) {
    for (ACMEAuthorization item : items) {ACMEAuthorizationBuilder builder = new ACMEAuthorizationBuilder(item);_visitables.get("authorizations").remove(builder);if (this.authorizations != null) {this.authorizations.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAuthorizations(Predicate<ACMEAuthorizationBuilder> predicate) {
    if (authorizations == null) return (A) this;
    final Iterator<ACMEAuthorizationBuilder> each = authorizations.iterator();
    final List visitables = _visitables.get("authorizations");
    while (each.hasNext()) {
      ACMEAuthorizationBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildAuthorizations instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ACMEAuthorization> getAuthorizations() {
    return authorizations != null ? build(authorizations) : null;
  }
  public List<ACMEAuthorization> buildAuthorizations() {
    return authorizations != null ? build(authorizations) : null;
  }
  public ACMEAuthorization buildAuthorization(int index) {
    return this.authorizations.get(index).build();
  }
  public ACMEAuthorization buildFirstAuthorization() {
    return this.authorizations.get(0).build();
  }
  public ACMEAuthorization buildLastAuthorization() {
    return this.authorizations.get(authorizations.size() - 1).build();
  }
  public ACMEAuthorization buildMatchingAuthorization(Predicate<ACMEAuthorizationBuilder> predicate) {
    for (ACMEAuthorizationBuilder item: authorizations) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingAuthorization(Predicate<ACMEAuthorizationBuilder> predicate) {
    for (ACMEAuthorizationBuilder item: authorizations) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAuthorizations(List<ACMEAuthorization> authorizations) {
    if (this.authorizations != null) { _visitables.get("authorizations").clear();}
    if (authorizations != null) {this.authorizations = new ArrayList(); for (ACMEAuthorization item : authorizations){this.addToAuthorizations(item);}} else { this.authorizations = null;} return (A) this;
  }
  public A withAuthorizations(io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorization... authorizations) {
    if (this.authorizations != null) {this.authorizations.clear(); _visitables.remove("authorizations"); }
    if (authorizations != null) {for (ACMEAuthorization item :authorizations){ this.addToAuthorizations(item);}} return (A) this;
  }
  public Boolean hasAuthorizations() {
    return authorizations != null && !authorizations.isEmpty();
  }
  public OrderStatusFluentImpl.AuthorizationsNested<A> addNewAuthorization() {
    return new OrderStatusFluentImpl.AuthorizationsNestedImpl();
  }
  public OrderStatusFluentImpl.AuthorizationsNested<A> addNewAuthorizationLike(ACMEAuthorization item) {
    return new OrderStatusFluentImpl.AuthorizationsNestedImpl(-1, item);
  }
  public OrderStatusFluentImpl.AuthorizationsNested<A> setNewAuthorizationLike(int index,ACMEAuthorization item) {
    return new OrderStatusFluentImpl.AuthorizationsNestedImpl(index, item);
  }
  public OrderStatusFluentImpl.AuthorizationsNested<A> editAuthorization(int index) {
    if (authorizations.size() <= index) throw new RuntimeException("Can't edit authorizations. Index exceeds size.");
    return setNewAuthorizationLike(index, buildAuthorization(index));
  }
  public OrderStatusFluentImpl.AuthorizationsNested<A> editFirstAuthorization() {
    if (authorizations.size() == 0) throw new RuntimeException("Can't edit first authorizations. The list is empty.");
    return setNewAuthorizationLike(0, buildAuthorization(0));
  }
  public OrderStatusFluentImpl.AuthorizationsNested<A> editLastAuthorization() {
    int index = authorizations.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last authorizations. The list is empty.");
    return setNewAuthorizationLike(index, buildAuthorization(index));
  }
  public OrderStatusFluentImpl.AuthorizationsNested<A> editMatchingAuthorization(Predicate<ACMEAuthorizationBuilder> predicate) {
    int index = -1;
    for (int i=0;i<authorizations.size();i++) { 
    if (predicate.test(authorizations.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching authorizations. No match found.");
    return setNewAuthorizationLike(index, buildAuthorization(index));
  }
  public String getCertificate() {
    return this.certificate;
  }
  public A withCertificate(String certificate) {
    this.certificate=certificate; return (A) this;
  }
  public Boolean hasCertificate() {
    return this.certificate != null;
  }
  public String getFailureTime() {
    return this.failureTime;
  }
  public A withFailureTime(String failureTime) {
    this.failureTime=failureTime; return (A) this;
  }
  public Boolean hasFailureTime() {
    return this.failureTime != null;
  }
  public String getFinalizeURL() {
    return this.finalizeURL;
  }
  public A withFinalizeURL(String finalizeURL) {
    this.finalizeURL=finalizeURL; return (A) this;
  }
  public Boolean hasFinalizeURL() {
    return this.finalizeURL != null;
  }
  public String getReason() {
    return this.reason;
  }
  public A withReason(String reason) {
    this.reason=reason; return (A) this;
  }
  public Boolean hasReason() {
    return this.reason != null;
  }
  public String getState() {
    return this.state;
  }
  public A withState(String state) {
    this.state=state; return (A) this;
  }
  public Boolean hasState() {
    return this.state != null;
  }
  public String getUrl() {
    return this.url;
  }
  public A withUrl(String url) {
    this.url=url; return (A) this;
  }
  public Boolean hasUrl() {
    return this.url != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OrderStatusFluentImpl that = (OrderStatusFluentImpl) o;
    if (!java.util.Objects.equals(authorizations, that.authorizations)) return false;

    if (!java.util.Objects.equals(certificate, that.certificate)) return false;

    if (!java.util.Objects.equals(failureTime, that.failureTime)) return false;

    if (!java.util.Objects.equals(finalizeURL, that.finalizeURL)) return false;

    if (!java.util.Objects.equals(reason, that.reason)) return false;

    if (!java.util.Objects.equals(state, that.state)) return false;

    if (!java.util.Objects.equals(url, that.url)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(authorizations,  certificate,  failureTime,  finalizeURL,  reason,  state,  url,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (authorizations != null) { sb.append("authorizations:"); sb.append(authorizations + ","); }
    if (certificate != null) { sb.append("certificate:"); sb.append(certificate + ","); }
    if (failureTime != null) { sb.append("failureTime:"); sb.append(failureTime + ","); }
    if (finalizeURL != null) { sb.append("finalizeURL:"); sb.append(finalizeURL + ","); }
    if (reason != null) { sb.append("reason:"); sb.append(reason + ","); }
    if (state != null) { sb.append("state:"); sb.append(state + ","); }
    if (url != null) { sb.append("url:"); sb.append(url); }
    sb.append("}");
    return sb.toString();
  }
  class AuthorizationsNestedImpl<N> extends ACMEAuthorizationFluentImpl<OrderStatusFluentImpl.AuthorizationsNested<N>> implements OrderStatusFluentImpl.AuthorizationsNested<N>,Nested<N>{
    AuthorizationsNestedImpl(int index,ACMEAuthorization item) {
      this.index = index;
      this.builder = new ACMEAuthorizationBuilder(this, item);
    }
    AuthorizationsNestedImpl() {
      this.index = -1;
      this.builder = new ACMEAuthorizationBuilder(this);
    }
    ACMEAuthorizationBuilder builder;
    int index;
    public N and() {
      return (N) OrderStatusFluentImpl.this.setToAuthorizations(index,builder.build());
    }
    public N endAuthorization() {
      return and();
    }
    
  }
  
}