package io.fabric8.certmanager.api.model.acme.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceFluentImpl;
import java.lang.String;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ChallengeSpecFluentImpl<A extends ChallengeSpecFluent<A>> extends BaseFluent<A> implements ChallengeSpecFluent<A>{
  public ChallengeSpecFluentImpl() {
  }
  public ChallengeSpecFluentImpl(ChallengeSpec instance) {
    if (instance != null) {
      this.withAuthorizationURL(instance.getAuthorizationURL());
      this.withDnsName(instance.getDnsName());
      this.withIssuerRef(instance.getIssuerRef());
      this.withKey(instance.getKey());
      this.withSolver(instance.getSolver());
      this.withToken(instance.getToken());
      this.withType(instance.getType());
      this.withUrl(instance.getUrl());
      this.withWildcard(instance.getWildcard());
    }
  }
  private String authorizationURL;
  private String dnsName;
  private ObjectReferenceBuilder issuerRef;
  private String key;
  private ACMEChallengeSolverBuilder solver;
  private String token;
  private String type;
  private String url;
  private Boolean wildcard;
  public String getAuthorizationURL() {
    return this.authorizationURL;
  }
  public A withAuthorizationURL(String authorizationURL) {
    this.authorizationURL=authorizationURL; return (A) this;
  }
  public Boolean hasAuthorizationURL() {
    return this.authorizationURL != null;
  }
  public String getDnsName() {
    return this.dnsName;
  }
  public A withDnsName(String dnsName) {
    this.dnsName=dnsName; return (A) this;
  }
  public Boolean hasDnsName() {
    return this.dnsName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildIssuerRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getIssuerRef() {
    return this.issuerRef!=null ?this.issuerRef.build():null;
  }
  public ObjectReference buildIssuerRef() {
    return this.issuerRef!=null ?this.issuerRef.build():null;
  }
  public A withIssuerRef(ObjectReference issuerRef) {
    _visitables.get("issuerRef").remove(this.issuerRef);
    if (issuerRef!=null){ this.issuerRef= new ObjectReferenceBuilder(issuerRef); _visitables.get("issuerRef").add(this.issuerRef);} else { this.issuerRef = null; _visitables.get("issuerRef").remove(this.issuerRef); } return (A) this;
  }
  public Boolean hasIssuerRef() {
    return this.issuerRef != null;
  }
  public A withNewIssuerRef(String group,String kind,String name) {
    return (A)withIssuerRef(new ObjectReference(group, kind, name));
  }
  public ChallengeSpecFluentImpl.IssuerRefNested<A> withNewIssuerRef() {
    return new ChallengeSpecFluentImpl.IssuerRefNestedImpl();
  }
  public ChallengeSpecFluentImpl.IssuerRefNested<A> withNewIssuerRefLike(ObjectReference item) {
    return new ChallengeSpecFluentImpl.IssuerRefNestedImpl(item);
  }
  public ChallengeSpecFluentImpl.IssuerRefNested<A> editIssuerRef() {
    return withNewIssuerRefLike(getIssuerRef());
  }
  public ChallengeSpecFluentImpl.IssuerRefNested<A> editOrNewIssuerRef() {
    return withNewIssuerRefLike(getIssuerRef() != null ? getIssuerRef(): new ObjectReferenceBuilder().build());
  }
  public ChallengeSpecFluentImpl.IssuerRefNested<A> editOrNewIssuerRefLike(ObjectReference item) {
    return withNewIssuerRefLike(getIssuerRef() != null ? getIssuerRef(): item);
  }
  public String getKey() {
    return this.key;
  }
  public A withKey(String key) {
    this.key=key; return (A) this;
  }
  public Boolean hasKey() {
    return this.key != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSolver instead.
   * @return The buildable object.
   */
  @Deprecated
  public ACMEChallengeSolver getSolver() {
    return this.solver!=null ?this.solver.build():null;
  }
  public ACMEChallengeSolver buildSolver() {
    return this.solver!=null ?this.solver.build():null;
  }
  public A withSolver(ACMEChallengeSolver solver) {
    _visitables.get("solver").remove(this.solver);
    if (solver!=null){ this.solver= new ACMEChallengeSolverBuilder(solver); _visitables.get("solver").add(this.solver);} else { this.solver = null; _visitables.get("solver").remove(this.solver); } return (A) this;
  }
  public Boolean hasSolver() {
    return this.solver != null;
  }
  public ChallengeSpecFluentImpl.SolverNested<A> withNewSolver() {
    return new ChallengeSpecFluentImpl.SolverNestedImpl();
  }
  public ChallengeSpecFluentImpl.SolverNested<A> withNewSolverLike(ACMEChallengeSolver item) {
    return new ChallengeSpecFluentImpl.SolverNestedImpl(item);
  }
  public ChallengeSpecFluentImpl.SolverNested<A> editSolver() {
    return withNewSolverLike(getSolver());
  }
  public ChallengeSpecFluentImpl.SolverNested<A> editOrNewSolver() {
    return withNewSolverLike(getSolver() != null ? getSolver(): new ACMEChallengeSolverBuilder().build());
  }
  public ChallengeSpecFluentImpl.SolverNested<A> editOrNewSolverLike(ACMEChallengeSolver item) {
    return withNewSolverLike(getSolver() != null ? getSolver(): item);
  }
  public String getToken() {
    return this.token;
  }
  public A withToken(String token) {
    this.token=token; return (A) this;
  }
  public Boolean hasToken() {
    return this.token != null;
  }
  public String getType() {
    return this.type;
  }
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  public Boolean hasType() {
    return this.type != null;
  }
  public String getUrl() {
    return this.url;
  }
  public A withUrl(String url) {
    this.url=url; return (A) this;
  }
  public Boolean hasUrl() {
    return this.url != null;
  }
  public Boolean getWildcard() {
    return this.wildcard;
  }
  public A withWildcard(Boolean wildcard) {
    this.wildcard=wildcard; return (A) this;
  }
  public Boolean hasWildcard() {
    return this.wildcard != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ChallengeSpecFluentImpl that = (ChallengeSpecFluentImpl) o;
    if (!java.util.Objects.equals(authorizationURL, that.authorizationURL)) return false;

    if (!java.util.Objects.equals(dnsName, that.dnsName)) return false;

    if (!java.util.Objects.equals(issuerRef, that.issuerRef)) return false;

    if (!java.util.Objects.equals(key, that.key)) return false;

    if (!java.util.Objects.equals(solver, that.solver)) return false;

    if (!java.util.Objects.equals(token, that.token)) return false;

    if (!java.util.Objects.equals(type, that.type)) return false;

    if (!java.util.Objects.equals(url, that.url)) return false;

    if (!java.util.Objects.equals(wildcard, that.wildcard)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(authorizationURL,  dnsName,  issuerRef,  key,  solver,  token,  type,  url,  wildcard,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (authorizationURL != null) { sb.append("authorizationURL:"); sb.append(authorizationURL + ","); }
    if (dnsName != null) { sb.append("dnsName:"); sb.append(dnsName + ","); }
    if (issuerRef != null) { sb.append("issuerRef:"); sb.append(issuerRef + ","); }
    if (key != null) { sb.append("key:"); sb.append(key + ","); }
    if (solver != null) { sb.append("solver:"); sb.append(solver + ","); }
    if (token != null) { sb.append("token:"); sb.append(token + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (url != null) { sb.append("url:"); sb.append(url + ","); }
    if (wildcard != null) { sb.append("wildcard:"); sb.append(wildcard); }
    sb.append("}");
    return sb.toString();
  }
  public A withWildcard() {
    return withWildcard(true);
  }
  class IssuerRefNestedImpl<N> extends ObjectReferenceFluentImpl<ChallengeSpecFluentImpl.IssuerRefNested<N>> implements ChallengeSpecFluentImpl.IssuerRefNested<N>,Nested<N>{
    IssuerRefNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    IssuerRefNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) ChallengeSpecFluentImpl.this.withIssuerRef(builder.build());
    }
    public N endIssuerRef() {
      return and();
    }
    
  }
  class SolverNestedImpl<N> extends ACMEChallengeSolverFluentImpl<ChallengeSpecFluentImpl.SolverNested<N>> implements ChallengeSpecFluentImpl.SolverNested<N>,Nested<N>{
    SolverNestedImpl(ACMEChallengeSolver item) {
      this.builder = new ACMEChallengeSolverBuilder(this, item);
    }
    SolverNestedImpl() {
      this.builder = new ACMEChallengeSolverBuilder(this);
    }
    ACMEChallengeSolverBuilder builder;
    public N and() {
      return (N) ChallengeSpecFluentImpl.this.withSolver(builder.build());
    }
    public N endSolver() {
      return and();
    }
    
  }
  
}