package io.fabric8.certmanager.api.model.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CertificateSecretTemplateBuilder extends CertificateSecretTemplateFluentImpl<CertificateSecretTemplateBuilder> implements VisitableBuilder<CertificateSecretTemplate,CertificateSecretTemplateBuilder>{
  public CertificateSecretTemplateBuilder() {
    this(false);
  }
  public CertificateSecretTemplateBuilder(Boolean validationEnabled) {
    this(new CertificateSecretTemplate(), validationEnabled);
  }
  public CertificateSecretTemplateBuilder(CertificateSecretTemplateFluent<?> fluent) {
    this(fluent, false);
  }
  public CertificateSecretTemplateBuilder(CertificateSecretTemplateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CertificateSecretTemplate(), validationEnabled);
  }
  public CertificateSecretTemplateBuilder(CertificateSecretTemplateFluent<?> fluent,CertificateSecretTemplate instance) {
    this(fluent, instance, false);
  }
  public CertificateSecretTemplateBuilder(CertificateSecretTemplateFluent<?> fluent,CertificateSecretTemplate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAnnotations(instance.getAnnotations()); 
    fluent.withLabels(instance.getLabels()); 
    this.validationEnabled = validationEnabled; 
  }
  public CertificateSecretTemplateBuilder(CertificateSecretTemplate instance) {
    this(instance,false);
  }
  public CertificateSecretTemplateBuilder(CertificateSecretTemplate instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAnnotations(instance.getAnnotations()); 
    this.withLabels(instance.getLabels()); 
    this.validationEnabled = validationEnabled; 
  }
  CertificateSecretTemplateFluent<?> fluent;
  Boolean validationEnabled;
  public CertificateSecretTemplate build() {
    CertificateSecretTemplate buildable = new CertificateSecretTemplate(fluent.getAnnotations(),fluent.getLabels());
    return buildable;
  }
  
}