package io.fabric8.certmanager.api.model.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CertificateRequestStatusBuilder extends CertificateRequestStatusFluentImpl<CertificateRequestStatusBuilder> implements VisitableBuilder<CertificateRequestStatus,CertificateRequestStatusBuilder>{
  public CertificateRequestStatusBuilder() {
    this(false);
  }
  public CertificateRequestStatusBuilder(Boolean validationEnabled) {
    this(new CertificateRequestStatus(), validationEnabled);
  }
  public CertificateRequestStatusBuilder(CertificateRequestStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public CertificateRequestStatusBuilder(CertificateRequestStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CertificateRequestStatus(), validationEnabled);
  }
  public CertificateRequestStatusBuilder(CertificateRequestStatusFluent<?> fluent,CertificateRequestStatus instance) {
    this(fluent, instance, false);
  }
  public CertificateRequestStatusBuilder(CertificateRequestStatusFluent<?> fluent,CertificateRequestStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCa(instance.getCa()); 
    fluent.withCertificate(instance.getCertificate()); 
    fluent.withConditions(instance.getConditions()); 
    fluent.withFailureTime(instance.getFailureTime()); 
    this.validationEnabled = validationEnabled; 
  }
  public CertificateRequestStatusBuilder(CertificateRequestStatus instance) {
    this(instance,false);
  }
  public CertificateRequestStatusBuilder(CertificateRequestStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCa(instance.getCa()); 
    this.withCertificate(instance.getCertificate()); 
    this.withConditions(instance.getConditions()); 
    this.withFailureTime(instance.getFailureTime()); 
    this.validationEnabled = validationEnabled; 
  }
  CertificateRequestStatusFluent<?> fluent;
  Boolean validationEnabled;
  public CertificateRequestStatus build() {
    CertificateRequestStatus buildable = new CertificateRequestStatus(fluent.getCa(),fluent.getCertificate(),fluent.getConditions(),fluent.getFailureTime());
    return buildable;
  }
  
}