package io.fabric8.certmanager.api.model.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CertificateListBuilder extends CertificateListFluentImpl<CertificateListBuilder> implements VisitableBuilder<CertificateList,CertificateListBuilder>{
  public CertificateListBuilder() {
    this(false);
  }
  public CertificateListBuilder(Boolean validationEnabled) {
    this(new CertificateList(), validationEnabled);
  }
  public CertificateListBuilder(CertificateListFluent<?> fluent) {
    this(fluent, false);
  }
  public CertificateListBuilder(CertificateListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CertificateList(), validationEnabled);
  }
  public CertificateListBuilder(CertificateListFluent<?> fluent,CertificateList instance) {
    this(fluent, instance, false);
  }
  public CertificateListBuilder(CertificateListFluent<?> fluent,CertificateList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public CertificateListBuilder(CertificateList instance) {
    this(instance,false);
  }
  public CertificateListBuilder(CertificateList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  CertificateListFluent<?> fluent;
  Boolean validationEnabled;
  public CertificateList build() {
    CertificateList buildable = new CertificateList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}