package io.fabric8.certmanager.api.model.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import java.util.LinkedHashMap;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PKCS12KeystoreFluent<A extends PKCS12KeystoreFluent<A>> extends BaseFluent<A>{
  public PKCS12KeystoreFluent() {
  }
  
  public PKCS12KeystoreFluent(PKCS12Keystore instance) {
    this.copyInstance(instance);
  }
  private Boolean create;
  private SecretKeySelectorBuilder passwordSecretRef;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(PKCS12Keystore instance) {
    instance = (instance != null ? instance : new PKCS12Keystore());
    if (instance != null) {
          this.withCreate(instance.getCreate());
          this.withPasswordSecretRef(instance.getPasswordSecretRef());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Boolean getCreate() {
    return this.create;
  }
  
  public A withCreate(Boolean create) {
    this.create = create;
    return (A) this;
  }
  
  public boolean hasCreate() {
    return this.create != null;
  }
  
  public SecretKeySelector buildPasswordSecretRef() {
    return this.passwordSecretRef != null ? this.passwordSecretRef.build() : null;
  }
  
  public A withPasswordSecretRef(SecretKeySelector passwordSecretRef) {
    this._visitables.remove("passwordSecretRef");
    if (passwordSecretRef != null) {
        this.passwordSecretRef = new SecretKeySelectorBuilder(passwordSecretRef);
        this._visitables.get("passwordSecretRef").add(this.passwordSecretRef);
    } else {
        this.passwordSecretRef = null;
        this._visitables.get("passwordSecretRef").remove(this.passwordSecretRef);
    }
    return (A) this;
  }
  
  public boolean hasPasswordSecretRef() {
    return this.passwordSecretRef != null;
  }
  
  public A withNewPasswordSecretRef(String key,String name) {
    return (A)withPasswordSecretRef(new SecretKeySelector(key, name));
  }
  
  public PasswordSecretRefNested<A> withNewPasswordSecretRef() {
    return new PasswordSecretRefNested(null);
  }
  
  public PasswordSecretRefNested<A> withNewPasswordSecretRefLike(SecretKeySelector item) {
    return new PasswordSecretRefNested(item);
  }
  
  public PasswordSecretRefNested<A> editPasswordSecretRef() {
    return withNewPasswordSecretRefLike(java.util.Optional.ofNullable(buildPasswordSecretRef()).orElse(null));
  }
  
  public PasswordSecretRefNested<A> editOrNewPasswordSecretRef() {
    return withNewPasswordSecretRefLike(java.util.Optional.ofNullable(buildPasswordSecretRef()).orElse(new SecretKeySelectorBuilder().build()));
  }
  
  public PasswordSecretRefNested<A> editOrNewPasswordSecretRefLike(SecretKeySelector item) {
    return withNewPasswordSecretRefLike(java.util.Optional.ofNullable(buildPasswordSecretRef()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PKCS12KeystoreFluent that = (PKCS12KeystoreFluent) o;
    if (!java.util.Objects.equals(create, that.create)) return false;
    if (!java.util.Objects.equals(passwordSecretRef, that.passwordSecretRef)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(create,  passwordSecretRef,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (create != null) { sb.append("create:"); sb.append(create + ","); }
    if (passwordSecretRef != null) { sb.append("passwordSecretRef:"); sb.append(passwordSecretRef + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withCreate() {
    return withCreate(true);
  }
  public class PasswordSecretRefNested<N> extends SecretKeySelectorFluent<PasswordSecretRefNested<N>> implements Nested<N>{
    PasswordSecretRefNested(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    SecretKeySelectorBuilder builder;
    
    public N and() {
      return (N) PKCS12KeystoreFluent.this.withPasswordSecretRef(builder.build());
    }
    
    public N endPasswordSecretRef() {
      return and();
    }
    
  
  }

}