package io.fabric8.certmanager.api.model.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClusterIssuerBuilder extends ClusterIssuerFluent<ClusterIssuerBuilder> implements VisitableBuilder<ClusterIssuer,ClusterIssuerBuilder>{
  public ClusterIssuerBuilder() {
    this(new ClusterIssuer());
  }
  
  public ClusterIssuerBuilder(ClusterIssuerFluent<?> fluent) {
    this(fluent, new ClusterIssuer());
  }
  
  public ClusterIssuerBuilder(ClusterIssuerFluent<?> fluent,ClusterIssuer instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClusterIssuerBuilder(ClusterIssuer instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClusterIssuerFluent<?> fluent;
  
  public ClusterIssuer build() {
    ClusterIssuer buildable = new ClusterIssuer(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}