package io.fabric8.certmanager.api.model.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReference;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceFluent;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class CertificateRequestSpecFluent<A extends CertificateRequestSpecFluent<A>> extends BaseFluent<A>{
  public CertificateRequestSpecFluent() {
  }
  
  public CertificateRequestSpecFluent(CertificateRequestSpec instance) {
    this.copyInstance(instance);
  }
  private Duration duration;
  private Boolean isCA;
  private ObjectReferenceBuilder issuerRef;
  private String request;
  private List<String> usages;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(CertificateRequestSpec instance) {
    instance = (instance != null ? instance : new CertificateRequestSpec());
    if (instance != null) {
          this.withDuration(instance.getDuration());
          this.withIsCA(instance.getIsCA());
          this.withIssuerRef(instance.getIssuerRef());
          this.withRequest(instance.getRequest());
          this.withUsages(instance.getUsages());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Duration getDuration() {
    return this.duration;
  }
  
  public A withDuration(Duration duration) {
    this.duration = duration;
    return (A) this;
  }
  
  public boolean hasDuration() {
    return this.duration != null;
  }
  
  public Boolean getIsCA() {
    return this.isCA;
  }
  
  public A withIsCA(Boolean isCA) {
    this.isCA = isCA;
    return (A) this;
  }
  
  public boolean hasIsCA() {
    return this.isCA != null;
  }
  
  public ObjectReference buildIssuerRef() {
    return this.issuerRef != null ? this.issuerRef.build() : null;
  }
  
  public A withIssuerRef(ObjectReference issuerRef) {
    this._visitables.remove("issuerRef");
    if (issuerRef != null) {
        this.issuerRef = new ObjectReferenceBuilder(issuerRef);
        this._visitables.get("issuerRef").add(this.issuerRef);
    } else {
        this.issuerRef = null;
        this._visitables.get("issuerRef").remove(this.issuerRef);
    }
    return (A) this;
  }
  
  public boolean hasIssuerRef() {
    return this.issuerRef != null;
  }
  
  public A withNewIssuerRef(String group,String kind,String name) {
    return (A)withIssuerRef(new ObjectReference(group, kind, name));
  }
  
  public IssuerRefNested<A> withNewIssuerRef() {
    return new IssuerRefNested(null);
  }
  
  public IssuerRefNested<A> withNewIssuerRefLike(ObjectReference item) {
    return new IssuerRefNested(item);
  }
  
  public IssuerRefNested<A> editIssuerRef() {
    return withNewIssuerRefLike(java.util.Optional.ofNullable(buildIssuerRef()).orElse(null));
  }
  
  public IssuerRefNested<A> editOrNewIssuerRef() {
    return withNewIssuerRefLike(java.util.Optional.ofNullable(buildIssuerRef()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public IssuerRefNested<A> editOrNewIssuerRefLike(ObjectReference item) {
    return withNewIssuerRefLike(java.util.Optional.ofNullable(buildIssuerRef()).orElse(item));
  }
  
  public String getRequest() {
    return this.request;
  }
  
  public A withRequest(String request) {
    this.request = request;
    return (A) this;
  }
  
  public boolean hasRequest() {
    return this.request != null;
  }
  
  public A addToUsages(int index,String item) {
    if (this.usages == null) {this.usages = new ArrayList<String>();}
    this.usages.add(index, item);
    return (A)this;
  }
  
  public A setToUsages(int index,String item) {
    if (this.usages == null) {this.usages = new ArrayList<String>();}
    this.usages.set(index, item); return (A)this;
  }
  
  public A addToUsages(java.lang.String... items) {
    if (this.usages == null) {this.usages = new ArrayList<String>();}
    for (String item : items) {this.usages.add(item);} return (A)this;
  }
  
  public A addAllToUsages(Collection<String> items) {
    if (this.usages == null) {this.usages = new ArrayList<String>();}
    for (String item : items) {this.usages.add(item);} return (A)this;
  }
  
  public A removeFromUsages(java.lang.String... items) {
    if (this.usages == null) return (A)this;
    for (String item : items) { this.usages.remove(item);} return (A)this;
  }
  
  public A removeAllFromUsages(Collection<String> items) {
    if (this.usages == null) return (A)this;
    for (String item : items) { this.usages.remove(item);} return (A)this;
  }
  
  public List<String> getUsages() {
    return this.usages;
  }
  
  public String getUsage(int index) {
    return this.usages.get(index);
  }
  
  public String getFirstUsage() {
    return this.usages.get(0);
  }
  
  public String getLastUsage() {
    return this.usages.get(usages.size() - 1);
  }
  
  public String getMatchingUsage(Predicate<String> predicate) {
      for (String item : usages) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingUsage(Predicate<String> predicate) {
      for (String item : usages) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withUsages(List<String> usages) {
    if (usages != null) {
        this.usages = new ArrayList();
        for (String item : usages) {
          this.addToUsages(item);
        }
    } else {
      this.usages = null;
    }
    return (A) this;
  }
  
  public A withUsages(java.lang.String... usages) {
    if (this.usages != null) {
        this.usages.clear();
        _visitables.remove("usages");
    }
    if (usages != null) {
      for (String item : usages) {
        this.addToUsages(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasUsages() {
    return this.usages != null && !this.usages.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CertificateRequestSpecFluent that = (CertificateRequestSpecFluent) o;
    if (!java.util.Objects.equals(duration, that.duration)) return false;
    if (!java.util.Objects.equals(isCA, that.isCA)) return false;
    if (!java.util.Objects.equals(issuerRef, that.issuerRef)) return false;
    if (!java.util.Objects.equals(request, that.request)) return false;
    if (!java.util.Objects.equals(usages, that.usages)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(duration,  isCA,  issuerRef,  request,  usages,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (duration != null) { sb.append("duration:"); sb.append(duration + ","); }
    if (isCA != null) { sb.append("isCA:"); sb.append(isCA + ","); }
    if (issuerRef != null) { sb.append("issuerRef:"); sb.append(issuerRef + ","); }
    if (request != null) { sb.append("request:"); sb.append(request + ","); }
    if (usages != null && !usages.isEmpty()) { sb.append("usages:"); sb.append(usages + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withIsCA() {
    return withIsCA(true);
  }
  public class IssuerRefNested<N> extends ObjectReferenceFluent<IssuerRefNested<N>> implements Nested<N>{
    IssuerRefNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) CertificateRequestSpecFluent.this.withIssuerRef(builder.build());
    }
    
    public N endIssuerRef() {
      return and();
    }
    
  
  }

}