package io.fabric8.certmanager.api.model.acme.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import java.util.LinkedHashMap;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ACMEIssuerDNS01ProviderAzureDNSFluent<A extends ACMEIssuerDNS01ProviderAzureDNSFluent<A>> extends BaseFluent<A>{
  public ACMEIssuerDNS01ProviderAzureDNSFluent() {
  }
  
  public ACMEIssuerDNS01ProviderAzureDNSFluent(ACMEIssuerDNS01ProviderAzureDNS instance) {
    this.copyInstance(instance);
  }
  private String clientID;
  private SecretKeySelectorBuilder clientSecretSecretRef;
  private String environment;
  private String hostedZoneName;
  private AzureManagedIdentityBuilder managedIdentity;
  private String resourceGroupName;
  private String subscriptionID;
  private String tenantID;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ACMEIssuerDNS01ProviderAzureDNS instance) {
    instance = (instance != null ? instance : new ACMEIssuerDNS01ProviderAzureDNS());
    if (instance != null) {
          this.withClientID(instance.getClientID());
          this.withClientSecretSecretRef(instance.getClientSecretSecretRef());
          this.withEnvironment(instance.getEnvironment());
          this.withHostedZoneName(instance.getHostedZoneName());
          this.withManagedIdentity(instance.getManagedIdentity());
          this.withResourceGroupName(instance.getResourceGroupName());
          this.withSubscriptionID(instance.getSubscriptionID());
          this.withTenantID(instance.getTenantID());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getClientID() {
    return this.clientID;
  }
  
  public A withClientID(String clientID) {
    this.clientID = clientID;
    return (A) this;
  }
  
  public boolean hasClientID() {
    return this.clientID != null;
  }
  
  public SecretKeySelector buildClientSecretSecretRef() {
    return this.clientSecretSecretRef != null ? this.clientSecretSecretRef.build() : null;
  }
  
  public A withClientSecretSecretRef(SecretKeySelector clientSecretSecretRef) {
    this._visitables.remove("clientSecretSecretRef");
    if (clientSecretSecretRef != null) {
        this.clientSecretSecretRef = new SecretKeySelectorBuilder(clientSecretSecretRef);
        this._visitables.get("clientSecretSecretRef").add(this.clientSecretSecretRef);
    } else {
        this.clientSecretSecretRef = null;
        this._visitables.get("clientSecretSecretRef").remove(this.clientSecretSecretRef);
    }
    return (A) this;
  }
  
  public boolean hasClientSecretSecretRef() {
    return this.clientSecretSecretRef != null;
  }
  
  public A withNewClientSecretSecretRef(String key,String name) {
    return (A)withClientSecretSecretRef(new SecretKeySelector(key, name));
  }
  
  public ClientSecretSecretRefNested<A> withNewClientSecretSecretRef() {
    return new ClientSecretSecretRefNested(null);
  }
  
  public ClientSecretSecretRefNested<A> withNewClientSecretSecretRefLike(SecretKeySelector item) {
    return new ClientSecretSecretRefNested(item);
  }
  
  public ClientSecretSecretRefNested<A> editClientSecretSecretRef() {
    return withNewClientSecretSecretRefLike(java.util.Optional.ofNullable(buildClientSecretSecretRef()).orElse(null));
  }
  
  public ClientSecretSecretRefNested<A> editOrNewClientSecretSecretRef() {
    return withNewClientSecretSecretRefLike(java.util.Optional.ofNullable(buildClientSecretSecretRef()).orElse(new SecretKeySelectorBuilder().build()));
  }
  
  public ClientSecretSecretRefNested<A> editOrNewClientSecretSecretRefLike(SecretKeySelector item) {
    return withNewClientSecretSecretRefLike(java.util.Optional.ofNullable(buildClientSecretSecretRef()).orElse(item));
  }
  
  public String getEnvironment() {
    return this.environment;
  }
  
  public A withEnvironment(String environment) {
    this.environment = environment;
    return (A) this;
  }
  
  public boolean hasEnvironment() {
    return this.environment != null;
  }
  
  public String getHostedZoneName() {
    return this.hostedZoneName;
  }
  
  public A withHostedZoneName(String hostedZoneName) {
    this.hostedZoneName = hostedZoneName;
    return (A) this;
  }
  
  public boolean hasHostedZoneName() {
    return this.hostedZoneName != null;
  }
  
  public AzureManagedIdentity buildManagedIdentity() {
    return this.managedIdentity != null ? this.managedIdentity.build() : null;
  }
  
  public A withManagedIdentity(AzureManagedIdentity managedIdentity) {
    this._visitables.remove("managedIdentity");
    if (managedIdentity != null) {
        this.managedIdentity = new AzureManagedIdentityBuilder(managedIdentity);
        this._visitables.get("managedIdentity").add(this.managedIdentity);
    } else {
        this.managedIdentity = null;
        this._visitables.get("managedIdentity").remove(this.managedIdentity);
    }
    return (A) this;
  }
  
  public boolean hasManagedIdentity() {
    return this.managedIdentity != null;
  }
  
  public A withNewManagedIdentity(String clientID,String resourceID) {
    return (A)withManagedIdentity(new AzureManagedIdentity(clientID, resourceID));
  }
  
  public ManagedIdentityNested<A> withNewManagedIdentity() {
    return new ManagedIdentityNested(null);
  }
  
  public ManagedIdentityNested<A> withNewManagedIdentityLike(AzureManagedIdentity item) {
    return new ManagedIdentityNested(item);
  }
  
  public ManagedIdentityNested<A> editManagedIdentity() {
    return withNewManagedIdentityLike(java.util.Optional.ofNullable(buildManagedIdentity()).orElse(null));
  }
  
  public ManagedIdentityNested<A> editOrNewManagedIdentity() {
    return withNewManagedIdentityLike(java.util.Optional.ofNullable(buildManagedIdentity()).orElse(new AzureManagedIdentityBuilder().build()));
  }
  
  public ManagedIdentityNested<A> editOrNewManagedIdentityLike(AzureManagedIdentity item) {
    return withNewManagedIdentityLike(java.util.Optional.ofNullable(buildManagedIdentity()).orElse(item));
  }
  
  public String getResourceGroupName() {
    return this.resourceGroupName;
  }
  
  public A withResourceGroupName(String resourceGroupName) {
    this.resourceGroupName = resourceGroupName;
    return (A) this;
  }
  
  public boolean hasResourceGroupName() {
    return this.resourceGroupName != null;
  }
  
  public String getSubscriptionID() {
    return this.subscriptionID;
  }
  
  public A withSubscriptionID(String subscriptionID) {
    this.subscriptionID = subscriptionID;
    return (A) this;
  }
  
  public boolean hasSubscriptionID() {
    return this.subscriptionID != null;
  }
  
  public String getTenantID() {
    return this.tenantID;
  }
  
  public A withTenantID(String tenantID) {
    this.tenantID = tenantID;
    return (A) this;
  }
  
  public boolean hasTenantID() {
    return this.tenantID != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ACMEIssuerDNS01ProviderAzureDNSFluent that = (ACMEIssuerDNS01ProviderAzureDNSFluent) o;
    if (!java.util.Objects.equals(clientID, that.clientID)) return false;
    if (!java.util.Objects.equals(clientSecretSecretRef, that.clientSecretSecretRef)) return false;
    if (!java.util.Objects.equals(environment, that.environment)) return false;
    if (!java.util.Objects.equals(hostedZoneName, that.hostedZoneName)) return false;
    if (!java.util.Objects.equals(managedIdentity, that.managedIdentity)) return false;
    if (!java.util.Objects.equals(resourceGroupName, that.resourceGroupName)) return false;
    if (!java.util.Objects.equals(subscriptionID, that.subscriptionID)) return false;
    if (!java.util.Objects.equals(tenantID, that.tenantID)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(clientID,  clientSecretSecretRef,  environment,  hostedZoneName,  managedIdentity,  resourceGroupName,  subscriptionID,  tenantID,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clientID != null) { sb.append("clientID:"); sb.append(clientID + ","); }
    if (clientSecretSecretRef != null) { sb.append("clientSecretSecretRef:"); sb.append(clientSecretSecretRef + ","); }
    if (environment != null) { sb.append("environment:"); sb.append(environment + ","); }
    if (hostedZoneName != null) { sb.append("hostedZoneName:"); sb.append(hostedZoneName + ","); }
    if (managedIdentity != null) { sb.append("managedIdentity:"); sb.append(managedIdentity + ","); }
    if (resourceGroupName != null) { sb.append("resourceGroupName:"); sb.append(resourceGroupName + ","); }
    if (subscriptionID != null) { sb.append("subscriptionID:"); sb.append(subscriptionID + ","); }
    if (tenantID != null) { sb.append("tenantID:"); sb.append(tenantID + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ClientSecretSecretRefNested<N> extends SecretKeySelectorFluent<ClientSecretSecretRefNested<N>> implements Nested<N>{
    ClientSecretSecretRefNested(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    SecretKeySelectorBuilder builder;
    
    public N and() {
      return (N) ACMEIssuerDNS01ProviderAzureDNSFluent.this.withClientSecretSecretRef(builder.build());
    }
    
    public N endClientSecretSecretRef() {
      return and();
    }
    
  
  }
  public class ManagedIdentityNested<N> extends AzureManagedIdentityFluent<ManagedIdentityNested<N>> implements Nested<N>{
    ManagedIdentityNested(AzureManagedIdentity item) {
      this.builder = new AzureManagedIdentityBuilder(this, item);
    }
    AzureManagedIdentityBuilder builder;
    
    public N and() {
      return (N) ACMEIssuerDNS01ProviderAzureDNSFluent.this.withManagedIdentity(builder.build());
    }
    
    public N endManagedIdentity() {
      return and();
    }
    
  
  }

}