package io.fabric8.certmanager.api.model.acme.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;
import java.lang.Integer;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluentImpl;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ACMEIssuerFluentImpl<A extends ACMEIssuerFluent<A>> extends BaseFluent<A> implements ACMEIssuerFluent<A>{
  public ACMEIssuerFluentImpl() {
  }
  public ACMEIssuerFluentImpl(ACMEIssuer instance) {
    this.withDisableAccountKeyGeneration(instance.getDisableAccountKeyGeneration()); 
    this.withEmail(instance.getEmail()); 
    this.withEnableDurationFeature(instance.getEnableDurationFeature()); 
    this.withExternalAccountBinding(instance.getExternalAccountBinding()); 
    this.withPreferredChain(instance.getPreferredChain()); 
    this.withPrivateKeySecretRef(instance.getPrivateKeySecretRef()); 
    this.withServer(instance.getServer()); 
    this.withSkipTLSVerify(instance.getSkipTLSVerify()); 
    this.withSolvers(instance.getSolvers()); 
  }
  private Boolean disableAccountKeyGeneration;
  private String email;
  private Boolean enableDurationFeature;
  private ACMEExternalAccountBindingBuilder externalAccountBinding;
  private String preferredChain;
  private SecretKeySelectorBuilder privateKeySecretRef;
  private String server;
  private Boolean skipTLSVerify;
  private ArrayList<ACMEChallengeSolverBuilder> solvers = new ArrayList<ACMEChallengeSolverBuilder>();
  public Boolean getDisableAccountKeyGeneration() {
    return this.disableAccountKeyGeneration;
  }
  public A withDisableAccountKeyGeneration(Boolean disableAccountKeyGeneration) {
    this.disableAccountKeyGeneration=disableAccountKeyGeneration; return (A) this;
  }
  public Boolean hasDisableAccountKeyGeneration() {
    return this.disableAccountKeyGeneration != null;
  }
  public String getEmail() {
    return this.email;
  }
  public A withEmail(String email) {
    this.email=email; return (A) this;
  }
  public Boolean hasEmail() {
    return this.email != null;
  }
  public Boolean getEnableDurationFeature() {
    return this.enableDurationFeature;
  }
  public A withEnableDurationFeature(Boolean enableDurationFeature) {
    this.enableDurationFeature=enableDurationFeature; return (A) this;
  }
  public Boolean hasEnableDurationFeature() {
    return this.enableDurationFeature != null;
  }
  
  /**
   * This method has been deprecated, please use method buildExternalAccountBinding instead.
   * @return The buildable object.
   */
  @Deprecated
  public ACMEExternalAccountBinding getExternalAccountBinding() {
    return this.externalAccountBinding!=null ?this.externalAccountBinding.build():null;
  }
  public ACMEExternalAccountBinding buildExternalAccountBinding() {
    return this.externalAccountBinding!=null ?this.externalAccountBinding.build():null;
  }
  public A withExternalAccountBinding(ACMEExternalAccountBinding externalAccountBinding) {
    _visitables.get("externalAccountBinding").remove(this.externalAccountBinding);
    if (externalAccountBinding!=null){ this.externalAccountBinding= new ACMEExternalAccountBindingBuilder(externalAccountBinding); _visitables.get("externalAccountBinding").add(this.externalAccountBinding);} else { this.externalAccountBinding = null; _visitables.get("externalAccountBinding").remove(this.externalAccountBinding); } return (A) this;
  }
  public Boolean hasExternalAccountBinding() {
    return this.externalAccountBinding != null;
  }
  public ACMEIssuerFluent.ExternalAccountBindingNested<A> withNewExternalAccountBinding() {
    return new ACMEIssuerFluentImpl.ExternalAccountBindingNestedImpl();
  }
  public ACMEIssuerFluent.ExternalAccountBindingNested<A> withNewExternalAccountBindingLike(ACMEExternalAccountBinding item) {
    return new ACMEIssuerFluentImpl.ExternalAccountBindingNestedImpl(item);
  }
  public ACMEIssuerFluent.ExternalAccountBindingNested<A> editExternalAccountBinding() {
    return withNewExternalAccountBindingLike(getExternalAccountBinding());
  }
  public ACMEIssuerFluent.ExternalAccountBindingNested<A> editOrNewExternalAccountBinding() {
    return withNewExternalAccountBindingLike(getExternalAccountBinding() != null ? getExternalAccountBinding(): new ACMEExternalAccountBindingBuilder().build());
  }
  public ACMEIssuerFluent.ExternalAccountBindingNested<A> editOrNewExternalAccountBindingLike(ACMEExternalAccountBinding item) {
    return withNewExternalAccountBindingLike(getExternalAccountBinding() != null ? getExternalAccountBinding(): item);
  }
  public String getPreferredChain() {
    return this.preferredChain;
  }
  public A withPreferredChain(String preferredChain) {
    this.preferredChain=preferredChain; return (A) this;
  }
  public Boolean hasPreferredChain() {
    return this.preferredChain != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPrivateKeySecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretKeySelector getPrivateKeySecretRef() {
    return this.privateKeySecretRef!=null ?this.privateKeySecretRef.build():null;
  }
  public SecretKeySelector buildPrivateKeySecretRef() {
    return this.privateKeySecretRef!=null ?this.privateKeySecretRef.build():null;
  }
  public A withPrivateKeySecretRef(SecretKeySelector privateKeySecretRef) {
    _visitables.get("privateKeySecretRef").remove(this.privateKeySecretRef);
    if (privateKeySecretRef!=null){ this.privateKeySecretRef= new SecretKeySelectorBuilder(privateKeySecretRef); _visitables.get("privateKeySecretRef").add(this.privateKeySecretRef);} else { this.privateKeySecretRef = null; _visitables.get("privateKeySecretRef").remove(this.privateKeySecretRef); } return (A) this;
  }
  public Boolean hasPrivateKeySecretRef() {
    return this.privateKeySecretRef != null;
  }
  public A withNewPrivateKeySecretRef(String key,String name) {
    return (A)withPrivateKeySecretRef(new SecretKeySelector(key, name));
  }
  public ACMEIssuerFluent.PrivateKeySecretRefNested<A> withNewPrivateKeySecretRef() {
    return new ACMEIssuerFluentImpl.PrivateKeySecretRefNestedImpl();
  }
  public ACMEIssuerFluent.PrivateKeySecretRefNested<A> withNewPrivateKeySecretRefLike(SecretKeySelector item) {
    return new ACMEIssuerFluentImpl.PrivateKeySecretRefNestedImpl(item);
  }
  public ACMEIssuerFluent.PrivateKeySecretRefNested<A> editPrivateKeySecretRef() {
    return withNewPrivateKeySecretRefLike(getPrivateKeySecretRef());
  }
  public ACMEIssuerFluent.PrivateKeySecretRefNested<A> editOrNewPrivateKeySecretRef() {
    return withNewPrivateKeySecretRefLike(getPrivateKeySecretRef() != null ? getPrivateKeySecretRef(): new SecretKeySelectorBuilder().build());
  }
  public ACMEIssuerFluent.PrivateKeySecretRefNested<A> editOrNewPrivateKeySecretRefLike(SecretKeySelector item) {
    return withNewPrivateKeySecretRefLike(getPrivateKeySecretRef() != null ? getPrivateKeySecretRef(): item);
  }
  public String getServer() {
    return this.server;
  }
  public A withServer(String server) {
    this.server=server; return (A) this;
  }
  public Boolean hasServer() {
    return this.server != null;
  }
  public Boolean getSkipTLSVerify() {
    return this.skipTLSVerify;
  }
  public A withSkipTLSVerify(Boolean skipTLSVerify) {
    this.skipTLSVerify=skipTLSVerify; return (A) this;
  }
  public Boolean hasSkipTLSVerify() {
    return this.skipTLSVerify != null;
  }
  public A addToSolvers(Integer index,ACMEChallengeSolver item) {
    if (this.solvers == null) {this.solvers = new ArrayList<ACMEChallengeSolverBuilder>();}
    ACMEChallengeSolverBuilder builder = new ACMEChallengeSolverBuilder(item);_visitables.get("solvers").add(index >= 0 ? index : _visitables.get("solvers").size(), builder);this.solvers.add(index >= 0 ? index : solvers.size(), builder); return (A)this;
  }
  public A setToSolvers(Integer index,ACMEChallengeSolver item) {
    if (this.solvers == null) {this.solvers = new ArrayList<ACMEChallengeSolverBuilder>();}
    ACMEChallengeSolverBuilder builder = new ACMEChallengeSolverBuilder(item);
    if (index < 0 || index >= _visitables.get("solvers").size()) { _visitables.get("solvers").add(builder); } else { _visitables.get("solvers").set(index, builder);}
    if (index < 0 || index >= solvers.size()) { solvers.add(builder); } else { solvers.set(index, builder);}
     return (A)this;
  }
  public A addToSolvers(io.fabric8.certmanager.api.model.acme.v1beta1.ACMEChallengeSolver... items) {
    if (this.solvers == null) {this.solvers = new ArrayList<ACMEChallengeSolverBuilder>();}
    for (ACMEChallengeSolver item : items) {ACMEChallengeSolverBuilder builder = new ACMEChallengeSolverBuilder(item);_visitables.get("solvers").add(builder);this.solvers.add(builder);} return (A)this;
  }
  public A addAllToSolvers(Collection<ACMEChallengeSolver> items) {
    if (this.solvers == null) {this.solvers = new ArrayList<ACMEChallengeSolverBuilder>();}
    for (ACMEChallengeSolver item : items) {ACMEChallengeSolverBuilder builder = new ACMEChallengeSolverBuilder(item);_visitables.get("solvers").add(builder);this.solvers.add(builder);} return (A)this;
  }
  public A removeFromSolvers(io.fabric8.certmanager.api.model.acme.v1beta1.ACMEChallengeSolver... items) {
    for (ACMEChallengeSolver item : items) {ACMEChallengeSolverBuilder builder = new ACMEChallengeSolverBuilder(item);_visitables.get("solvers").remove(builder);if (this.solvers != null) {this.solvers.remove(builder);}} return (A)this;
  }
  public A removeAllFromSolvers(Collection<ACMEChallengeSolver> items) {
    for (ACMEChallengeSolver item : items) {ACMEChallengeSolverBuilder builder = new ACMEChallengeSolverBuilder(item);_visitables.get("solvers").remove(builder);if (this.solvers != null) {this.solvers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSolvers(Predicate<ACMEChallengeSolverBuilder> predicate) {
    if (solvers == null) return (A) this;
    final Iterator<ACMEChallengeSolverBuilder> each = solvers.iterator();
    final List visitables = _visitables.get("solvers");
    while (each.hasNext()) {
      ACMEChallengeSolverBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSolvers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ACMEChallengeSolver> getSolvers() {
    return solvers != null ? build(solvers) : null;
  }
  public List<ACMEChallengeSolver> buildSolvers() {
    return solvers != null ? build(solvers) : null;
  }
  public ACMEChallengeSolver buildSolver(Integer index) {
    return this.solvers.get(index).build();
  }
  public ACMEChallengeSolver buildFirstSolver() {
    return this.solvers.get(0).build();
  }
  public ACMEChallengeSolver buildLastSolver() {
    return this.solvers.get(solvers.size() - 1).build();
  }
  public ACMEChallengeSolver buildMatchingSolver(Predicate<ACMEChallengeSolverBuilder> predicate) {
    for (ACMEChallengeSolverBuilder item: solvers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingSolver(Predicate<ACMEChallengeSolverBuilder> predicate) {
    for (ACMEChallengeSolverBuilder item: solvers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSolvers(List<ACMEChallengeSolver> solvers) {
    if (this.solvers != null) { _visitables.get("solvers").removeAll(this.solvers);}
    if (solvers != null) {this.solvers = new ArrayList(); for (ACMEChallengeSolver item : solvers){this.addToSolvers(item);}} else { this.solvers = null;} return (A) this;
  }
  public A withSolvers(io.fabric8.certmanager.api.model.acme.v1beta1.ACMEChallengeSolver... solvers) {
    if (this.solvers != null) {this.solvers.clear();}
    if (solvers != null) {for (ACMEChallengeSolver item :solvers){ this.addToSolvers(item);}} return (A) this;
  }
  public Boolean hasSolvers() {
    return solvers != null && !solvers.isEmpty();
  }
  public ACMEIssuerFluent.SolversNested<A> addNewSolver() {
    return new ACMEIssuerFluentImpl.SolversNestedImpl();
  }
  public ACMEIssuerFluent.SolversNested<A> addNewSolverLike(ACMEChallengeSolver item) {
    return new ACMEIssuerFluentImpl.SolversNestedImpl(-1, item);
  }
  public ACMEIssuerFluent.SolversNested<A> setNewSolverLike(Integer index,ACMEChallengeSolver item) {
    return new ACMEIssuerFluentImpl.SolversNestedImpl(index, item);
  }
  public ACMEIssuerFluent.SolversNested<A> editSolver(Integer index) {
    if (solvers.size() <= index) throw new RuntimeException("Can't edit solvers. Index exceeds size.");
    return setNewSolverLike(index, buildSolver(index));
  }
  public ACMEIssuerFluent.SolversNested<A> editFirstSolver() {
    if (solvers.size() == 0) throw new RuntimeException("Can't edit first solvers. The list is empty.");
    return setNewSolverLike(0, buildSolver(0));
  }
  public ACMEIssuerFluent.SolversNested<A> editLastSolver() {
    int index = solvers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last solvers. The list is empty.");
    return setNewSolverLike(index, buildSolver(index));
  }
  public ACMEIssuerFluent.SolversNested<A> editMatchingSolver(Predicate<ACMEChallengeSolverBuilder> predicate) {
    int index = -1;
    for (int i=0;i<solvers.size();i++) { 
    if (predicate.test(solvers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching solvers. No match found.");
    return setNewSolverLike(index, buildSolver(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ACMEIssuerFluentImpl that = (ACMEIssuerFluentImpl) o;
    if (disableAccountKeyGeneration != null ? !disableAccountKeyGeneration.equals(that.disableAccountKeyGeneration) :that.disableAccountKeyGeneration != null) return false;
    if (email != null ? !email.equals(that.email) :that.email != null) return false;
    if (enableDurationFeature != null ? !enableDurationFeature.equals(that.enableDurationFeature) :that.enableDurationFeature != null) return false;
    if (externalAccountBinding != null ? !externalAccountBinding.equals(that.externalAccountBinding) :that.externalAccountBinding != null) return false;
    if (preferredChain != null ? !preferredChain.equals(that.preferredChain) :that.preferredChain != null) return false;
    if (privateKeySecretRef != null ? !privateKeySecretRef.equals(that.privateKeySecretRef) :that.privateKeySecretRef != null) return false;
    if (server != null ? !server.equals(that.server) :that.server != null) return false;
    if (skipTLSVerify != null ? !skipTLSVerify.equals(that.skipTLSVerify) :that.skipTLSVerify != null) return false;
    if (solvers != null ? !solvers.equals(that.solvers) :that.solvers != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(disableAccountKeyGeneration,  email,  enableDurationFeature,  externalAccountBinding,  preferredChain,  privateKeySecretRef,  server,  skipTLSVerify,  solvers,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (disableAccountKeyGeneration != null) { sb.append("disableAccountKeyGeneration:"); sb.append(disableAccountKeyGeneration + ","); }
    if (email != null) { sb.append("email:"); sb.append(email + ","); }
    if (enableDurationFeature != null) { sb.append("enableDurationFeature:"); sb.append(enableDurationFeature + ","); }
    if (externalAccountBinding != null) { sb.append("externalAccountBinding:"); sb.append(externalAccountBinding + ","); }
    if (preferredChain != null) { sb.append("preferredChain:"); sb.append(preferredChain + ","); }
    if (privateKeySecretRef != null) { sb.append("privateKeySecretRef:"); sb.append(privateKeySecretRef + ","); }
    if (server != null) { sb.append("server:"); sb.append(server + ","); }
    if (skipTLSVerify != null) { sb.append("skipTLSVerify:"); sb.append(skipTLSVerify + ","); }
    if (solvers != null && !solvers.isEmpty()) { sb.append("solvers:"); sb.append(solvers); }
    sb.append("}");
    return sb.toString();
  }
  public A withDisableAccountKeyGeneration() {
    return withDisableAccountKeyGeneration(true);
  }
  public A withEnableDurationFeature() {
    return withEnableDurationFeature(true);
  }
  public A withSkipTLSVerify() {
    return withSkipTLSVerify(true);
  }
  class ExternalAccountBindingNestedImpl<N> extends ACMEExternalAccountBindingFluentImpl<ACMEIssuerFluent.ExternalAccountBindingNested<N>> implements ACMEIssuerFluent.ExternalAccountBindingNested<N>,Nested<N>{
    ExternalAccountBindingNestedImpl(ACMEExternalAccountBinding item) {
      this.builder = new ACMEExternalAccountBindingBuilder(this, item);
    }
    ExternalAccountBindingNestedImpl() {
      this.builder = new ACMEExternalAccountBindingBuilder(this);
    }
    ACMEExternalAccountBindingBuilder builder;
    public N and() {
      return (N) ACMEIssuerFluentImpl.this.withExternalAccountBinding(builder.build());
    }
    public N endExternalAccountBinding() {
      return and();
    }
    
  }
  class PrivateKeySecretRefNestedImpl<N> extends SecretKeySelectorFluentImpl<ACMEIssuerFluent.PrivateKeySecretRefNested<N>> implements ACMEIssuerFluent.PrivateKeySecretRefNested<N>,Nested<N>{
    PrivateKeySecretRefNestedImpl(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    PrivateKeySecretRefNestedImpl() {
      this.builder = new SecretKeySelectorBuilder(this);
    }
    SecretKeySelectorBuilder builder;
    public N and() {
      return (N) ACMEIssuerFluentImpl.this.withPrivateKeySecretRef(builder.build());
    }
    public N endPrivateKeySecretRef() {
      return and();
    }
    
  }
  class SolversNestedImpl<N> extends ACMEChallengeSolverFluentImpl<ACMEIssuerFluent.SolversNested<N>> implements ACMEIssuerFluent.SolversNested<N>,Nested<N>{
    SolversNestedImpl(Integer index,ACMEChallengeSolver item) {
      this.index = index;
      this.builder = new ACMEChallengeSolverBuilder(this, item);
    }
    SolversNestedImpl() {
      this.index = -1;
      this.builder = new ACMEChallengeSolverBuilder(this);
    }
    ACMEChallengeSolverBuilder builder;
    Integer index;
    public N and() {
      return (N) ACMEIssuerFluentImpl.this.setToSolvers(index,builder.build());
    }
    public N endSolver() {
      return and();
    }
    
  }
  
}