package io.fabric8.certmanager.api.model.acme.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import java.lang.Deprecated;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ACMEIssuerDNS01ProviderAzureDNSFluentImpl<A extends ACMEIssuerDNS01ProviderAzureDNSFluent<A>> extends BaseFluent<A> implements ACMEIssuerDNS01ProviderAzureDNSFluent<A>{
  public ACMEIssuerDNS01ProviderAzureDNSFluentImpl() {
  }
  public ACMEIssuerDNS01ProviderAzureDNSFluentImpl(ACMEIssuerDNS01ProviderAzureDNS instance) {
    this.withClientID(instance.getClientID()); 
    this.withClientSecretSecretRef(instance.getClientSecretSecretRef()); 
    this.withEnvironment(instance.getEnvironment()); 
    this.withHostedZoneName(instance.getHostedZoneName()); 
    this.withResourceGroupName(instance.getResourceGroupName()); 
    this.withSubscriptionID(instance.getSubscriptionID()); 
    this.withTenantID(instance.getTenantID()); 
  }
  private String clientID;
  private SecretKeySelectorBuilder clientSecretSecretRef;
  private String environment;
  private String hostedZoneName;
  private String resourceGroupName;
  private String subscriptionID;
  private String tenantID;
  public String getClientID() {
    return this.clientID;
  }
  public A withClientID(String clientID) {
    this.clientID=clientID; return (A) this;
  }
  public Boolean hasClientID() {
    return this.clientID != null;
  }
  
  /**
   * This method has been deprecated, please use method buildClientSecretSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretKeySelector getClientSecretSecretRef() {
    return this.clientSecretSecretRef!=null ?this.clientSecretSecretRef.build():null;
  }
  public SecretKeySelector buildClientSecretSecretRef() {
    return this.clientSecretSecretRef!=null ?this.clientSecretSecretRef.build():null;
  }
  public A withClientSecretSecretRef(SecretKeySelector clientSecretSecretRef) {
    _visitables.get("clientSecretSecretRef").remove(this.clientSecretSecretRef);
    if (clientSecretSecretRef!=null){ this.clientSecretSecretRef= new SecretKeySelectorBuilder(clientSecretSecretRef); _visitables.get("clientSecretSecretRef").add(this.clientSecretSecretRef);} else { this.clientSecretSecretRef = null; _visitables.get("clientSecretSecretRef").remove(this.clientSecretSecretRef); } return (A) this;
  }
  public Boolean hasClientSecretSecretRef() {
    return this.clientSecretSecretRef != null;
  }
  public A withNewClientSecretSecretRef(String key,String name) {
    return (A)withClientSecretSecretRef(new SecretKeySelector(key, name));
  }
  public ACMEIssuerDNS01ProviderAzureDNSFluent.ClientSecretSecretRefNested<A> withNewClientSecretSecretRef() {
    return new ACMEIssuerDNS01ProviderAzureDNSFluentImpl.ClientSecretSecretRefNestedImpl();
  }
  public ACMEIssuerDNS01ProviderAzureDNSFluent.ClientSecretSecretRefNested<A> withNewClientSecretSecretRefLike(SecretKeySelector item) {
    return new ACMEIssuerDNS01ProviderAzureDNSFluentImpl.ClientSecretSecretRefNestedImpl(item);
  }
  public ACMEIssuerDNS01ProviderAzureDNSFluent.ClientSecretSecretRefNested<A> editClientSecretSecretRef() {
    return withNewClientSecretSecretRefLike(getClientSecretSecretRef());
  }
  public ACMEIssuerDNS01ProviderAzureDNSFluent.ClientSecretSecretRefNested<A> editOrNewClientSecretSecretRef() {
    return withNewClientSecretSecretRefLike(getClientSecretSecretRef() != null ? getClientSecretSecretRef(): new SecretKeySelectorBuilder().build());
  }
  public ACMEIssuerDNS01ProviderAzureDNSFluent.ClientSecretSecretRefNested<A> editOrNewClientSecretSecretRefLike(SecretKeySelector item) {
    return withNewClientSecretSecretRefLike(getClientSecretSecretRef() != null ? getClientSecretSecretRef(): item);
  }
  public String getEnvironment() {
    return this.environment;
  }
  public A withEnvironment(String environment) {
    this.environment=environment; return (A) this;
  }
  public Boolean hasEnvironment() {
    return this.environment != null;
  }
  public String getHostedZoneName() {
    return this.hostedZoneName;
  }
  public A withHostedZoneName(String hostedZoneName) {
    this.hostedZoneName=hostedZoneName; return (A) this;
  }
  public Boolean hasHostedZoneName() {
    return this.hostedZoneName != null;
  }
  public String getResourceGroupName() {
    return this.resourceGroupName;
  }
  public A withResourceGroupName(String resourceGroupName) {
    this.resourceGroupName=resourceGroupName; return (A) this;
  }
  public Boolean hasResourceGroupName() {
    return this.resourceGroupName != null;
  }
  public String getSubscriptionID() {
    return this.subscriptionID;
  }
  public A withSubscriptionID(String subscriptionID) {
    this.subscriptionID=subscriptionID; return (A) this;
  }
  public Boolean hasSubscriptionID() {
    return this.subscriptionID != null;
  }
  public String getTenantID() {
    return this.tenantID;
  }
  public A withTenantID(String tenantID) {
    this.tenantID=tenantID; return (A) this;
  }
  public Boolean hasTenantID() {
    return this.tenantID != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ACMEIssuerDNS01ProviderAzureDNSFluentImpl that = (ACMEIssuerDNS01ProviderAzureDNSFluentImpl) o;
    if (clientID != null ? !clientID.equals(that.clientID) :that.clientID != null) return false;
    if (clientSecretSecretRef != null ? !clientSecretSecretRef.equals(that.clientSecretSecretRef) :that.clientSecretSecretRef != null) return false;
    if (environment != null ? !environment.equals(that.environment) :that.environment != null) return false;
    if (hostedZoneName != null ? !hostedZoneName.equals(that.hostedZoneName) :that.hostedZoneName != null) return false;
    if (resourceGroupName != null ? !resourceGroupName.equals(that.resourceGroupName) :that.resourceGroupName != null) return false;
    if (subscriptionID != null ? !subscriptionID.equals(that.subscriptionID) :that.subscriptionID != null) return false;
    if (tenantID != null ? !tenantID.equals(that.tenantID) :that.tenantID != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(clientID,  clientSecretSecretRef,  environment,  hostedZoneName,  resourceGroupName,  subscriptionID,  tenantID,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clientID != null) { sb.append("clientID:"); sb.append(clientID + ","); }
    if (clientSecretSecretRef != null) { sb.append("clientSecretSecretRef:"); sb.append(clientSecretSecretRef + ","); }
    if (environment != null) { sb.append("environment:"); sb.append(environment + ","); }
    if (hostedZoneName != null) { sb.append("hostedZoneName:"); sb.append(hostedZoneName + ","); }
    if (resourceGroupName != null) { sb.append("resourceGroupName:"); sb.append(resourceGroupName + ","); }
    if (subscriptionID != null) { sb.append("subscriptionID:"); sb.append(subscriptionID + ","); }
    if (tenantID != null) { sb.append("tenantID:"); sb.append(tenantID); }
    sb.append("}");
    return sb.toString();
  }
  class ClientSecretSecretRefNestedImpl<N> extends SecretKeySelectorFluentImpl<ACMEIssuerDNS01ProviderAzureDNSFluent.ClientSecretSecretRefNested<N>> implements ACMEIssuerDNS01ProviderAzureDNSFluent.ClientSecretSecretRefNested<N>,Nested<N>{
    ClientSecretSecretRefNestedImpl(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    ClientSecretSecretRefNestedImpl() {
      this.builder = new SecretKeySelectorBuilder(this);
    }
    SecretKeySelectorBuilder builder;
    public N and() {
      return (N) ACMEIssuerDNS01ProviderAzureDNSFluentImpl.this.withClientSecretSecretRef(builder.build());
    }
    public N endClientSecretSecretRef() {
      return and();
    }
    
  }
  
}