package io.fabric8.certmanager.api.model.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VaultIssuerBuilder extends VaultIssuerFluentImpl<VaultIssuerBuilder> implements VisitableBuilder<io.fabric8.certmanager.api.model.v1beta1.VaultIssuer,io.fabric8.certmanager.api.model.v1beta1.VaultIssuerBuilder>{
  public VaultIssuerBuilder() {
    this(false);
  }
  public VaultIssuerBuilder(Boolean validationEnabled) {
    this(new VaultIssuer(), validationEnabled);
  }
  public VaultIssuerBuilder(VaultIssuerFluent<?> fluent) {
    this(fluent, false);
  }
  public VaultIssuerBuilder(io.fabric8.certmanager.api.model.v1beta1.VaultIssuerFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new VaultIssuer(), validationEnabled);
  }
  public VaultIssuerBuilder(io.fabric8.certmanager.api.model.v1beta1.VaultIssuerFluent<?> fluent,io.fabric8.certmanager.api.model.v1beta1.VaultIssuer instance) {
    this(fluent, instance, false);
  }
  public VaultIssuerBuilder(io.fabric8.certmanager.api.model.v1beta1.VaultIssuerFluent<?> fluent,io.fabric8.certmanager.api.model.v1beta1.VaultIssuer instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAuth(instance.getAuth()); 
    fluent.withCaBundle(instance.getCaBundle()); 
    fluent.withNamespace(instance.getNamespace()); 
    fluent.withPath(instance.getPath()); 
    fluent.withServer(instance.getServer()); 
    this.validationEnabled = validationEnabled; 
  }
  public VaultIssuerBuilder(io.fabric8.certmanager.api.model.v1beta1.VaultIssuer instance) {
    this(instance,false);
  }
  public VaultIssuerBuilder(io.fabric8.certmanager.api.model.v1beta1.VaultIssuer instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAuth(instance.getAuth()); 
    this.withCaBundle(instance.getCaBundle()); 
    this.withNamespace(instance.getNamespace()); 
    this.withPath(instance.getPath()); 
    this.withServer(instance.getServer()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.certmanager.api.model.v1beta1.VaultIssuerFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.certmanager.api.model.v1beta1.VaultIssuer build() {
    VaultIssuer buildable = new VaultIssuer(fluent.getAuth(),fluent.getCaBundle(),fluent.getNamespace(),fluent.getPath(),fluent.getServer());
    return buildable;
  }
  
}