package io.fabric8.certmanager.api.model.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SelfSignedIssuerBuilder extends SelfSignedIssuerFluentImpl<SelfSignedIssuerBuilder> implements VisitableBuilder<SelfSignedIssuer,io.fabric8.certmanager.api.model.v1beta1.SelfSignedIssuerBuilder>{
  public SelfSignedIssuerBuilder() {
    this(false);
  }
  public SelfSignedIssuerBuilder(Boolean validationEnabled) {
    this(new SelfSignedIssuer(), validationEnabled);
  }
  public SelfSignedIssuerBuilder(io.fabric8.certmanager.api.model.v1beta1.SelfSignedIssuerFluent<?> fluent) {
    this(fluent, false);
  }
  public SelfSignedIssuerBuilder(io.fabric8.certmanager.api.model.v1beta1.SelfSignedIssuerFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new SelfSignedIssuer(), validationEnabled);
  }
  public SelfSignedIssuerBuilder(io.fabric8.certmanager.api.model.v1beta1.SelfSignedIssuerFluent<?> fluent,io.fabric8.certmanager.api.model.v1beta1.SelfSignedIssuer instance) {
    this(fluent, instance, false);
  }
  public SelfSignedIssuerBuilder(io.fabric8.certmanager.api.model.v1beta1.SelfSignedIssuerFluent<?> fluent,io.fabric8.certmanager.api.model.v1beta1.SelfSignedIssuer instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCrlDistributionPoints(instance.getCrlDistributionPoints()); 
    this.validationEnabled = validationEnabled; 
  }
  public SelfSignedIssuerBuilder(io.fabric8.certmanager.api.model.v1beta1.SelfSignedIssuer instance) {
    this(instance,false);
  }
  public SelfSignedIssuerBuilder(io.fabric8.certmanager.api.model.v1beta1.SelfSignedIssuer instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCrlDistributionPoints(instance.getCrlDistributionPoints()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.certmanager.api.model.v1beta1.SelfSignedIssuerFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.certmanager.api.model.v1beta1.SelfSignedIssuer build() {
    SelfSignedIssuer buildable = new SelfSignedIssuer(fluent.getCrlDistributionPoints());
    return buildable;
  }
  
}