package io.fabric8.certmanager.api.model.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IssuerStatusBuilder extends IssuerStatusFluentImpl<IssuerStatusBuilder> implements VisitableBuilder<io.fabric8.certmanager.api.model.v1beta1.IssuerStatus,IssuerStatusBuilder>{
  public IssuerStatusBuilder() {
    this(false);
  }
  public IssuerStatusBuilder(Boolean validationEnabled) {
    this(new IssuerStatus(), validationEnabled);
  }
  public IssuerStatusBuilder(IssuerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public IssuerStatusBuilder(io.fabric8.certmanager.api.model.v1beta1.IssuerStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new IssuerStatus(), validationEnabled);
  }
  public IssuerStatusBuilder(io.fabric8.certmanager.api.model.v1beta1.IssuerStatusFluent<?> fluent,io.fabric8.certmanager.api.model.v1beta1.IssuerStatus instance) {
    this(fluent, instance, false);
  }
  public IssuerStatusBuilder(io.fabric8.certmanager.api.model.v1beta1.IssuerStatusFluent<?> fluent,io.fabric8.certmanager.api.model.v1beta1.IssuerStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAcme(instance.getAcme()); 
    fluent.withConditions(instance.getConditions()); 
    this.validationEnabled = validationEnabled; 
  }
  public IssuerStatusBuilder(io.fabric8.certmanager.api.model.v1beta1.IssuerStatus instance) {
    this(instance,false);
  }
  public IssuerStatusBuilder(io.fabric8.certmanager.api.model.v1beta1.IssuerStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAcme(instance.getAcme()); 
    this.withConditions(instance.getConditions()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.certmanager.api.model.v1beta1.IssuerStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.certmanager.api.model.v1beta1.IssuerStatus build() {
    IssuerStatus buildable = new IssuerStatus(fluent.getAcme(),fluent.getConditions());
    return buildable;
  }
  
}