package io.fabric8.certmanager.api.model.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IssuerSpecBuilder extends IssuerSpecFluentImpl<IssuerSpecBuilder> implements VisitableBuilder<io.fabric8.certmanager.api.model.v1beta1.IssuerSpec,io.fabric8.certmanager.api.model.v1beta1.IssuerSpecBuilder>{
  public IssuerSpecBuilder() {
    this(false);
  }
  public IssuerSpecBuilder(Boolean validationEnabled) {
    this(new IssuerSpec(), validationEnabled);
  }
  public IssuerSpecBuilder(IssuerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public IssuerSpecBuilder(io.fabric8.certmanager.api.model.v1beta1.IssuerSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new IssuerSpec(), validationEnabled);
  }
  public IssuerSpecBuilder(io.fabric8.certmanager.api.model.v1beta1.IssuerSpecFluent<?> fluent,io.fabric8.certmanager.api.model.v1beta1.IssuerSpec instance) {
    this(fluent, instance, false);
  }
  public IssuerSpecBuilder(io.fabric8.certmanager.api.model.v1beta1.IssuerSpecFluent<?> fluent,io.fabric8.certmanager.api.model.v1beta1.IssuerSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAcme(instance.getAcme()); 
    fluent.withCa(instance.getCa()); 
    fluent.withSelfSigned(instance.getSelfSigned()); 
    fluent.withVault(instance.getVault()); 
    fluent.withVenafi(instance.getVenafi()); 
    this.validationEnabled = validationEnabled; 
  }
  public IssuerSpecBuilder(io.fabric8.certmanager.api.model.v1beta1.IssuerSpec instance) {
    this(instance,false);
  }
  public IssuerSpecBuilder(io.fabric8.certmanager.api.model.v1beta1.IssuerSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAcme(instance.getAcme()); 
    this.withCa(instance.getCa()); 
    this.withSelfSigned(instance.getSelfSigned()); 
    this.withVault(instance.getVault()); 
    this.withVenafi(instance.getVenafi()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.certmanager.api.model.v1beta1.IssuerSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.certmanager.api.model.v1beta1.IssuerSpec build() {
    IssuerSpec buildable = new IssuerSpec(fluent.getAcme(),fluent.getCa(),fluent.getSelfSigned(),fluent.getVault(),fluent.getVenafi());
    return buildable;
  }
  
}