package io.fabric8.certmanager.api.model.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.Integer;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CertificateSpecFluentImpl<A extends CertificateSpecFluent<A>> extends BaseFluent<A> implements CertificateSpecFluent<A>{
  public CertificateSpecFluentImpl() {
  }
  public CertificateSpecFluentImpl(io.fabric8.certmanager.api.model.v1beta1.CertificateSpec instance) {
    this.withCommonName(instance.getCommonName()); 
    this.withDnsNames(instance.getDnsNames()); 
    this.withDuration(instance.getDuration()); 
    this.withEmailSANs(instance.getEmailSANs()); 
    this.withEncodeUsagesInRequest(instance.getEncodeUsagesInRequest()); 
    this.withIpAddresses(instance.getIpAddresses()); 
    this.withIsCA(instance.getIsCA()); 
    this.withIssuerRef(instance.getIssuerRef()); 
    this.withKeystores(instance.getKeystores()); 
    this.withPrivateKey(instance.getPrivateKey()); 
    this.withRenewBefore(instance.getRenewBefore()); 
    this.withSecretName(instance.getSecretName()); 
    this.withSubject(instance.getSubject()); 
    this.withUriSANs(instance.getUriSANs()); 
    this.withUsages(instance.getUsages()); 
  }
  private String commonName;
  private List<java.lang.String> dnsNames = new ArrayList<java.lang.String>();
  private Duration duration;
  private java.util.List<java.lang.String> emailSANs = new java.util.ArrayList<java.lang.String>();
  private Boolean encodeUsagesInRequest;
  private java.util.List<java.lang.String> ipAddresses = new java.util.ArrayList<java.lang.String>();
  private java.lang.Boolean isCA;
  private ObjectReferenceBuilder issuerRef;
  private CertificateKeystoresBuilder keystores;
  private CertificatePrivateKeyBuilder privateKey;
  private io.fabric8.kubernetes.api.model.Duration renewBefore;
  private java.lang.String secretName;
  private X509SubjectBuilder subject;
  private java.util.List<java.lang.String> uriSANs = new java.util.ArrayList<java.lang.String>();
  private java.util.List<java.lang.String> usages = new java.util.ArrayList<java.lang.String>();
  public java.lang.String getCommonName() {
    return this.commonName;
  }
  public A withCommonName(java.lang.String commonName) {
    this.commonName=commonName; return (A) this;
  }
  public java.lang.Boolean hasCommonName() {
    return this.commonName != null;
  }
  public A addToDnsNames(Integer index,java.lang.String item) {
    if (this.dnsNames == null) {this.dnsNames = new java.util.ArrayList<java.lang.String>();}
    this.dnsNames.add(index, item);
    return (A)this;
  }
  public A setToDnsNames(java.lang.Integer index,java.lang.String item) {
    if (this.dnsNames == null) {this.dnsNames = new java.util.ArrayList<java.lang.String>();}
    this.dnsNames.set(index, item); return (A)this;
  }
  public A addToDnsNames(java.lang.String... items) {
    if (this.dnsNames == null) {this.dnsNames = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.dnsNames.add(item);} return (A)this;
  }
  public A addAllToDnsNames(Collection<java.lang.String> items) {
    if (this.dnsNames == null) {this.dnsNames = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.dnsNames.add(item);} return (A)this;
  }
  public A removeFromDnsNames(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.dnsNames!= null){ this.dnsNames.remove(item);}} return (A)this;
  }
  public A removeAllFromDnsNames(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.dnsNames!= null){ this.dnsNames.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getDnsNames() {
    return this.dnsNames;
  }
  public java.lang.String getDnsName(java.lang.Integer index) {
    return this.dnsNames.get(index);
  }
  public java.lang.String getFirstDnsName() {
    return this.dnsNames.get(0);
  }
  public java.lang.String getLastDnsName() {
    return this.dnsNames.get(dnsNames.size() - 1);
  }
  public java.lang.String getMatchingDnsName(Predicate<java.lang.String> predicate) {
    for (java.lang.String item: dnsNames) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingDnsName(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: dnsNames) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDnsNames(java.util.List<java.lang.String> dnsNames) {
    if (dnsNames != null) {this.dnsNames = new java.util.ArrayList(); for (java.lang.String item : dnsNames){this.addToDnsNames(item);}} else { this.dnsNames = null;} return (A) this;
  }
  public A withDnsNames(java.lang.String... dnsNames) {
    if (this.dnsNames != null) {this.dnsNames.clear();}
    if (dnsNames != null) {for (java.lang.String item :dnsNames){ this.addToDnsNames(item);}} return (A) this;
  }
  public java.lang.Boolean hasDnsNames() {
    return dnsNames != null && !dnsNames.isEmpty();
  }
  public io.fabric8.kubernetes.api.model.Duration getDuration() {
    return this.duration;
  }
  public A withDuration(io.fabric8.kubernetes.api.model.Duration duration) {
    this.duration=duration; return (A) this;
  }
  public java.lang.Boolean hasDuration() {
    return this.duration != null;
  }
  public A addToEmailSANs(java.lang.Integer index,java.lang.String item) {
    if (this.emailSANs == null) {this.emailSANs = new java.util.ArrayList<java.lang.String>();}
    this.emailSANs.add(index, item);
    return (A)this;
  }
  public A setToEmailSANs(java.lang.Integer index,java.lang.String item) {
    if (this.emailSANs == null) {this.emailSANs = new java.util.ArrayList<java.lang.String>();}
    this.emailSANs.set(index, item); return (A)this;
  }
  public A addToEmailSANs(java.lang.String... items) {
    if (this.emailSANs == null) {this.emailSANs = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.emailSANs.add(item);} return (A)this;
  }
  public A addAllToEmailSANs(java.util.Collection<java.lang.String> items) {
    if (this.emailSANs == null) {this.emailSANs = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.emailSANs.add(item);} return (A)this;
  }
  public A removeFromEmailSANs(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.emailSANs!= null){ this.emailSANs.remove(item);}} return (A)this;
  }
  public A removeAllFromEmailSANs(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.emailSANs!= null){ this.emailSANs.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getEmailSANs() {
    return this.emailSANs;
  }
  public java.lang.String getEmailSAN(java.lang.Integer index) {
    return this.emailSANs.get(index);
  }
  public java.lang.String getFirstEmailSAN() {
    return this.emailSANs.get(0);
  }
  public java.lang.String getLastEmailSAN() {
    return this.emailSANs.get(emailSANs.size() - 1);
  }
  public java.lang.String getMatchingEmailSAN(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: emailSANs) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingEmailSAN(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: emailSANs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEmailSANs(java.util.List<java.lang.String> emailSANs) {
    if (emailSANs != null) {this.emailSANs = new java.util.ArrayList(); for (java.lang.String item : emailSANs){this.addToEmailSANs(item);}} else { this.emailSANs = null;} return (A) this;
  }
  public A withEmailSANs(java.lang.String... emailSANs) {
    if (this.emailSANs != null) {this.emailSANs.clear();}
    if (emailSANs != null) {for (java.lang.String item :emailSANs){ this.addToEmailSANs(item);}} return (A) this;
  }
  public java.lang.Boolean hasEmailSANs() {
    return emailSANs != null && !emailSANs.isEmpty();
  }
  public java.lang.Boolean getEncodeUsagesInRequest() {
    return this.encodeUsagesInRequest;
  }
  public A withEncodeUsagesInRequest(java.lang.Boolean encodeUsagesInRequest) {
    this.encodeUsagesInRequest=encodeUsagesInRequest; return (A) this;
  }
  public java.lang.Boolean hasEncodeUsagesInRequest() {
    return this.encodeUsagesInRequest != null;
  }
  public A addToIpAddresses(java.lang.Integer index,java.lang.String item) {
    if (this.ipAddresses == null) {this.ipAddresses = new java.util.ArrayList<java.lang.String>();}
    this.ipAddresses.add(index, item);
    return (A)this;
  }
  public A setToIpAddresses(java.lang.Integer index,java.lang.String item) {
    if (this.ipAddresses == null) {this.ipAddresses = new java.util.ArrayList<java.lang.String>();}
    this.ipAddresses.set(index, item); return (A)this;
  }
  public A addToIpAddresses(java.lang.String... items) {
    if (this.ipAddresses == null) {this.ipAddresses = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.ipAddresses.add(item);} return (A)this;
  }
  public A addAllToIpAddresses(java.util.Collection<java.lang.String> items) {
    if (this.ipAddresses == null) {this.ipAddresses = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.ipAddresses.add(item);} return (A)this;
  }
  public A removeFromIpAddresses(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.ipAddresses!= null){ this.ipAddresses.remove(item);}} return (A)this;
  }
  public A removeAllFromIpAddresses(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.ipAddresses!= null){ this.ipAddresses.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getIpAddresses() {
    return this.ipAddresses;
  }
  public java.lang.String getIpAddress(java.lang.Integer index) {
    return this.ipAddresses.get(index);
  }
  public java.lang.String getFirstIpAddress() {
    return this.ipAddresses.get(0);
  }
  public java.lang.String getLastIpAddress() {
    return this.ipAddresses.get(ipAddresses.size() - 1);
  }
  public java.lang.String getMatchingIpAddress(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: ipAddresses) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingIpAddress(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: ipAddresses) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withIpAddresses(java.util.List<java.lang.String> ipAddresses) {
    if (ipAddresses != null) {this.ipAddresses = new java.util.ArrayList(); for (java.lang.String item : ipAddresses){this.addToIpAddresses(item);}} else { this.ipAddresses = null;} return (A) this;
  }
  public A withIpAddresses(java.lang.String... ipAddresses) {
    if (this.ipAddresses != null) {this.ipAddresses.clear();}
    if (ipAddresses != null) {for (java.lang.String item :ipAddresses){ this.addToIpAddresses(item);}} return (A) this;
  }
  public java.lang.Boolean hasIpAddresses() {
    return ipAddresses != null && !ipAddresses.isEmpty();
  }
  public java.lang.Boolean getIsCA() {
    return this.isCA;
  }
  public A withIsCA(java.lang.Boolean isCA) {
    this.isCA=isCA; return (A) this;
  }
  public java.lang.Boolean hasIsCA() {
    return this.isCA != null;
  }
  
  /**
   * This method has been deprecated, please use method buildIssuerRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public io.fabric8.certmanager.api.model.meta.v1.ObjectReference getIssuerRef() {
    return this.issuerRef!=null ?this.issuerRef.build():null;
  }
  public io.fabric8.certmanager.api.model.meta.v1.ObjectReference buildIssuerRef() {
    return this.issuerRef!=null ?this.issuerRef.build():null;
  }
  public A withIssuerRef(io.fabric8.certmanager.api.model.meta.v1.ObjectReference issuerRef) {
    _visitables.get("issuerRef").remove(this.issuerRef);
    if (issuerRef!=null){ this.issuerRef= new ObjectReferenceBuilder(issuerRef); _visitables.get("issuerRef").add(this.issuerRef);} return (A) this;
  }
  public java.lang.Boolean hasIssuerRef() {
    return this.issuerRef != null;
  }
  public A withNewIssuerRef(java.lang.String group,java.lang.String kind,java.lang.String name) {
    return (A)withIssuerRef(new ObjectReference(group, kind, name));
  }
  public CertificateSpecFluent.IssuerRefNested<A> withNewIssuerRef() {
    return new CertificateSpecFluentImpl.IssuerRefNestedImpl();
  }
  public io.fabric8.certmanager.api.model.v1beta1.CertificateSpecFluent.IssuerRefNested<A> withNewIssuerRefLike(io.fabric8.certmanager.api.model.meta.v1.ObjectReference item) {
    return new CertificateSpecFluentImpl.IssuerRefNestedImpl(item);
  }
  public io.fabric8.certmanager.api.model.v1beta1.CertificateSpecFluent.IssuerRefNested<A> editIssuerRef() {
    return withNewIssuerRefLike(getIssuerRef());
  }
  public io.fabric8.certmanager.api.model.v1beta1.CertificateSpecFluent.IssuerRefNested<A> editOrNewIssuerRef() {
    return withNewIssuerRefLike(getIssuerRef() != null ? getIssuerRef(): new io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder().build());
  }
  public io.fabric8.certmanager.api.model.v1beta1.CertificateSpecFluent.IssuerRefNested<A> editOrNewIssuerRefLike(io.fabric8.certmanager.api.model.meta.v1.ObjectReference item) {
    return withNewIssuerRefLike(getIssuerRef() != null ? getIssuerRef(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildKeystores instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.certmanager.api.model.v1beta1.CertificateKeystores getKeystores() {
    return this.keystores!=null ?this.keystores.build():null;
  }
  public io.fabric8.certmanager.api.model.v1beta1.CertificateKeystores buildKeystores() {
    return this.keystores!=null ?this.keystores.build():null;
  }
  public A withKeystores(io.fabric8.certmanager.api.model.v1beta1.CertificateKeystores keystores) {
    _visitables.get("keystores").remove(this.keystores);
    if (keystores!=null){ this.keystores= new CertificateKeystoresBuilder(keystores); _visitables.get("keystores").add(this.keystores);} return (A) this;
  }
  public java.lang.Boolean hasKeystores() {
    return this.keystores != null;
  }
  public CertificateSpecFluent.KeystoresNested<A> withNewKeystores() {
    return new CertificateSpecFluentImpl.KeystoresNestedImpl();
  }
  public io.fabric8.certmanager.api.model.v1beta1.CertificateSpecFluent.KeystoresNested<A> withNewKeystoresLike(io.fabric8.certmanager.api.model.v1beta1.CertificateKeystores item) {
    return new io.fabric8.certmanager.api.model.v1beta1.CertificateSpecFluentImpl.KeystoresNestedImpl(item);
  }
  public io.fabric8.certmanager.api.model.v1beta1.CertificateSpecFluent.KeystoresNested<A> editKeystores() {
    return withNewKeystoresLike(getKeystores());
  }
  public io.fabric8.certmanager.api.model.v1beta1.CertificateSpecFluent.KeystoresNested<A> editOrNewKeystores() {
    return withNewKeystoresLike(getKeystores() != null ? getKeystores(): new io.fabric8.certmanager.api.model.v1beta1.CertificateKeystoresBuilder().build());
  }
  public io.fabric8.certmanager.api.model.v1beta1.CertificateSpecFluent.KeystoresNested<A> editOrNewKeystoresLike(io.fabric8.certmanager.api.model.v1beta1.CertificateKeystores item) {
    return withNewKeystoresLike(getKeystores() != null ? getKeystores(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPrivateKey instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public CertificatePrivateKey getPrivateKey() {
    return this.privateKey!=null ?this.privateKey.build():null;
  }
  public io.fabric8.certmanager.api.model.v1beta1.CertificatePrivateKey buildPrivateKey() {
    return this.privateKey!=null ?this.privateKey.build():null;
  }
  public A withPrivateKey(io.fabric8.certmanager.api.model.v1beta1.CertificatePrivateKey privateKey) {
    _visitables.get("privateKey").remove(this.privateKey);
    if (privateKey!=null){ this.privateKey= new io.fabric8.certmanager.api.model.v1beta1.CertificatePrivateKeyBuilder(privateKey); _visitables.get("privateKey").add(this.privateKey);} return (A) this;
  }
  public java.lang.Boolean hasPrivateKey() {
    return this.privateKey != null;
  }
  public A withNewPrivateKey(java.lang.String algorithm,java.lang.String encoding,java.lang.String rotationPolicy,java.lang.Integer size) {
    return (A)withPrivateKey(new CertificatePrivateKey(algorithm, encoding, rotationPolicy, size));
  }
  public CertificateSpecFluent.PrivateKeyNested<A> withNewPrivateKey() {
    return new CertificateSpecFluentImpl.PrivateKeyNestedImpl();
  }
  public io.fabric8.certmanager.api.model.v1beta1.CertificateSpecFluent.PrivateKeyNested<A> withNewPrivateKeyLike(io.fabric8.certmanager.api.model.v1beta1.CertificatePrivateKey item) {
    return new io.fabric8.certmanager.api.model.v1beta1.CertificateSpecFluentImpl.PrivateKeyNestedImpl(item);
  }
  public io.fabric8.certmanager.api.model.v1beta1.CertificateSpecFluent.PrivateKeyNested<A> editPrivateKey() {
    return withNewPrivateKeyLike(getPrivateKey());
  }
  public io.fabric8.certmanager.api.model.v1beta1.CertificateSpecFluent.PrivateKeyNested<A> editOrNewPrivateKey() {
    return withNewPrivateKeyLike(getPrivateKey() != null ? getPrivateKey(): new io.fabric8.certmanager.api.model.v1beta1.CertificatePrivateKeyBuilder().build());
  }
  public io.fabric8.certmanager.api.model.v1beta1.CertificateSpecFluent.PrivateKeyNested<A> editOrNewPrivateKeyLike(io.fabric8.certmanager.api.model.v1beta1.CertificatePrivateKey item) {
    return withNewPrivateKeyLike(getPrivateKey() != null ? getPrivateKey(): item);
  }
  public io.fabric8.kubernetes.api.model.Duration getRenewBefore() {
    return this.renewBefore;
  }
  public A withRenewBefore(io.fabric8.kubernetes.api.model.Duration renewBefore) {
    this.renewBefore=renewBefore; return (A) this;
  }
  public java.lang.Boolean hasRenewBefore() {
    return this.renewBefore != null;
  }
  public java.lang.String getSecretName() {
    return this.secretName;
  }
  public A withSecretName(java.lang.String secretName) {
    this.secretName=secretName; return (A) this;
  }
  public java.lang.Boolean hasSecretName() {
    return this.secretName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSubject instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.certmanager.api.model.v1beta1.X509Subject getSubject() {
    return this.subject!=null ?this.subject.build():null;
  }
  public io.fabric8.certmanager.api.model.v1beta1.X509Subject buildSubject() {
    return this.subject!=null ?this.subject.build():null;
  }
  public A withSubject(io.fabric8.certmanager.api.model.v1beta1.X509Subject subject) {
    _visitables.get("subject").remove(this.subject);
    if (subject!=null){ this.subject= new X509SubjectBuilder(subject); _visitables.get("subject").add(this.subject);} return (A) this;
  }
  public java.lang.Boolean hasSubject() {
    return this.subject != null;
  }
  public CertificateSpecFluent.SubjectNested<A> withNewSubject() {
    return new CertificateSpecFluentImpl.SubjectNestedImpl();
  }
  public io.fabric8.certmanager.api.model.v1beta1.CertificateSpecFluent.SubjectNested<A> withNewSubjectLike(io.fabric8.certmanager.api.model.v1beta1.X509Subject item) {
    return new io.fabric8.certmanager.api.model.v1beta1.CertificateSpecFluentImpl.SubjectNestedImpl(item);
  }
  public io.fabric8.certmanager.api.model.v1beta1.CertificateSpecFluent.SubjectNested<A> editSubject() {
    return withNewSubjectLike(getSubject());
  }
  public io.fabric8.certmanager.api.model.v1beta1.CertificateSpecFluent.SubjectNested<A> editOrNewSubject() {
    return withNewSubjectLike(getSubject() != null ? getSubject(): new io.fabric8.certmanager.api.model.v1beta1.X509SubjectBuilder().build());
  }
  public io.fabric8.certmanager.api.model.v1beta1.CertificateSpecFluent.SubjectNested<A> editOrNewSubjectLike(io.fabric8.certmanager.api.model.v1beta1.X509Subject item) {
    return withNewSubjectLike(getSubject() != null ? getSubject(): item);
  }
  public A addToUriSANs(java.lang.Integer index,java.lang.String item) {
    if (this.uriSANs == null) {this.uriSANs = new java.util.ArrayList<java.lang.String>();}
    this.uriSANs.add(index, item);
    return (A)this;
  }
  public A setToUriSANs(java.lang.Integer index,java.lang.String item) {
    if (this.uriSANs == null) {this.uriSANs = new java.util.ArrayList<java.lang.String>();}
    this.uriSANs.set(index, item); return (A)this;
  }
  public A addToUriSANs(java.lang.String... items) {
    if (this.uriSANs == null) {this.uriSANs = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.uriSANs.add(item);} return (A)this;
  }
  public A addAllToUriSANs(java.util.Collection<java.lang.String> items) {
    if (this.uriSANs == null) {this.uriSANs = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.uriSANs.add(item);} return (A)this;
  }
  public A removeFromUriSANs(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.uriSANs!= null){ this.uriSANs.remove(item);}} return (A)this;
  }
  public A removeAllFromUriSANs(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.uriSANs!= null){ this.uriSANs.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getUriSANs() {
    return this.uriSANs;
  }
  public java.lang.String getUriSAN(java.lang.Integer index) {
    return this.uriSANs.get(index);
  }
  public java.lang.String getFirstUriSAN() {
    return this.uriSANs.get(0);
  }
  public java.lang.String getLastUriSAN() {
    return this.uriSANs.get(uriSANs.size() - 1);
  }
  public java.lang.String getMatchingUriSAN(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: uriSANs) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingUriSAN(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: uriSANs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withUriSANs(java.util.List<java.lang.String> uriSANs) {
    if (uriSANs != null) {this.uriSANs = new java.util.ArrayList(); for (java.lang.String item : uriSANs){this.addToUriSANs(item);}} else { this.uriSANs = null;} return (A) this;
  }
  public A withUriSANs(java.lang.String... uriSANs) {
    if (this.uriSANs != null) {this.uriSANs.clear();}
    if (uriSANs != null) {for (java.lang.String item :uriSANs){ this.addToUriSANs(item);}} return (A) this;
  }
  public java.lang.Boolean hasUriSANs() {
    return uriSANs != null && !uriSANs.isEmpty();
  }
  public A addToUsages(java.lang.Integer index,java.lang.String item) {
    if (this.usages == null) {this.usages = new java.util.ArrayList<java.lang.String>();}
    this.usages.add(index, item);
    return (A)this;
  }
  public A setToUsages(java.lang.Integer index,java.lang.String item) {
    if (this.usages == null) {this.usages = new java.util.ArrayList<java.lang.String>();}
    this.usages.set(index, item); return (A)this;
  }
  public A addToUsages(java.lang.String... items) {
    if (this.usages == null) {this.usages = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.usages.add(item);} return (A)this;
  }
  public A addAllToUsages(java.util.Collection<java.lang.String> items) {
    if (this.usages == null) {this.usages = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.usages.add(item);} return (A)this;
  }
  public A removeFromUsages(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.usages!= null){ this.usages.remove(item);}} return (A)this;
  }
  public A removeAllFromUsages(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.usages!= null){ this.usages.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getUsages() {
    return this.usages;
  }
  public java.lang.String getUsage(java.lang.Integer index) {
    return this.usages.get(index);
  }
  public java.lang.String getFirstUsage() {
    return this.usages.get(0);
  }
  public java.lang.String getLastUsage() {
    return this.usages.get(usages.size() - 1);
  }
  public java.lang.String getMatchingUsage(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: usages) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingUsage(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: usages) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withUsages(java.util.List<java.lang.String> usages) {
    if (usages != null) {this.usages = new java.util.ArrayList(); for (java.lang.String item : usages){this.addToUsages(item);}} else { this.usages = null;} return (A) this;
  }
  public A withUsages(java.lang.String... usages) {
    if (this.usages != null) {this.usages.clear();}
    if (usages != null) {for (java.lang.String item :usages){ this.addToUsages(item);}} return (A) this;
  }
  public java.lang.Boolean hasUsages() {
    return usages != null && !usages.isEmpty();
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CertificateSpecFluentImpl that = (CertificateSpecFluentImpl) o;
    if (commonName != null ? !commonName.equals(that.commonName) :that.commonName != null) return false;
    if (dnsNames != null ? !dnsNames.equals(that.dnsNames) :that.dnsNames != null) return false;
    if (duration != null ? !duration.equals(that.duration) :that.duration != null) return false;
    if (emailSANs != null ? !emailSANs.equals(that.emailSANs) :that.emailSANs != null) return false;
    if (encodeUsagesInRequest != null ? !encodeUsagesInRequest.equals(that.encodeUsagesInRequest) :that.encodeUsagesInRequest != null) return false;
    if (ipAddresses != null ? !ipAddresses.equals(that.ipAddresses) :that.ipAddresses != null) return false;
    if (isCA != null ? !isCA.equals(that.isCA) :that.isCA != null) return false;
    if (issuerRef != null ? !issuerRef.equals(that.issuerRef) :that.issuerRef != null) return false;
    if (keystores != null ? !keystores.equals(that.keystores) :that.keystores != null) return false;
    if (privateKey != null ? !privateKey.equals(that.privateKey) :that.privateKey != null) return false;
    if (renewBefore != null ? !renewBefore.equals(that.renewBefore) :that.renewBefore != null) return false;
    if (secretName != null ? !secretName.equals(that.secretName) :that.secretName != null) return false;
    if (subject != null ? !subject.equals(that.subject) :that.subject != null) return false;
    if (uriSANs != null ? !uriSANs.equals(that.uriSANs) :that.uriSANs != null) return false;
    if (usages != null ? !usages.equals(that.usages) :that.usages != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(commonName,  dnsNames,  duration,  emailSANs,  encodeUsagesInRequest,  ipAddresses,  isCA,  issuerRef,  keystores,  privateKey,  renewBefore,  secretName,  subject,  uriSANs,  usages,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (commonName != null) { sb.append("commonName:"); sb.append(commonName + ","); }
    if (dnsNames != null && !dnsNames.isEmpty()) { sb.append("dnsNames:"); sb.append(dnsNames + ","); }
    if (duration != null) { sb.append("duration:"); sb.append(duration + ","); }
    if (emailSANs != null && !emailSANs.isEmpty()) { sb.append("emailSANs:"); sb.append(emailSANs + ","); }
    if (encodeUsagesInRequest != null) { sb.append("encodeUsagesInRequest:"); sb.append(encodeUsagesInRequest + ","); }
    if (ipAddresses != null && !ipAddresses.isEmpty()) { sb.append("ipAddresses:"); sb.append(ipAddresses + ","); }
    if (isCA != null) { sb.append("isCA:"); sb.append(isCA + ","); }
    if (issuerRef != null) { sb.append("issuerRef:"); sb.append(issuerRef + ","); }
    if (keystores != null) { sb.append("keystores:"); sb.append(keystores + ","); }
    if (privateKey != null) { sb.append("privateKey:"); sb.append(privateKey + ","); }
    if (renewBefore != null) { sb.append("renewBefore:"); sb.append(renewBefore + ","); }
    if (secretName != null) { sb.append("secretName:"); sb.append(secretName + ","); }
    if (subject != null) { sb.append("subject:"); sb.append(subject + ","); }
    if (uriSANs != null && !uriSANs.isEmpty()) { sb.append("uriSANs:"); sb.append(uriSANs + ","); }
    if (usages != null && !usages.isEmpty()) { sb.append("usages:"); sb.append(usages); }
    sb.append("}");
    return sb.toString();
  }
  public A withEncodeUsagesInRequest() {
    return withEncodeUsagesInRequest(true);
  }
  public A withIsCA() {
    return withIsCA(true);
  }
  class IssuerRefNestedImpl<N> extends ObjectReferenceFluentImpl<CertificateSpecFluent.IssuerRefNested<N>> implements io.fabric8.certmanager.api.model.v1beta1.CertificateSpecFluent.IssuerRefNested<N>,Nested<N>{
    IssuerRefNestedImpl(io.fabric8.certmanager.api.model.meta.v1.ObjectReference item) {
      this.builder = new io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder(this, item);
    }
    IssuerRefNestedImpl() {
      this.builder = new io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder(this);
    }
    io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder builder;
    public N and() {
      return (N) CertificateSpecFluentImpl.this.withIssuerRef(builder.build());
    }
    public N endIssuerRef() {
      return and();
    }
    
  }
  class KeystoresNestedImpl<N> extends CertificateKeystoresFluentImpl<CertificateSpecFluent.KeystoresNested<N>> implements io.fabric8.certmanager.api.model.v1beta1.CertificateSpecFluent.KeystoresNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    KeystoresNestedImpl(io.fabric8.certmanager.api.model.v1beta1.CertificateKeystores item) {
      this.builder = new CertificateKeystoresBuilder(this, item);
    }
    KeystoresNestedImpl() {
      this.builder = new io.fabric8.certmanager.api.model.v1beta1.CertificateKeystoresBuilder(this);
    }
    io.fabric8.certmanager.api.model.v1beta1.CertificateKeystoresBuilder builder;
    public N and() {
      return (N) CertificateSpecFluentImpl.this.withKeystores(builder.build());
    }
    public N endKeystores() {
      return and();
    }
    
  }
  class PrivateKeyNestedImpl<N> extends CertificatePrivateKeyFluentImpl<CertificateSpecFluent.PrivateKeyNested<N>> implements io.fabric8.certmanager.api.model.v1beta1.CertificateSpecFluent.PrivateKeyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PrivateKeyNestedImpl(CertificatePrivateKey item) {
      this.builder = new CertificatePrivateKeyBuilder(this, item);
    }
    PrivateKeyNestedImpl() {
      this.builder = new io.fabric8.certmanager.api.model.v1beta1.CertificatePrivateKeyBuilder(this);
    }
    io.fabric8.certmanager.api.model.v1beta1.CertificatePrivateKeyBuilder builder;
    public N and() {
      return (N) CertificateSpecFluentImpl.this.withPrivateKey(builder.build());
    }
    public N endPrivateKey() {
      return and();
    }
    
  }
  class SubjectNestedImpl<N> extends X509SubjectFluentImpl<CertificateSpecFluent.SubjectNested<N>> implements io.fabric8.certmanager.api.model.v1beta1.CertificateSpecFluent.SubjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    SubjectNestedImpl(X509Subject item) {
      this.builder = new X509SubjectBuilder(this, item);
    }
    SubjectNestedImpl() {
      this.builder = new io.fabric8.certmanager.api.model.v1beta1.X509SubjectBuilder(this);
    }
    io.fabric8.certmanager.api.model.v1beta1.X509SubjectBuilder builder;
    public N and() {
      return (N) CertificateSpecFluentImpl.this.withSubject(builder.build());
    }
    public N endSubject() {
      return and();
    }
    
  }
  
}