package io.fabric8.certmanager.api.model.acme.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class OrderStatusFluentImpl<A extends OrderStatusFluent<A>> extends BaseFluent<A> implements OrderStatusFluent<A>{
  public OrderStatusFluentImpl() {
  }
  public OrderStatusFluentImpl(io.fabric8.certmanager.api.model.acme.v1beta1.OrderStatus instance) {
    this.withAuthorizations(instance.getAuthorizations()); 
    this.withCertificate(instance.getCertificate()); 
    this.withFailureTime(instance.getFailureTime()); 
    this.withFinalizeURL(instance.getFinalizeURL()); 
    this.withReason(instance.getReason()); 
    this.withState(instance.getState()); 
    this.withUrl(instance.getUrl()); 
  }
  private ArrayList<ACMEAuthorizationBuilder> authorizations = new java.util.ArrayList<ACMEAuthorizationBuilder>();
  private String certificate;
  private java.lang.String failureTime;
  private java.lang.String finalizeURL;
  private java.lang.String reason;
  private java.lang.String state;
  private java.lang.String url;
  public A addToAuthorizations(Integer index,io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorization item) {
    if (this.authorizations == null) {this.authorizations = new java.util.ArrayList<io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorizationBuilder>();}
    io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorizationBuilder builder = new io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorizationBuilder(item);_visitables.get("authorizations").add(index >= 0 ? index : _visitables.get("authorizations").size(), builder);this.authorizations.add(index >= 0 ? index : authorizations.size(), builder); return (A)this;
  }
  public A setToAuthorizations(java.lang.Integer index,io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorization item) {
    if (this.authorizations == null) {this.authorizations = new java.util.ArrayList<io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorizationBuilder>();}
    io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorizationBuilder builder = new io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorizationBuilder(item);
    if (index < 0 || index >= _visitables.get("authorizations").size()) { _visitables.get("authorizations").add(builder); } else { _visitables.get("authorizations").set(index, builder);}
    if (index < 0 || index >= authorizations.size()) { authorizations.add(builder); } else { authorizations.set(index, builder);}
     return (A)this;
  }
  public A addToAuthorizations(io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorization... items) {
    if (this.authorizations == null) {this.authorizations = new java.util.ArrayList<io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorizationBuilder>();}
    for (io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorization item : items) {io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorizationBuilder builder = new io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorizationBuilder(item);_visitables.get("authorizations").add(builder);this.authorizations.add(builder);} return (A)this;
  }
  public A addAllToAuthorizations(Collection<io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorization> items) {
    if (this.authorizations == null) {this.authorizations = new java.util.ArrayList<io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorizationBuilder>();}
    for (io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorization item : items) {io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorizationBuilder builder = new io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorizationBuilder(item);_visitables.get("authorizations").add(builder);this.authorizations.add(builder);} return (A)this;
  }
  public A removeFromAuthorizations(io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorization... items) {
    for (io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorization item : items) {io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorizationBuilder builder = new io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorizationBuilder(item);_visitables.get("authorizations").remove(builder);if (this.authorizations != null) {this.authorizations.remove(builder);}} return (A)this;
  }
  public A removeAllFromAuthorizations(java.util.Collection<io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorization> items) {
    for (io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorization item : items) {io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorizationBuilder builder = new io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorizationBuilder(item);_visitables.get("authorizations").remove(builder);if (this.authorizations != null) {this.authorizations.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAuthorizations(Predicate<io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorizationBuilder> predicate) {
    if (authorizations == null) return (A) this;
    final Iterator<io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorizationBuilder> each = authorizations.iterator();
    final List visitables = _visitables.get("authorizations");
    while (each.hasNext()) {
      io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorizationBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildAuthorizations instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorization> getAuthorizations() {
    return authorizations != null ? build(authorizations) : null;
  }
  public java.util.List<io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorization> buildAuthorizations() {
    return authorizations != null ? build(authorizations) : null;
  }
  public io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorization buildAuthorization(java.lang.Integer index) {
    return this.authorizations.get(index).build();
  }
  public io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorization buildFirstAuthorization() {
    return this.authorizations.get(0).build();
  }
  public io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorization buildLastAuthorization() {
    return this.authorizations.get(authorizations.size() - 1).build();
  }
  public io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorization buildMatchingAuthorization(java.util.function.Predicate<io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorizationBuilder> predicate) {
    for (io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorizationBuilder item: authorizations) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingAuthorization(java.util.function.Predicate<io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorizationBuilder> predicate) {
    for (io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorizationBuilder item: authorizations) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAuthorizations(java.util.List<io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorization> authorizations) {
    if (this.authorizations != null) { _visitables.get("authorizations").removeAll(this.authorizations);}
    if (authorizations != null) {this.authorizations = new java.util.ArrayList(); for (io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorization item : authorizations){this.addToAuthorizations(item);}} else { this.authorizations = null;} return (A) this;
  }
  public A withAuthorizations(io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorization... authorizations) {
    if (this.authorizations != null) {this.authorizations.clear();}
    if (authorizations != null) {for (io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorization item :authorizations){ this.addToAuthorizations(item);}} return (A) this;
  }
  public java.lang.Boolean hasAuthorizations() {
    return authorizations != null && !authorizations.isEmpty();
  }
  public OrderStatusFluent.AuthorizationsNested<A> addNewAuthorization() {
    return new OrderStatusFluentImpl.AuthorizationsNestedImpl();
  }
  public io.fabric8.certmanager.api.model.acme.v1beta1.OrderStatusFluent.AuthorizationsNested<A> addNewAuthorizationLike(io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorization item) {
    return new OrderStatusFluentImpl.AuthorizationsNestedImpl(-1, item);
  }
  public io.fabric8.certmanager.api.model.acme.v1beta1.OrderStatusFluent.AuthorizationsNested<A> setNewAuthorizationLike(java.lang.Integer index,io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorization item) {
    return new io.fabric8.certmanager.api.model.acme.v1beta1.OrderStatusFluentImpl.AuthorizationsNestedImpl(index, item);
  }
  public io.fabric8.certmanager.api.model.acme.v1beta1.OrderStatusFluent.AuthorizationsNested<A> editAuthorization(java.lang.Integer index) {
    if (authorizations.size() <= index) throw new RuntimeException("Can't edit authorizations. Index exceeds size.");
    return setNewAuthorizationLike(index, buildAuthorization(index));
  }
  public io.fabric8.certmanager.api.model.acme.v1beta1.OrderStatusFluent.AuthorizationsNested<A> editFirstAuthorization() {
    if (authorizations.size() == 0) throw new RuntimeException("Can't edit first authorizations. The list is empty.");
    return setNewAuthorizationLike(0, buildAuthorization(0));
  }
  public io.fabric8.certmanager.api.model.acme.v1beta1.OrderStatusFluent.AuthorizationsNested<A> editLastAuthorization() {
    int index = authorizations.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last authorizations. The list is empty.");
    return setNewAuthorizationLike(index, buildAuthorization(index));
  }
  public io.fabric8.certmanager.api.model.acme.v1beta1.OrderStatusFluent.AuthorizationsNested<A> editMatchingAuthorization(java.util.function.Predicate<io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorizationBuilder> predicate) {
    int index = -1;
    for (int i=0;i<authorizations.size();i++) { 
    if (predicate.test(authorizations.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching authorizations. No match found.");
    return setNewAuthorizationLike(index, buildAuthorization(index));
  }
  public java.lang.String getCertificate() {
    return this.certificate;
  }
  public A withCertificate(java.lang.String certificate) {
    this.certificate=certificate; return (A) this;
  }
  public java.lang.Boolean hasCertificate() {
    return this.certificate != null;
  }
  public java.lang.String getFailureTime() {
    return this.failureTime;
  }
  public A withFailureTime(java.lang.String failureTime) {
    this.failureTime=failureTime; return (A) this;
  }
  public java.lang.Boolean hasFailureTime() {
    return this.failureTime != null;
  }
  public java.lang.String getFinalizeURL() {
    return this.finalizeURL;
  }
  public A withFinalizeURL(java.lang.String finalizeURL) {
    this.finalizeURL=finalizeURL; return (A) this;
  }
  public java.lang.Boolean hasFinalizeURL() {
    return this.finalizeURL != null;
  }
  public java.lang.String getReason() {
    return this.reason;
  }
  public A withReason(java.lang.String reason) {
    this.reason=reason; return (A) this;
  }
  public java.lang.Boolean hasReason() {
    return this.reason != null;
  }
  public java.lang.String getState() {
    return this.state;
  }
  public A withState(java.lang.String state) {
    this.state=state; return (A) this;
  }
  public java.lang.Boolean hasState() {
    return this.state != null;
  }
  public java.lang.String getUrl() {
    return this.url;
  }
  public A withUrl(java.lang.String url) {
    this.url=url; return (A) this;
  }
  public java.lang.Boolean hasUrl() {
    return this.url != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderStatusFluentImpl that = (OrderStatusFluentImpl) o;
    if (authorizations != null ? !authorizations.equals(that.authorizations) :that.authorizations != null) return false;
    if (certificate != null ? !certificate.equals(that.certificate) :that.certificate != null) return false;
    if (failureTime != null ? !failureTime.equals(that.failureTime) :that.failureTime != null) return false;
    if (finalizeURL != null ? !finalizeURL.equals(that.finalizeURL) :that.finalizeURL != null) return false;
    if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
    if (state != null ? !state.equals(that.state) :that.state != null) return false;
    if (url != null ? !url.equals(that.url) :that.url != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(authorizations,  certificate,  failureTime,  finalizeURL,  reason,  state,  url,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (authorizations != null && !authorizations.isEmpty()) { sb.append("authorizations:"); sb.append(authorizations + ","); }
    if (certificate != null) { sb.append("certificate:"); sb.append(certificate + ","); }
    if (failureTime != null) { sb.append("failureTime:"); sb.append(failureTime + ","); }
    if (finalizeURL != null) { sb.append("finalizeURL:"); sb.append(finalizeURL + ","); }
    if (reason != null) { sb.append("reason:"); sb.append(reason + ","); }
    if (state != null) { sb.append("state:"); sb.append(state + ","); }
    if (url != null) { sb.append("url:"); sb.append(url); }
    sb.append("}");
    return sb.toString();
  }
  class AuthorizationsNestedImpl<N> extends ACMEAuthorizationFluentImpl<OrderStatusFluent.AuthorizationsNested<N>> implements io.fabric8.certmanager.api.model.acme.v1beta1.OrderStatusFluent.AuthorizationsNested<N>,Nested<N>{
    AuthorizationsNestedImpl(java.lang.Integer index,io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorization item) {
      this.index = index;
      this.builder = new ACMEAuthorizationBuilder(this, item);
    }
    AuthorizationsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorizationBuilder(this);
    }
    io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorizationBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) OrderStatusFluentImpl.this.setToAuthorizations(index,builder.build());
    }
    public N endAuthorization() {
      return and();
    }
    
  }
  
}