package io.fabric8.certmanager.api.model.v1beta1;

import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class CertificateRequestSpecFluentImpl<A extends io.fabric8.certmanager.api.model.v1beta1.CertificateRequestSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.certmanager.api.model.v1beta1.CertificateRequestSpecFluent<A> {

    private io.fabric8.kubernetes.api.model.Duration duration;
    private java.lang.Boolean isCA;
    private io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder issuerRef;
    private java.lang.String request;
    private java.util.List<java.lang.String> usages;

    public CertificateRequestSpecFluentImpl() {
    }

    public CertificateRequestSpecFluentImpl(io.fabric8.certmanager.api.model.v1beta1.CertificateRequestSpec instance) {
        this.withDuration(instance.getDuration()); 
        this.withIsCA(instance.getIsCA()); 
        this.withIssuerRef(instance.getIssuerRef()); 
        this.withRequest(instance.getRequest()); 
        this.withUsages(instance.getUsages()); 
    }

    public io.fabric8.kubernetes.api.model.Duration getDuration() {
        return this.duration;
    }

    public A withDuration(io.fabric8.kubernetes.api.model.Duration duration) {
        this.duration=duration; return (A) this;
    }

    public java.lang.Boolean hasDuration() {
        return this.duration != null;
    }

    public java.lang.Boolean getIsCA() {
        return this.isCA;
    }

    public A withIsCA(java.lang.Boolean isCA) {
        this.isCA=isCA; return (A) this;
    }

    public java.lang.Boolean hasIsCA() {
        return this.isCA != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildIssuerRef instead.
     * @return The buildable object.
     */
        public io.fabric8.certmanager.api.model.meta.v1.ObjectReference getIssuerRef() {
        return this.issuerRef!=null?this.issuerRef.build():null;
    }

    public io.fabric8.certmanager.api.model.meta.v1.ObjectReference buildIssuerRef() {
        return this.issuerRef!=null?this.issuerRef.build():null;
    }

    public A withIssuerRef(io.fabric8.certmanager.api.model.meta.v1.ObjectReference issuerRef) {
        _visitables.get("issuerRef").remove(this.issuerRef);
        if (issuerRef!=null){ this.issuerRef= new io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder(issuerRef); _visitables.get("issuerRef").add(this.issuerRef);} return (A) this;
    }

    public java.lang.Boolean hasIssuerRef() {
        return this.issuerRef != null;
    }

    public A withNewIssuerRef(java.lang.String group,java.lang.String kind,java.lang.String name) {
        return (A)withIssuerRef(new ObjectReference(group, kind, name));
    }

    public io.fabric8.certmanager.api.model.v1beta1.CertificateRequestSpecFluent.IssuerRefNested<A> withNewIssuerRef() {
        return new io.fabric8.certmanager.api.model.v1beta1.CertificateRequestSpecFluentImpl.IssuerRefNestedImpl();
    }

    public io.fabric8.certmanager.api.model.v1beta1.CertificateRequestSpecFluent.IssuerRefNested<A> withNewIssuerRefLike(io.fabric8.certmanager.api.model.meta.v1.ObjectReference item) {
        return new io.fabric8.certmanager.api.model.v1beta1.CertificateRequestSpecFluentImpl.IssuerRefNestedImpl(item);
    }

    public io.fabric8.certmanager.api.model.v1beta1.CertificateRequestSpecFluent.IssuerRefNested<A> editIssuerRef() {
        return withNewIssuerRefLike(getIssuerRef());
    }

    public io.fabric8.certmanager.api.model.v1beta1.CertificateRequestSpecFluent.IssuerRefNested<A> editOrNewIssuerRef() {
        return withNewIssuerRefLike(getIssuerRef() != null ? getIssuerRef(): new io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder().build());
    }

    public io.fabric8.certmanager.api.model.v1beta1.CertificateRequestSpecFluent.IssuerRefNested<A> editOrNewIssuerRefLike(io.fabric8.certmanager.api.model.meta.v1.ObjectReference item) {
        return withNewIssuerRefLike(getIssuerRef() != null ? getIssuerRef(): item);
    }

    public java.lang.String getRequest() {
        return this.request;
    }

    public A withRequest(java.lang.String request) {
        this.request=request; return (A) this;
    }

    public java.lang.Boolean hasRequest() {
        return this.request != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withRequest instead.
     */
        public A withNewRequest(java.lang.String arg0) {
        return (A)withRequest(new String(arg0));
    }

    public A addToUsages(int index,java.lang.String item) {
        if (this.usages == null) {this.usages = new java.util.ArrayList<java.lang.String>();}
        this.usages.add(index, item);
        return (A)this;
    }

    public A setToUsages(int index,java.lang.String item) {
        if (this.usages == null) {this.usages = new java.util.ArrayList<java.lang.String>();}
        this.usages.set(index, item); return (A)this;
    }

    public A addToUsages(java.lang.String... items) {
        if (this.usages == null) {this.usages = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.usages.add(item);} return (A)this;
    }

    public A addAllToUsages(java.util.Collection<java.lang.String> items) {
        if (this.usages == null) {this.usages = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.usages.add(item);} return (A)this;
    }

    public A removeFromUsages(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.usages!= null){ this.usages.remove(item);}} return (A)this;
    }

    public A removeAllFromUsages(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.usages!= null){ this.usages.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getUsages() {
        return this.usages;
    }

    public java.lang.String getUsage(int index) {
        return this.usages.get(index);
    }

    public java.lang.String getFirstUsage() {
        return this.usages.get(0);
    }

    public java.lang.String getLastUsage() {
        return this.usages.get(usages.size() - 1);
    }

    public java.lang.String getMatchingUsage(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: usages) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingUsage(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: usages) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withUsages(java.util.List<java.lang.String> usages) {
        if (this.usages != null) { _visitables.get("usages").removeAll(this.usages);}
        if (usages != null) {this.usages = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : usages){this.addToUsages(item);}} else { this.usages = null;} return (A) this;
    }

    public A withUsages(java.lang.String... usages) {
        if (this.usages != null) {this.usages.clear();}
        if (usages != null) {for (java.lang.String item :usages){ this.addToUsages(item);}} return (A) this;
    }

    public java.lang.Boolean hasUsages() {
        return usages != null && !usages.isEmpty();
    }

    public A addNewUsage(java.lang.String arg0) {
        return (A)addToUsages(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CertificateRequestSpecFluentImpl that = (CertificateRequestSpecFluentImpl) o;
        if (duration != null ? !duration.equals(that.duration) :that.duration != null) return false;
        if (isCA != null ? !isCA.equals(that.isCA) :that.isCA != null) return false;
        if (issuerRef != null ? !issuerRef.equals(that.issuerRef) :that.issuerRef != null) return false;
        if (request != null ? !request.equals(that.request) :that.request != null) return false;
        if (usages != null ? !usages.equals(that.usages) :that.usages != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(duration,  isCA,  issuerRef,  request,  usages,  super.hashCode());
    }

    public class IssuerRefNestedImpl<N> extends io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceFluentImpl<io.fabric8.certmanager.api.model.v1beta1.CertificateRequestSpecFluent.IssuerRefNested<N>> implements io.fabric8.certmanager.api.model.v1beta1.CertificateRequestSpecFluent.IssuerRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder builder;

            IssuerRefNestedImpl(io.fabric8.certmanager.api.model.meta.v1.ObjectReference item) {
                this.builder = new io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder(this, item);
                        
            }

            IssuerRefNestedImpl() {
                this.builder = new io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) CertificateRequestSpecFluentImpl.this.withIssuerRef(builder.build());
            }

            public N endIssuerRef() {
                return and();
            }
    }


}
