/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.acme.v1beta1;

import io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorization;
import io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorizationBuilder;
import io.fabric8.certmanager.api.model.acme.v1beta1.ACMEAuthorizationFluentImpl;
import io.fabric8.certmanager.api.model.acme.v1beta1.OrderStatus;
import io.fabric8.certmanager.api.model.acme.v1beta1.OrderStatusFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class OrderStatusFluentImpl<A extends OrderStatusFluent<A>>
extends BaseFluent<A>
implements OrderStatusFluent<A> {
    private List<ACMEAuthorizationBuilder> authorizations;
    private List<Integer> certificate;
    private String failureTime;
    private String finalizeURL;
    private String reason;
    private String state;
    private String url;

    public OrderStatusFluentImpl() {
    }

    public OrderStatusFluentImpl(OrderStatus instance) {
        this.withAuthorizations(instance.getAuthorizations());
        this.withCertificate(instance.getCertificate());
        this.withFailureTime(instance.getFailureTime());
        this.withFinalizeURL(instance.getFinalizeURL());
        this.withReason(instance.getReason());
        this.withState(instance.getState());
        this.withUrl(instance.getUrl());
    }

    @Override
    public A addToAuthorizations(int index, ACMEAuthorization item) {
        if (this.authorizations == null) {
            this.authorizations = new ArrayList<ACMEAuthorizationBuilder>();
        }
        ACMEAuthorizationBuilder builder = new ACMEAuthorizationBuilder(item);
        this._visitables.get((Object)"authorizations").add(index >= 0 ? index : this._visitables.get((Object)"authorizations").size(), builder);
        this.authorizations.add(index >= 0 ? index : this.authorizations.size(), builder);
        return (A)this;
    }

    @Override
    public A setToAuthorizations(int index, ACMEAuthorization item) {
        if (this.authorizations == null) {
            this.authorizations = new ArrayList<ACMEAuthorizationBuilder>();
        }
        ACMEAuthorizationBuilder builder = new ACMEAuthorizationBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"authorizations").size()) {
            this._visitables.get((Object)"authorizations").add(builder);
        } else {
            this._visitables.get((Object)"authorizations").set(index, builder);
        }
        if (index < 0 || index >= this.authorizations.size()) {
            this.authorizations.add(builder);
        } else {
            this.authorizations.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAuthorizations(ACMEAuthorization ... items) {
        if (this.authorizations == null) {
            this.authorizations = new ArrayList<ACMEAuthorizationBuilder>();
        }
        for (ACMEAuthorization item : items) {
            ACMEAuthorizationBuilder builder = new ACMEAuthorizationBuilder(item);
            this._visitables.get((Object)"authorizations").add(builder);
            this.authorizations.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAuthorizations(Collection<ACMEAuthorization> items) {
        if (this.authorizations == null) {
            this.authorizations = new ArrayList<ACMEAuthorizationBuilder>();
        }
        for (ACMEAuthorization item : items) {
            ACMEAuthorizationBuilder builder = new ACMEAuthorizationBuilder(item);
            this._visitables.get((Object)"authorizations").add(builder);
            this.authorizations.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAuthorizations(ACMEAuthorization ... items) {
        for (ACMEAuthorization item : items) {
            ACMEAuthorizationBuilder builder = new ACMEAuthorizationBuilder(item);
            this._visitables.get((Object)"authorizations").remove(builder);
            if (this.authorizations == null) continue;
            this.authorizations.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAuthorizations(Collection<ACMEAuthorization> items) {
        for (ACMEAuthorization item : items) {
            ACMEAuthorizationBuilder builder = new ACMEAuthorizationBuilder(item);
            this._visitables.get((Object)"authorizations").remove(builder);
            if (this.authorizations == null) continue;
            this.authorizations.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromAuthorizations(Predicate<ACMEAuthorizationBuilder> predicate) {
        if (this.authorizations == null) {
            return (A)this;
        }
        Iterator<ACMEAuthorizationBuilder> each = this.authorizations.iterator();
        List visitables = this._visitables.get((Object)"authorizations");
        while (each.hasNext()) {
            ACMEAuthorizationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ACMEAuthorization> getAuthorizations() {
        return OrderStatusFluentImpl.build(this.authorizations);
    }

    @Override
    public List<ACMEAuthorization> buildAuthorizations() {
        return OrderStatusFluentImpl.build(this.authorizations);
    }

    @Override
    public ACMEAuthorization buildAuthorization(int index) {
        return this.authorizations.get(index).build();
    }

    @Override
    public ACMEAuthorization buildFirstAuthorization() {
        return this.authorizations.get(0).build();
    }

    @Override
    public ACMEAuthorization buildLastAuthorization() {
        return this.authorizations.get(this.authorizations.size() - 1).build();
    }

    @Override
    public ACMEAuthorization buildMatchingAuthorization(Predicate<ACMEAuthorizationBuilder> predicate) {
        for (ACMEAuthorizationBuilder item : this.authorizations) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAuthorization(Predicate<ACMEAuthorizationBuilder> predicate) {
        for (ACMEAuthorizationBuilder item : this.authorizations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAuthorizations(List<ACMEAuthorization> authorizations) {
        if (this.authorizations != null) {
            this._visitables.get((Object)"authorizations").removeAll(this.authorizations);
        }
        if (authorizations != null) {
            this.authorizations = new ArrayList<ACMEAuthorizationBuilder>();
            for (ACMEAuthorization item : authorizations) {
                this.addToAuthorizations(item);
            }
        } else {
            this.authorizations = null;
        }
        return (A)this;
    }

    @Override
    public A withAuthorizations(ACMEAuthorization ... authorizations) {
        if (this.authorizations != null) {
            this.authorizations.clear();
        }
        if (authorizations != null) {
            for (ACMEAuthorization item : authorizations) {
                this.addToAuthorizations(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAuthorizations() {
        return this.authorizations != null && !this.authorizations.isEmpty();
    }

    @Override
    public OrderStatusFluent.AuthorizationsNested<A> addNewAuthorization() {
        return new AuthorizationsNestedImpl();
    }

    @Override
    public OrderStatusFluent.AuthorizationsNested<A> addNewAuthorizationLike(ACMEAuthorization item) {
        return new AuthorizationsNestedImpl(-1, item);
    }

    @Override
    public OrderStatusFluent.AuthorizationsNested<A> setNewAuthorizationLike(int index, ACMEAuthorization item) {
        return new AuthorizationsNestedImpl(index, item);
    }

    @Override
    public OrderStatusFluent.AuthorizationsNested<A> editAuthorization(int index) {
        if (this.authorizations.size() <= index) {
            throw new RuntimeException("Can't edit authorizations. Index exceeds size.");
        }
        return this.setNewAuthorizationLike(index, this.buildAuthorization(index));
    }

    @Override
    public OrderStatusFluent.AuthorizationsNested<A> editFirstAuthorization() {
        if (this.authorizations.size() == 0) {
            throw new RuntimeException("Can't edit first authorizations. The list is empty.");
        }
        return this.setNewAuthorizationLike(0, this.buildAuthorization(0));
    }

    @Override
    public OrderStatusFluent.AuthorizationsNested<A> editLastAuthorization() {
        int index = this.authorizations.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last authorizations. The list is empty.");
        }
        return this.setNewAuthorizationLike(index, this.buildAuthorization(index));
    }

    @Override
    public OrderStatusFluent.AuthorizationsNested<A> editMatchingAuthorization(Predicate<ACMEAuthorizationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.authorizations.size(); ++i) {
            if (!predicate.test(this.authorizations.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching authorizations. No match found.");
        }
        return this.setNewAuthorizationLike(index, this.buildAuthorization(index));
    }

    @Override
    public A addToCertificate(int index, Integer item) {
        if (this.certificate == null) {
            this.certificate = new ArrayList<Integer>();
        }
        this.certificate.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCertificate(int index, Integer item) {
        if (this.certificate == null) {
            this.certificate = new ArrayList<Integer>();
        }
        this.certificate.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCertificate(Integer ... items) {
        if (this.certificate == null) {
            this.certificate = new ArrayList<Integer>();
        }
        for (Integer item : items) {
            this.certificate.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCertificate(Collection<Integer> items) {
        if (this.certificate == null) {
            this.certificate = new ArrayList<Integer>();
        }
        for (Integer item : items) {
            this.certificate.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCertificate(Integer ... items) {
        for (Integer item : items) {
            if (this.certificate == null) continue;
            this.certificate.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCertificate(Collection<Integer> items) {
        for (Integer item : items) {
            if (this.certificate == null) continue;
            this.certificate.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Integer> getCertificate() {
        return this.certificate;
    }

    @Override
    public Integer getCertificate(int index) {
        return this.certificate.get(index);
    }

    @Override
    public Integer getFirstCertificate() {
        return this.certificate.get(0);
    }

    @Override
    public Integer getLastCertificate() {
        return this.certificate.get(this.certificate.size() - 1);
    }

    @Override
    public Integer getMatchingCertificate(Predicate<Integer> predicate) {
        for (Integer item : this.certificate) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCertificate(Predicate<Integer> predicate) {
        for (Integer item : this.certificate) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withCertificate(List<Integer> certificate) {
        if (this.certificate != null) {
            this._visitables.get((Object)"certificate").removeAll(this.certificate);
        }
        if (certificate != null) {
            this.certificate = new ArrayList<Integer>();
            for (Integer item : certificate) {
                this.addToCertificate(item);
            }
        } else {
            this.certificate = null;
        }
        return (A)this;
    }

    @Override
    public A withCertificate(Integer ... certificate) {
        if (this.certificate != null) {
            this.certificate.clear();
        }
        if (certificate != null) {
            for (Integer item : certificate) {
                this.addToCertificate(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCertificate() {
        return this.certificate != null && !this.certificate.isEmpty();
    }

    @Override
    public String getFailureTime() {
        return this.failureTime;
    }

    @Override
    public A withFailureTime(String failureTime) {
        this.failureTime = failureTime;
        return (A)this;
    }

    @Override
    public Boolean hasFailureTime() {
        return this.failureTime != null;
    }

    @Override
    @Deprecated
    public A withNewFailureTime(String arg0) {
        return this.withFailureTime(new String(arg0));
    }

    @Override
    public String getFinalizeURL() {
        return this.finalizeURL;
    }

    @Override
    public A withFinalizeURL(String finalizeURL) {
        this.finalizeURL = finalizeURL;
        return (A)this;
    }

    @Override
    public Boolean hasFinalizeURL() {
        return this.finalizeURL != null;
    }

    @Override
    @Deprecated
    public A withNewFinalizeURL(String arg0) {
        return this.withFinalizeURL(new String(arg0));
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public A withReason(String reason) {
        this.reason = reason;
        return (A)this;
    }

    @Override
    public Boolean hasReason() {
        return this.reason != null;
    }

    @Override
    @Deprecated
    public A withNewReason(String arg0) {
        return this.withReason(new String(arg0));
    }

    @Override
    public String getState() {
        return this.state;
    }

    @Override
    public A withState(String state) {
        this.state = state;
        return (A)this;
    }

    @Override
    public Boolean hasState() {
        return this.state != null;
    }

    @Override
    @Deprecated
    public A withNewState(String arg0) {
        return this.withState(new String(arg0));
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public A withUrl(String url) {
        this.url = url;
        return (A)this;
    }

    @Override
    public Boolean hasUrl() {
        return this.url != null;
    }

    @Override
    @Deprecated
    public A withNewUrl(String arg0) {
        return this.withUrl(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderStatusFluentImpl that = (OrderStatusFluentImpl)o;
        if (this.authorizations != null ? !this.authorizations.equals(that.authorizations) : that.authorizations != null) {
            return false;
        }
        if (this.certificate != null ? !this.certificate.equals(that.certificate) : that.certificate != null) {
            return false;
        }
        if (this.failureTime != null ? !this.failureTime.equals(that.failureTime) : that.failureTime != null) {
            return false;
        }
        if (this.finalizeURL != null ? !this.finalizeURL.equals(that.finalizeURL) : that.finalizeURL != null) {
            return false;
        }
        if (this.reason != null ? !this.reason.equals(that.reason) : that.reason != null) {
            return false;
        }
        if (this.state != null ? !this.state.equals(that.state) : that.state != null) {
            return false;
        }
        return !(this.url != null ? !this.url.equals(that.url) : that.url != null);
    }

    public int hashCode() {
        return Objects.hash(this.authorizations, this.certificate, this.failureTime, this.finalizeURL, this.reason, this.state, this.url, super.hashCode());
    }

    public class AuthorizationsNestedImpl<N>
    extends ACMEAuthorizationFluentImpl<OrderStatusFluent.AuthorizationsNested<N>>
    implements OrderStatusFluent.AuthorizationsNested<N>,
    Nested<N> {
        private final ACMEAuthorizationBuilder builder;
        private final int index;

        AuthorizationsNestedImpl(int index, ACMEAuthorization item) {
            this.index = index;
            this.builder = new ACMEAuthorizationBuilder(this, item);
        }

        AuthorizationsNestedImpl() {
            this.index = -1;
            this.builder = new ACMEAuthorizationBuilder(this);
        }

        @Override
        public N and() {
            return (N)OrderStatusFluentImpl.this.setToAuthorizations(this.index, this.builder.build());
        }

        @Override
        public N endAuthorization() {
            return this.and();
        }
    }
}

