package io.fabric8.certmanager.api.model.acme.v1beta1;

import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class OrderSpecFluentImpl<A extends io.fabric8.certmanager.api.model.acme.v1beta1.OrderSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.certmanager.api.model.acme.v1beta1.OrderSpecFluent<A> {

    private java.lang.String commonName;
    private java.util.List<java.lang.String> dnsNames;
    private io.fabric8.kubernetes.api.model.Duration duration;
    private java.util.List<java.lang.String> ipAddresses;
    private io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder issuerRef;
    private java.util.List<java.lang.Integer> request;

    public OrderSpecFluentImpl() {
    }

    public OrderSpecFluentImpl(io.fabric8.certmanager.api.model.acme.v1beta1.OrderSpec instance) {
        this.withCommonName(instance.getCommonName()); 
        this.withDnsNames(instance.getDnsNames()); 
        this.withDuration(instance.getDuration()); 
        this.withIpAddresses(instance.getIpAddresses()); 
        this.withIssuerRef(instance.getIssuerRef()); 
        this.withRequest(instance.getRequest()); 
    }

    public java.lang.String getCommonName() {
        return this.commonName;
    }

    public A withCommonName(java.lang.String commonName) {
        this.commonName=commonName; return (A) this;
    }

    public java.lang.Boolean hasCommonName() {
        return this.commonName != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withCommonName instead.
     */
        public A withNewCommonName(java.lang.String arg0) {
        return (A)withCommonName(new String(arg0));
    }

    public A addToDnsNames(int index,java.lang.String item) {
        if (this.dnsNames == null) {this.dnsNames = new java.util.ArrayList<java.lang.String>();}
        this.dnsNames.add(index, item);
        return (A)this;
    }

    public A setToDnsNames(int index,java.lang.String item) {
        if (this.dnsNames == null) {this.dnsNames = new java.util.ArrayList<java.lang.String>();}
        this.dnsNames.set(index, item); return (A)this;
    }

    public A addToDnsNames(java.lang.String... items) {
        if (this.dnsNames == null) {this.dnsNames = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.dnsNames.add(item);} return (A)this;
    }

    public A addAllToDnsNames(java.util.Collection<java.lang.String> items) {
        if (this.dnsNames == null) {this.dnsNames = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.dnsNames.add(item);} return (A)this;
    }

    public A removeFromDnsNames(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.dnsNames!= null){ this.dnsNames.remove(item);}} return (A)this;
    }

    public A removeAllFromDnsNames(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.dnsNames!= null){ this.dnsNames.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getDnsNames() {
        return this.dnsNames;
    }

    public java.lang.String getDnsName(int index) {
        return this.dnsNames.get(index);
    }

    public java.lang.String getFirstDnsName() {
        return this.dnsNames.get(0);
    }

    public java.lang.String getLastDnsName() {
        return this.dnsNames.get(dnsNames.size() - 1);
    }

    public java.lang.String getMatchingDnsName(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: dnsNames) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingDnsName(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: dnsNames) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withDnsNames(java.util.List<java.lang.String> dnsNames) {
        if (this.dnsNames != null) { _visitables.get("dnsNames").removeAll(this.dnsNames);}
        if (dnsNames != null) {this.dnsNames = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : dnsNames){this.addToDnsNames(item);}} else { this.dnsNames = null;} return (A) this;
    }

    public A withDnsNames(java.lang.String... dnsNames) {
        if (this.dnsNames != null) {this.dnsNames.clear();}
        if (dnsNames != null) {for (java.lang.String item :dnsNames){ this.addToDnsNames(item);}} return (A) this;
    }

    public java.lang.Boolean hasDnsNames() {
        return dnsNames != null && !dnsNames.isEmpty();
    }

    public A addNewDnsName(java.lang.String arg0) {
        return (A)addToDnsNames(new String(arg0));
    }

    public io.fabric8.kubernetes.api.model.Duration getDuration() {
        return this.duration;
    }

    public A withDuration(io.fabric8.kubernetes.api.model.Duration duration) {
        this.duration=duration; return (A) this;
    }

    public java.lang.Boolean hasDuration() {
        return this.duration != null;
    }

    public A addToIpAddresses(int index,java.lang.String item) {
        if (this.ipAddresses == null) {this.ipAddresses = new java.util.ArrayList<java.lang.String>();}
        this.ipAddresses.add(index, item);
        return (A)this;
    }

    public A setToIpAddresses(int index,java.lang.String item) {
        if (this.ipAddresses == null) {this.ipAddresses = new java.util.ArrayList<java.lang.String>();}
        this.ipAddresses.set(index, item); return (A)this;
    }

    public A addToIpAddresses(java.lang.String... items) {
        if (this.ipAddresses == null) {this.ipAddresses = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.ipAddresses.add(item);} return (A)this;
    }

    public A addAllToIpAddresses(java.util.Collection<java.lang.String> items) {
        if (this.ipAddresses == null) {this.ipAddresses = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.ipAddresses.add(item);} return (A)this;
    }

    public A removeFromIpAddresses(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.ipAddresses!= null){ this.ipAddresses.remove(item);}} return (A)this;
    }

    public A removeAllFromIpAddresses(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.ipAddresses!= null){ this.ipAddresses.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getIpAddresses() {
        return this.ipAddresses;
    }

    public java.lang.String getIpAddress(int index) {
        return this.ipAddresses.get(index);
    }

    public java.lang.String getFirstIpAddress() {
        return this.ipAddresses.get(0);
    }

    public java.lang.String getLastIpAddress() {
        return this.ipAddresses.get(ipAddresses.size() - 1);
    }

    public java.lang.String getMatchingIpAddress(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: ipAddresses) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingIpAddress(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: ipAddresses) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withIpAddresses(java.util.List<java.lang.String> ipAddresses) {
        if (this.ipAddresses != null) { _visitables.get("ipAddresses").removeAll(this.ipAddresses);}
        if (ipAddresses != null) {this.ipAddresses = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : ipAddresses){this.addToIpAddresses(item);}} else { this.ipAddresses = null;} return (A) this;
    }

    public A withIpAddresses(java.lang.String... ipAddresses) {
        if (this.ipAddresses != null) {this.ipAddresses.clear();}
        if (ipAddresses != null) {for (java.lang.String item :ipAddresses){ this.addToIpAddresses(item);}} return (A) this;
    }

    public java.lang.Boolean hasIpAddresses() {
        return ipAddresses != null && !ipAddresses.isEmpty();
    }

    public A addNewIpAddress(java.lang.String arg0) {
        return (A)addToIpAddresses(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildIssuerRef instead.
     * @return The buildable object.
     */
        public io.fabric8.certmanager.api.model.meta.v1.ObjectReference getIssuerRef() {
        return this.issuerRef!=null?this.issuerRef.build():null;
    }

    public io.fabric8.certmanager.api.model.meta.v1.ObjectReference buildIssuerRef() {
        return this.issuerRef!=null?this.issuerRef.build():null;
    }

    public A withIssuerRef(io.fabric8.certmanager.api.model.meta.v1.ObjectReference issuerRef) {
        _visitables.get("issuerRef").remove(this.issuerRef);
        if (issuerRef!=null){ this.issuerRef= new io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder(issuerRef); _visitables.get("issuerRef").add(this.issuerRef);} return (A) this;
    }

    public java.lang.Boolean hasIssuerRef() {
        return this.issuerRef != null;
    }

    public A withNewIssuerRef(java.lang.String group,java.lang.String kind,java.lang.String name) {
        return (A)withIssuerRef(new ObjectReference(group, kind, name));
    }

    public io.fabric8.certmanager.api.model.acme.v1beta1.OrderSpecFluent.IssuerRefNested<A> withNewIssuerRef() {
        return new io.fabric8.certmanager.api.model.acme.v1beta1.OrderSpecFluentImpl.IssuerRefNestedImpl();
    }

    public io.fabric8.certmanager.api.model.acme.v1beta1.OrderSpecFluent.IssuerRefNested<A> withNewIssuerRefLike(io.fabric8.certmanager.api.model.meta.v1.ObjectReference item) {
        return new io.fabric8.certmanager.api.model.acme.v1beta1.OrderSpecFluentImpl.IssuerRefNestedImpl(item);
    }

    public io.fabric8.certmanager.api.model.acme.v1beta1.OrderSpecFluent.IssuerRefNested<A> editIssuerRef() {
        return withNewIssuerRefLike(getIssuerRef());
    }

    public io.fabric8.certmanager.api.model.acme.v1beta1.OrderSpecFluent.IssuerRefNested<A> editOrNewIssuerRef() {
        return withNewIssuerRefLike(getIssuerRef() != null ? getIssuerRef(): new io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder().build());
    }

    public io.fabric8.certmanager.api.model.acme.v1beta1.OrderSpecFluent.IssuerRefNested<A> editOrNewIssuerRefLike(io.fabric8.certmanager.api.model.meta.v1.ObjectReference item) {
        return withNewIssuerRefLike(getIssuerRef() != null ? getIssuerRef(): item);
    }

    public A addToRequest(int index,java.lang.Integer item) {
        if (this.request == null) {this.request = new java.util.ArrayList<java.lang.Integer>();}
        this.request.add(index, item);
        return (A)this;
    }

    public A setToRequest(int index,java.lang.Integer item) {
        if (this.request == null) {this.request = new java.util.ArrayList<java.lang.Integer>();}
        this.request.set(index, item); return (A)this;
    }

    public A addToRequest(java.lang.Integer... items) {
        if (this.request == null) {this.request = new java.util.ArrayList<java.lang.Integer>();}
        for (java.lang.Integer item : items) {this.request.add(item);} return (A)this;
    }

    public A addAllToRequest(java.util.Collection<java.lang.Integer> items) {
        if (this.request == null) {this.request = new java.util.ArrayList<java.lang.Integer>();}
        for (java.lang.Integer item : items) {this.request.add(item);} return (A)this;
    }

    public A removeFromRequest(java.lang.Integer... items) {
        for (java.lang.Integer item : items) {if (this.request!= null){ this.request.remove(item);}} return (A)this;
    }

    public A removeAllFromRequest(java.util.Collection<java.lang.Integer> items) {
        for (java.lang.Integer item : items) {if (this.request!= null){ this.request.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.Integer> getRequest() {
        return this.request;
    }

    public java.lang.Integer getRequest(int index) {
        return this.request.get(index);
    }

    public java.lang.Integer getFirstRequest() {
        return this.request.get(0);
    }

    public java.lang.Integer getLastRequest() {
        return this.request.get(request.size() - 1);
    }

    public java.lang.Integer getMatchingRequest(java.util.function.Predicate<java.lang.Integer> predicate) {
        for (java.lang.Integer item: request) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingRequest(java.util.function.Predicate<java.lang.Integer> predicate) {
        for (java.lang.Integer item: request) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withRequest(java.util.List<java.lang.Integer> request) {
        if (this.request != null) { _visitables.get("request").removeAll(this.request);}
        if (request != null) {this.request = new java.util.ArrayList<java.lang.Integer>(); for (java.lang.Integer item : request){this.addToRequest(item);}} else { this.request = null;} return (A) this;
    }

    public A withRequest(java.lang.Integer... request) {
        if (this.request != null) {this.request.clear();}
        if (request != null) {for (java.lang.Integer item :request){ this.addToRequest(item);}} return (A) this;
    }

    public java.lang.Boolean hasRequest() {
        return request != null && !request.isEmpty();
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OrderSpecFluentImpl that = (OrderSpecFluentImpl) o;
        if (commonName != null ? !commonName.equals(that.commonName) :that.commonName != null) return false;
        if (dnsNames != null ? !dnsNames.equals(that.dnsNames) :that.dnsNames != null) return false;
        if (duration != null ? !duration.equals(that.duration) :that.duration != null) return false;
        if (ipAddresses != null ? !ipAddresses.equals(that.ipAddresses) :that.ipAddresses != null) return false;
        if (issuerRef != null ? !issuerRef.equals(that.issuerRef) :that.issuerRef != null) return false;
        if (request != null ? !request.equals(that.request) :that.request != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(commonName,  dnsNames,  duration,  ipAddresses,  issuerRef,  request,  super.hashCode());
    }

    public class IssuerRefNestedImpl<N> extends io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceFluentImpl<io.fabric8.certmanager.api.model.acme.v1beta1.OrderSpecFluent.IssuerRefNested<N>> implements io.fabric8.certmanager.api.model.acme.v1beta1.OrderSpecFluent.IssuerRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder builder;

            IssuerRefNestedImpl(io.fabric8.certmanager.api.model.meta.v1.ObjectReference item) {
                this.builder = new io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder(this, item);
                        
            }

            IssuerRefNestedImpl() {
                this.builder = new io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) OrderSpecFluentImpl.this.withIssuerRef(builder.build());
            }

            public N endIssuerRef() {
                return and();
            }
    }


}
