package io.fabric8.certmanager.api.model.acme.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ACMEIssuerBuilder extends io.fabric8.certmanager.api.model.acme.v1beta1.ACMEIssuerFluentImpl<io.fabric8.certmanager.api.model.acme.v1beta1.ACMEIssuerBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.certmanager.api.model.acme.v1beta1.ACMEIssuer,io.fabric8.certmanager.api.model.acme.v1beta1.ACMEIssuerBuilder> {

    io.fabric8.certmanager.api.model.acme.v1beta1.ACMEIssuerFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ACMEIssuerBuilder() {
        this(true);
    }

    public ACMEIssuerBuilder(java.lang.Boolean validationEnabled) {
        this(new ACMEIssuer(), validationEnabled);
    }

    public ACMEIssuerBuilder(io.fabric8.certmanager.api.model.acme.v1beta1.ACMEIssuerFluent<?> fluent) {
        this(fluent, true);
    }

    public ACMEIssuerBuilder(io.fabric8.certmanager.api.model.acme.v1beta1.ACMEIssuerFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ACMEIssuer(), validationEnabled);
    }

    public ACMEIssuerBuilder(io.fabric8.certmanager.api.model.acme.v1beta1.ACMEIssuerFluent<?> fluent,io.fabric8.certmanager.api.model.acme.v1beta1.ACMEIssuer instance) {
        this(fluent, instance, true);
    }

    public ACMEIssuerBuilder(io.fabric8.certmanager.api.model.acme.v1beta1.ACMEIssuerFluent<?> fluent,io.fabric8.certmanager.api.model.acme.v1beta1.ACMEIssuer instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDisableAccountKeyGeneration(instance.getDisableAccountKeyGeneration()); 
        fluent.withEmail(instance.getEmail()); 
        fluent.withEnableDurationFeature(instance.getEnableDurationFeature()); 
        fluent.withExternalAccountBinding(instance.getExternalAccountBinding()); 
        fluent.withPreferredChain(instance.getPreferredChain()); 
        fluent.withPrivateKeySecretRef(instance.getPrivateKeySecretRef()); 
        fluent.withServer(instance.getServer()); 
        fluent.withSkipTLSVerify(instance.getSkipTLSVerify()); 
        fluent.withSolvers(instance.getSolvers()); 
        this.validationEnabled = validationEnabled; 
    }

    public ACMEIssuerBuilder(io.fabric8.certmanager.api.model.acme.v1beta1.ACMEIssuer instance) {
        this(instance,true);
    }

    public ACMEIssuerBuilder(io.fabric8.certmanager.api.model.acme.v1beta1.ACMEIssuer instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withDisableAccountKeyGeneration(instance.getDisableAccountKeyGeneration()); 
        this.withEmail(instance.getEmail()); 
        this.withEnableDurationFeature(instance.getEnableDurationFeature()); 
        this.withExternalAccountBinding(instance.getExternalAccountBinding()); 
        this.withPreferredChain(instance.getPreferredChain()); 
        this.withPrivateKeySecretRef(instance.getPrivateKeySecretRef()); 
        this.withServer(instance.getServer()); 
        this.withSkipTLSVerify(instance.getSkipTLSVerify()); 
        this.withSolvers(instance.getSolvers()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.certmanager.api.model.acme.v1beta1.EditableACMEIssuer build() {
        EditableACMEIssuer buildable = new EditableACMEIssuer(fluent.getDisableAccountKeyGeneration(),fluent.getEmail(),fluent.getEnableDurationFeature(),fluent.getExternalAccountBinding(),fluent.getPreferredChain(),fluent.getPrivateKeySecretRef(),fluent.getServer(),fluent.getSkipTLSVerify(),fluent.getSolvers());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ACMEIssuerBuilder that = (ACMEIssuerBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
