package io.fabric8.certmanager.api.model.v1alpha3;

import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluent;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Object;
import java.lang.String;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class VenafiCloudFluent<A extends VenafiCloudFluent<A>> extends BaseFluent<A>{
  public VenafiCloudFluent() {
  }
  
  public VenafiCloudFluent(VenafiCloud instance) {
    this.copyInstance(instance);
  }
  private SecretKeySelectorBuilder apiTokenSecretRef;
  private String url;
  
  protected void copyInstance(VenafiCloud instance) {
    instance = (instance != null ? instance : new VenafiCloud());
  
    if (instance != null) {
        this.withApiTokenSecretRef(instance.getApiTokenSecretRef());
        this.withUrl(instance.getUrl());
        this.withApiTokenSecretRef(instance.getApiTokenSecretRef());
        this.withUrl(instance.getUrl());
      }
  }
  
  public SecretKeySelector buildApiTokenSecretRef() {
    return this.apiTokenSecretRef!=null ?this.apiTokenSecretRef.build():null;
  }
  
  public A withApiTokenSecretRef(SecretKeySelector apiTokenSecretRef) {
    _visitables.get("apiTokenSecretRef").remove(this.apiTokenSecretRef);
    if (apiTokenSecretRef!=null){ this.apiTokenSecretRef= new SecretKeySelectorBuilder(apiTokenSecretRef); _visitables.get("apiTokenSecretRef").add(this.apiTokenSecretRef);} else { this.apiTokenSecretRef = null; _visitables.get("apiTokenSecretRef").remove(this.apiTokenSecretRef); } return (A) this;
  }
  
  public boolean hasApiTokenSecretRef() {
    return this.apiTokenSecretRef != null;
  }
  
  public A withNewApiTokenSecretRef(String key,String name) {
    return (A)withApiTokenSecretRef(new SecretKeySelector(key, name));
  }
  
  public ApiTokenSecretRefNested<A> withNewApiTokenSecretRef() {
    return new ApiTokenSecretRefNested(null);
  }
  
  public ApiTokenSecretRefNested<A> withNewApiTokenSecretRefLike(SecretKeySelector item) {
    return new ApiTokenSecretRefNested(item);
  }
  
  public ApiTokenSecretRefNested<A> editApiTokenSecretRef() {
    return withNewApiTokenSecretRefLike(java.util.Optional.ofNullable(buildApiTokenSecretRef()).orElse(null));
  }
  
  public ApiTokenSecretRefNested<A> editOrNewApiTokenSecretRef() {
    return withNewApiTokenSecretRefLike(java.util.Optional.ofNullable(buildApiTokenSecretRef()).orElse(new SecretKeySelectorBuilder().build()));
  }
  
  public ApiTokenSecretRefNested<A> editOrNewApiTokenSecretRefLike(SecretKeySelector item) {
    return withNewApiTokenSecretRefLike(java.util.Optional.ofNullable(buildApiTokenSecretRef()).orElse(item));
  }
  
  public String getUrl() {
    return this.url;
  }
  
  public A withUrl(String url) {
    this.url=url; return (A) this;
  }
  
  public boolean hasUrl() {
    return this.url != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    VenafiCloudFluent that = (VenafiCloudFluent) o;
    if (!java.util.Objects.equals(apiTokenSecretRef, that.apiTokenSecretRef)) return false;
  
    if (!java.util.Objects.equals(url, that.url)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiTokenSecretRef,  url,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiTokenSecretRef != null) { sb.append("apiTokenSecretRef:"); sb.append(apiTokenSecretRef + ","); }
    if (url != null) { sb.append("url:"); sb.append(url); }
    sb.append("}");
    return sb.toString();
  }
  public class ApiTokenSecretRefNested<N> extends SecretKeySelectorFluent<ApiTokenSecretRefNested<N>> implements Nested<N>{
    ApiTokenSecretRefNested(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    SecretKeySelectorBuilder builder;
    
    public N and() {
      return (N) VenafiCloudFluent.this.withApiTokenSecretRef(builder.build());
    }
    
    public N endApiTokenSecretRef() {
      return and();
    }
    
  
  }

}