package io.fabric8.certmanager.api.model.v1alpha3;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.function.Predicate;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SelfSignedIssuerFluent<A extends SelfSignedIssuerFluent<A>> extends BaseFluent<A>{
  public SelfSignedIssuerFluent() {
  }
  
  public SelfSignedIssuerFluent(SelfSignedIssuer instance) {
    this.copyInstance(instance);
  }
  private List<String> crlDistributionPoints = new ArrayList<String>();
  
  protected void copyInstance(SelfSignedIssuer instance) {
    instance = (instance != null ? instance : new SelfSignedIssuer());
  
    if (instance != null) {
        this.withCrlDistributionPoints(instance.getCrlDistributionPoints());
        this.withCrlDistributionPoints(instance.getCrlDistributionPoints());
      }
  }
  
  public A addToCrlDistributionPoints(int index,String item) {
    if (this.crlDistributionPoints == null) {this.crlDistributionPoints = new ArrayList<String>();}
    this.crlDistributionPoints.add(index, item);
    return (A)this;
  }
  
  public A setToCrlDistributionPoints(int index,String item) {
    if (this.crlDistributionPoints == null) {this.crlDistributionPoints = new ArrayList<String>();}
    this.crlDistributionPoints.set(index, item); return (A)this;
  }
  
  public A addToCrlDistributionPoints(java.lang.String... items) {
    if (this.crlDistributionPoints == null) {this.crlDistributionPoints = new ArrayList<String>();}
    for (String item : items) {this.crlDistributionPoints.add(item);} return (A)this;
  }
  
  public A addAllToCrlDistributionPoints(Collection<String> items) {
    if (this.crlDistributionPoints == null) {this.crlDistributionPoints = new ArrayList<String>();}
    for (String item : items) {this.crlDistributionPoints.add(item);} return (A)this;
  }
  
  public A removeFromCrlDistributionPoints(java.lang.String... items) {
    if (this.crlDistributionPoints == null) return (A)this;
    for (String item : items) { this.crlDistributionPoints.remove(item);} return (A)this;
  }
  
  public A removeAllFromCrlDistributionPoints(Collection<String> items) {
    if (this.crlDistributionPoints == null) return (A)this;
    for (String item : items) { this.crlDistributionPoints.remove(item);} return (A)this;
  }
  
  public List<String> getCrlDistributionPoints() {
    return this.crlDistributionPoints;
  }
  
  public String getCrlDistributionPoint(int index) {
    return this.crlDistributionPoints.get(index);
  }
  
  public String getFirstCrlDistributionPoint() {
    return this.crlDistributionPoints.get(0);
  }
  
  public String getLastCrlDistributionPoint() {
    return this.crlDistributionPoints.get(crlDistributionPoints.size() - 1);
  }
  
  public String getMatchingCrlDistributionPoint(Predicate<String> predicate) {
    for (String item: crlDistributionPoints) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingCrlDistributionPoint(Predicate<String> predicate) {
    for (String item: crlDistributionPoints) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withCrlDistributionPoints(List<String> crlDistributionPoints) {
    if (crlDistributionPoints != null) {this.crlDistributionPoints = new ArrayList(); for (String item : crlDistributionPoints){this.addToCrlDistributionPoints(item);}} else { this.crlDistributionPoints = null;} return (A) this;
  }
  
  public A withCrlDistributionPoints(java.lang.String... crlDistributionPoints) {
    if (this.crlDistributionPoints != null) {this.crlDistributionPoints.clear(); _visitables.remove("crlDistributionPoints"); }
    if (crlDistributionPoints != null) {for (String item :crlDistributionPoints){ this.addToCrlDistributionPoints(item);}} return (A) this;
  }
  
  public boolean hasCrlDistributionPoints() {
    return crlDistributionPoints != null && !crlDistributionPoints.isEmpty();
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SelfSignedIssuerFluent that = (SelfSignedIssuerFluent) o;
    if (!java.util.Objects.equals(crlDistributionPoints, that.crlDistributionPoints)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(crlDistributionPoints,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (crlDistributionPoints != null && !crlDistributionPoints.isEmpty()) { sb.append("crlDistributionPoints:"); sb.append(crlDistributionPoints); }
    sb.append("}");
    return sb.toString();
  }
  

}