package io.fabric8.certmanager.api.model.meta.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class SecretKeySelectorBuilder extends SecretKeySelectorFluent<SecretKeySelectorBuilder> implements VisitableBuilder<SecretKeySelector,SecretKeySelectorBuilder>{
  public SecretKeySelectorBuilder() {
    this(new SecretKeySelector());
  }
  
  public SecretKeySelectorBuilder(SecretKeySelectorFluent<?> fluent) {
    this(fluent, new SecretKeySelector());
  }
  
  public SecretKeySelectorBuilder(SecretKeySelectorFluent<?> fluent,SecretKeySelector instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public SecretKeySelectorBuilder(SecretKeySelector instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  SecretKeySelectorFluent<?> fluent;
  
  public SecretKeySelector build() {
    SecretKeySelector buildable = new SecretKeySelector(fluent.getKey(),fluent.getName());
    return buildable;
  }
  

}