package io.fabric8.certmanager.api.model.acme.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class OrderListFluent<A extends OrderListFluent<A>> extends BaseFluent<A>{
  public OrderListFluent() {
  }
  
  public OrderListFluent(OrderList instance) {
    this.copyInstance(instance);
  }
  private String apiVersion;
  private ArrayList<OrderBuilder> items = new ArrayList<OrderBuilder>();
  private String kind;
  private ListMeta metadata;
  
  protected void copyInstance(OrderList instance) {
    instance = (instance != null ? instance : new OrderList());
  
    if (instance != null) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
      }
  }
  
  public String getApiVersion() {
    return this.apiVersion;
  }
  
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  public A addToItems(int index,Order item) {
    if (this.items == null) {this.items = new ArrayList<OrderBuilder>();}
    OrderBuilder builder = new OrderBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").add(index, builder); items.add(index, builder);}
    return (A)this;
  }
  
  public A setToItems(int index,Order item) {
    if (this.items == null) {this.items = new ArrayList<OrderBuilder>();}
    OrderBuilder builder = new OrderBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").set(index, builder); items.set(index, builder);}
    return (A)this;
  }
  
  public A addToItems(io.fabric8.certmanager.api.model.acme.v1alpha3.Order... items) {
    if (this.items == null) {this.items = new ArrayList<OrderBuilder>();}
    for (Order item : items) {OrderBuilder builder = new OrderBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  
  public A addAllToItems(Collection<Order> items) {
    if (this.items == null) {this.items = new ArrayList<OrderBuilder>();}
    for (Order item : items) {OrderBuilder builder = new OrderBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  
  public A removeFromItems(io.fabric8.certmanager.api.model.acme.v1alpha3.Order... items) {
    if (this.items == null) return (A)this;
    for (Order item : items) {OrderBuilder builder = new OrderBuilder(item);_visitables.get("items").remove(builder); this.items.remove(builder);} return (A)this;
  }
  
  public A removeAllFromItems(Collection<Order> items) {
    if (this.items == null) return (A)this;
    for (Order item : items) {OrderBuilder builder = new OrderBuilder(item);_visitables.get("items").remove(builder); this.items.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromItems(Predicate<OrderBuilder> predicate) {
    if (items == null) return (A) this;
    final Iterator<OrderBuilder> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      OrderBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Order> buildItems() {
    return items != null ? build(items) : null;
  }
  
  public Order buildItem(int index) {
    return this.items.get(index).build();
  }
  
  public Order buildFirstItem() {
    return this.items.get(0).build();
  }
  
  public Order buildLastItem() {
    return this.items.get(items.size() - 1).build();
  }
  
  public Order buildMatchingItem(Predicate<OrderBuilder> predicate) {
    for (OrderBuilder item: items) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingItem(Predicate<OrderBuilder> predicate) {
    for (OrderBuilder item: items) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withItems(List<Order> items) {
    if (this.items != null) { _visitables.get("items").clear();}
    if (items != null) {this.items = new ArrayList(); for (Order item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
  }
  
  public A withItems(io.fabric8.certmanager.api.model.acme.v1alpha3.Order... items) {
    if (this.items != null) {this.items.clear(); _visitables.remove("items"); }
    if (items != null) {for (Order item :items){ this.addToItems(item);}} return (A) this;
  }
  
  public boolean hasItems() {
    return items != null && !items.isEmpty();
  }
  
  public ItemsNested<A> addNewItem() {
    return new ItemsNested(-1, null);
  }
  
  public ItemsNested<A> addNewItemLike(Order item) {
    return new ItemsNested(-1, item);
  }
  
  public ItemsNested<A> setNewItemLike(int index,Order item) {
    return new ItemsNested(index, item);
  }
  
  public ItemsNested<A> editItem(int index) {
    if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
    return setNewItemLike(index, buildItem(index));
  }
  
  public ItemsNested<A> editFirstItem() {
    if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
    return setNewItemLike(0, buildItem(0));
  }
  
  public ItemsNested<A> editLastItem() {
    int index = items.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
    return setNewItemLike(index, buildItem(index));
  }
  
  public ItemsNested<A> editMatchingItem(Predicate<OrderBuilder> predicate) {
    int index = -1;
    for (int i=0;i<items.size();i++) { 
    if (predicate.test(items.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
    return setNewItemLike(index, buildItem(index));
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public ListMeta getMetadata() {
    return this.metadata;
  }
  
  public A withMetadata(ListMeta metadata) {
    this.metadata=metadata; return (A) this;
  }
  
  public boolean hasMetadata() {
    return this.metadata != null;
  }
  
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink) {
    return (A)withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OrderListFluent that = (OrderListFluent) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;
  
    if (!java.util.Objects.equals(items, that.items)) return false;
  
    if (!java.util.Objects.equals(kind, that.kind)) return false;
  
    if (!java.util.Objects.equals(metadata, that.metadata)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  items,  kind,  metadata,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (items != null && !items.isEmpty()) { sb.append("items:"); sb.append(items + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata); }
    sb.append("}");
    return sb.toString();
  }
  public class ItemsNested<N> extends OrderFluent<ItemsNested<N>> implements Nested<N>{
    ItemsNested(int index,Order item) {
      this.index = index;
      this.builder = new OrderBuilder(this, item);
    }
    OrderBuilder builder;
    int index;
    
    public N and() {
      return (N) OrderListFluent.this.setToItems(index,builder.build());
    }
    
    public N endItem() {
      return and();
    }
    
  
  }

}