package io.fabric8.certmanager.api.model.acme.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class OrderBuilder extends OrderFluent<OrderBuilder> implements VisitableBuilder<Order,OrderBuilder>{
  public OrderBuilder() {
    this(new Order());
  }
  
  public OrderBuilder(OrderFluent<?> fluent) {
    this(fluent, new Order());
  }
  
  public OrderBuilder(OrderFluent<?> fluent,Order instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public OrderBuilder(Order instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  OrderFluent<?> fluent;
  
  public Order build() {
    Order buildable = new Order(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  

}