package io.fabric8.certmanager.api.model.acme.v1alpha3;

import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluent;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Object;
import java.lang.String;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ACMEIssuerDNS01ProviderCloudDNSFluent<A extends ACMEIssuerDNS01ProviderCloudDNSFluent<A>> extends BaseFluent<A>{
  public ACMEIssuerDNS01ProviderCloudDNSFluent() {
  }
  
  public ACMEIssuerDNS01ProviderCloudDNSFluent(ACMEIssuerDNS01ProviderCloudDNS instance) {
    this.copyInstance(instance);
  }
  private String hostedZoneName;
  private String project;
  private SecretKeySelectorBuilder serviceAccountSecretRef;
  
  protected void copyInstance(ACMEIssuerDNS01ProviderCloudDNS instance) {
    instance = (instance != null ? instance : new ACMEIssuerDNS01ProviderCloudDNS());
  
    if (instance != null) {
        this.withHostedZoneName(instance.getHostedZoneName());
        this.withProject(instance.getProject());
        this.withServiceAccountSecretRef(instance.getServiceAccountSecretRef());
        this.withHostedZoneName(instance.getHostedZoneName());
        this.withProject(instance.getProject());
        this.withServiceAccountSecretRef(instance.getServiceAccountSecretRef());
      }
  }
  
  public String getHostedZoneName() {
    return this.hostedZoneName;
  }
  
  public A withHostedZoneName(String hostedZoneName) {
    this.hostedZoneName=hostedZoneName; return (A) this;
  }
  
  public boolean hasHostedZoneName() {
    return this.hostedZoneName != null;
  }
  
  public String getProject() {
    return this.project;
  }
  
  public A withProject(String project) {
    this.project=project; return (A) this;
  }
  
  public boolean hasProject() {
    return this.project != null;
  }
  
  public SecretKeySelector buildServiceAccountSecretRef() {
    return this.serviceAccountSecretRef!=null ?this.serviceAccountSecretRef.build():null;
  }
  
  public A withServiceAccountSecretRef(SecretKeySelector serviceAccountSecretRef) {
    _visitables.get("serviceAccountSecretRef").remove(this.serviceAccountSecretRef);
    if (serviceAccountSecretRef!=null){ this.serviceAccountSecretRef= new SecretKeySelectorBuilder(serviceAccountSecretRef); _visitables.get("serviceAccountSecretRef").add(this.serviceAccountSecretRef);} else { this.serviceAccountSecretRef = null; _visitables.get("serviceAccountSecretRef").remove(this.serviceAccountSecretRef); } return (A) this;
  }
  
  public boolean hasServiceAccountSecretRef() {
    return this.serviceAccountSecretRef != null;
  }
  
  public A withNewServiceAccountSecretRef(String key,String name) {
    return (A)withServiceAccountSecretRef(new SecretKeySelector(key, name));
  }
  
  public ServiceAccountSecretRefNested<A> withNewServiceAccountSecretRef() {
    return new ServiceAccountSecretRefNested(null);
  }
  
  public ServiceAccountSecretRefNested<A> withNewServiceAccountSecretRefLike(SecretKeySelector item) {
    return new ServiceAccountSecretRefNested(item);
  }
  
  public ServiceAccountSecretRefNested<A> editServiceAccountSecretRef() {
    return withNewServiceAccountSecretRefLike(java.util.Optional.ofNullable(buildServiceAccountSecretRef()).orElse(null));
  }
  
  public ServiceAccountSecretRefNested<A> editOrNewServiceAccountSecretRef() {
    return withNewServiceAccountSecretRefLike(java.util.Optional.ofNullable(buildServiceAccountSecretRef()).orElse(new SecretKeySelectorBuilder().build()));
  }
  
  public ServiceAccountSecretRefNested<A> editOrNewServiceAccountSecretRefLike(SecretKeySelector item) {
    return withNewServiceAccountSecretRefLike(java.util.Optional.ofNullable(buildServiceAccountSecretRef()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ACMEIssuerDNS01ProviderCloudDNSFluent that = (ACMEIssuerDNS01ProviderCloudDNSFluent) o;
    if (!java.util.Objects.equals(hostedZoneName, that.hostedZoneName)) return false;
  
    if (!java.util.Objects.equals(project, that.project)) return false;
  
    if (!java.util.Objects.equals(serviceAccountSecretRef, that.serviceAccountSecretRef)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(hostedZoneName,  project,  serviceAccountSecretRef,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (hostedZoneName != null) { sb.append("hostedZoneName:"); sb.append(hostedZoneName + ","); }
    if (project != null) { sb.append("project:"); sb.append(project + ","); }
    if (serviceAccountSecretRef != null) { sb.append("serviceAccountSecretRef:"); sb.append(serviceAccountSecretRef); }
    sb.append("}");
    return sb.toString();
  }
  public class ServiceAccountSecretRefNested<N> extends SecretKeySelectorFluent<ServiceAccountSecretRefNested<N>> implements Nested<N>{
    ServiceAccountSecretRefNested(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    SecretKeySelectorBuilder builder;
    
    public N and() {
      return (N) ACMEIssuerDNS01ProviderCloudDNSFluent.this.withServiceAccountSecretRef(builder.build());
    }
    
    public N endServiceAccountSecretRef() {
      return and();
    }
    
  
  }

}