package io.fabric8.certmanager.api.model.acme.v1alpha3;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ACMEIssuerDNS01ProviderAkamaiFluent<A extends ACMEIssuerDNS01ProviderAkamaiFluent<A>> extends BaseFluent<A>{
  public ACMEIssuerDNS01ProviderAkamaiFluent() {
  }
  
  public ACMEIssuerDNS01ProviderAkamaiFluent(ACMEIssuerDNS01ProviderAkamai instance) {
    this.copyInstance(instance);
  }
  private SecretKeySelectorBuilder accessTokenSecretRef;
  private SecretKeySelectorBuilder clientSecretSecretRef;
  private SecretKeySelectorBuilder clientTokenSecretRef;
  private String serviceConsumerDomain;
  
  protected void copyInstance(ACMEIssuerDNS01ProviderAkamai instance) {
    instance = (instance != null ? instance : new ACMEIssuerDNS01ProviderAkamai());
  
    if (instance != null) {
        this.withAccessTokenSecretRef(instance.getAccessTokenSecretRef());
        this.withClientSecretSecretRef(instance.getClientSecretSecretRef());
        this.withClientTokenSecretRef(instance.getClientTokenSecretRef());
        this.withServiceConsumerDomain(instance.getServiceConsumerDomain());
        this.withAccessTokenSecretRef(instance.getAccessTokenSecretRef());
        this.withClientSecretSecretRef(instance.getClientSecretSecretRef());
        this.withClientTokenSecretRef(instance.getClientTokenSecretRef());
        this.withServiceConsumerDomain(instance.getServiceConsumerDomain());
      }
  }
  
  public SecretKeySelector buildAccessTokenSecretRef() {
    return this.accessTokenSecretRef!=null ?this.accessTokenSecretRef.build():null;
  }
  
  public A withAccessTokenSecretRef(SecretKeySelector accessTokenSecretRef) {
    _visitables.get("accessTokenSecretRef").remove(this.accessTokenSecretRef);
    if (accessTokenSecretRef!=null){ this.accessTokenSecretRef= new SecretKeySelectorBuilder(accessTokenSecretRef); _visitables.get("accessTokenSecretRef").add(this.accessTokenSecretRef);} else { this.accessTokenSecretRef = null; _visitables.get("accessTokenSecretRef").remove(this.accessTokenSecretRef); } return (A) this;
  }
  
  public boolean hasAccessTokenSecretRef() {
    return this.accessTokenSecretRef != null;
  }
  
  public A withNewAccessTokenSecretRef(String key,String name) {
    return (A)withAccessTokenSecretRef(new SecretKeySelector(key, name));
  }
  
  public AccessTokenSecretRefNested<A> withNewAccessTokenSecretRef() {
    return new AccessTokenSecretRefNested(null);
  }
  
  public AccessTokenSecretRefNested<A> withNewAccessTokenSecretRefLike(SecretKeySelector item) {
    return new AccessTokenSecretRefNested(item);
  }
  
  public AccessTokenSecretRefNested<A> editAccessTokenSecretRef() {
    return withNewAccessTokenSecretRefLike(java.util.Optional.ofNullable(buildAccessTokenSecretRef()).orElse(null));
  }
  
  public AccessTokenSecretRefNested<A> editOrNewAccessTokenSecretRef() {
    return withNewAccessTokenSecretRefLike(java.util.Optional.ofNullable(buildAccessTokenSecretRef()).orElse(new SecretKeySelectorBuilder().build()));
  }
  
  public AccessTokenSecretRefNested<A> editOrNewAccessTokenSecretRefLike(SecretKeySelector item) {
    return withNewAccessTokenSecretRefLike(java.util.Optional.ofNullable(buildAccessTokenSecretRef()).orElse(item));
  }
  
  public SecretKeySelector buildClientSecretSecretRef() {
    return this.clientSecretSecretRef!=null ?this.clientSecretSecretRef.build():null;
  }
  
  public A withClientSecretSecretRef(SecretKeySelector clientSecretSecretRef) {
    _visitables.get("clientSecretSecretRef").remove(this.clientSecretSecretRef);
    if (clientSecretSecretRef!=null){ this.clientSecretSecretRef= new SecretKeySelectorBuilder(clientSecretSecretRef); _visitables.get("clientSecretSecretRef").add(this.clientSecretSecretRef);} else { this.clientSecretSecretRef = null; _visitables.get("clientSecretSecretRef").remove(this.clientSecretSecretRef); } return (A) this;
  }
  
  public boolean hasClientSecretSecretRef() {
    return this.clientSecretSecretRef != null;
  }
  
  public A withNewClientSecretSecretRef(String key,String name) {
    return (A)withClientSecretSecretRef(new SecretKeySelector(key, name));
  }
  
  public ClientSecretSecretRefNested<A> withNewClientSecretSecretRef() {
    return new ClientSecretSecretRefNested(null);
  }
  
  public ClientSecretSecretRefNested<A> withNewClientSecretSecretRefLike(SecretKeySelector item) {
    return new ClientSecretSecretRefNested(item);
  }
  
  public ClientSecretSecretRefNested<A> editClientSecretSecretRef() {
    return withNewClientSecretSecretRefLike(java.util.Optional.ofNullable(buildClientSecretSecretRef()).orElse(null));
  }
  
  public ClientSecretSecretRefNested<A> editOrNewClientSecretSecretRef() {
    return withNewClientSecretSecretRefLike(java.util.Optional.ofNullable(buildClientSecretSecretRef()).orElse(new SecretKeySelectorBuilder().build()));
  }
  
  public ClientSecretSecretRefNested<A> editOrNewClientSecretSecretRefLike(SecretKeySelector item) {
    return withNewClientSecretSecretRefLike(java.util.Optional.ofNullable(buildClientSecretSecretRef()).orElse(item));
  }
  
  public SecretKeySelector buildClientTokenSecretRef() {
    return this.clientTokenSecretRef!=null ?this.clientTokenSecretRef.build():null;
  }
  
  public A withClientTokenSecretRef(SecretKeySelector clientTokenSecretRef) {
    _visitables.get("clientTokenSecretRef").remove(this.clientTokenSecretRef);
    if (clientTokenSecretRef!=null){ this.clientTokenSecretRef= new SecretKeySelectorBuilder(clientTokenSecretRef); _visitables.get("clientTokenSecretRef").add(this.clientTokenSecretRef);} else { this.clientTokenSecretRef = null; _visitables.get("clientTokenSecretRef").remove(this.clientTokenSecretRef); } return (A) this;
  }
  
  public boolean hasClientTokenSecretRef() {
    return this.clientTokenSecretRef != null;
  }
  
  public A withNewClientTokenSecretRef(String key,String name) {
    return (A)withClientTokenSecretRef(new SecretKeySelector(key, name));
  }
  
  public ClientTokenSecretRefNested<A> withNewClientTokenSecretRef() {
    return new ClientTokenSecretRefNested(null);
  }
  
  public ClientTokenSecretRefNested<A> withNewClientTokenSecretRefLike(SecretKeySelector item) {
    return new ClientTokenSecretRefNested(item);
  }
  
  public ClientTokenSecretRefNested<A> editClientTokenSecretRef() {
    return withNewClientTokenSecretRefLike(java.util.Optional.ofNullable(buildClientTokenSecretRef()).orElse(null));
  }
  
  public ClientTokenSecretRefNested<A> editOrNewClientTokenSecretRef() {
    return withNewClientTokenSecretRefLike(java.util.Optional.ofNullable(buildClientTokenSecretRef()).orElse(new SecretKeySelectorBuilder().build()));
  }
  
  public ClientTokenSecretRefNested<A> editOrNewClientTokenSecretRefLike(SecretKeySelector item) {
    return withNewClientTokenSecretRefLike(java.util.Optional.ofNullable(buildClientTokenSecretRef()).orElse(item));
  }
  
  public String getServiceConsumerDomain() {
    return this.serviceConsumerDomain;
  }
  
  public A withServiceConsumerDomain(String serviceConsumerDomain) {
    this.serviceConsumerDomain=serviceConsumerDomain; return (A) this;
  }
  
  public boolean hasServiceConsumerDomain() {
    return this.serviceConsumerDomain != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ACMEIssuerDNS01ProviderAkamaiFluent that = (ACMEIssuerDNS01ProviderAkamaiFluent) o;
    if (!java.util.Objects.equals(accessTokenSecretRef, that.accessTokenSecretRef)) return false;
  
    if (!java.util.Objects.equals(clientSecretSecretRef, that.clientSecretSecretRef)) return false;
  
    if (!java.util.Objects.equals(clientTokenSecretRef, that.clientTokenSecretRef)) return false;
  
    if (!java.util.Objects.equals(serviceConsumerDomain, that.serviceConsumerDomain)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(accessTokenSecretRef,  clientSecretSecretRef,  clientTokenSecretRef,  serviceConsumerDomain,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (accessTokenSecretRef != null) { sb.append("accessTokenSecretRef:"); sb.append(accessTokenSecretRef + ","); }
    if (clientSecretSecretRef != null) { sb.append("clientSecretSecretRef:"); sb.append(clientSecretSecretRef + ","); }
    if (clientTokenSecretRef != null) { sb.append("clientTokenSecretRef:"); sb.append(clientTokenSecretRef + ","); }
    if (serviceConsumerDomain != null) { sb.append("serviceConsumerDomain:"); sb.append(serviceConsumerDomain); }
    sb.append("}");
    return sb.toString();
  }
  public class AccessTokenSecretRefNested<N> extends SecretKeySelectorFluent<AccessTokenSecretRefNested<N>> implements Nested<N>{
    AccessTokenSecretRefNested(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    SecretKeySelectorBuilder builder;
    
    public N and() {
      return (N) ACMEIssuerDNS01ProviderAkamaiFluent.this.withAccessTokenSecretRef(builder.build());
    }
    
    public N endAccessTokenSecretRef() {
      return and();
    }
    
  
  }
  public class ClientSecretSecretRefNested<N> extends SecretKeySelectorFluent<ClientSecretSecretRefNested<N>> implements Nested<N>{
    ClientSecretSecretRefNested(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    SecretKeySelectorBuilder builder;
    
    public N and() {
      return (N) ACMEIssuerDNS01ProviderAkamaiFluent.this.withClientSecretSecretRef(builder.build());
    }
    
    public N endClientSecretSecretRef() {
      return and();
    }
    
  
  }
  public class ClientTokenSecretRefNested<N> extends SecretKeySelectorFluent<ClientTokenSecretRefNested<N>> implements Nested<N>{
    ClientTokenSecretRefNested(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    SecretKeySelectorBuilder builder;
    
    public N and() {
      return (N) ACMEIssuerDNS01ProviderAkamaiFluent.this.withClientTokenSecretRef(builder.build());
    }
    
    public N endClientTokenSecretRef() {
      return and();
    }
    
  
  }

}