package io.fabric8.certmanager.api.model.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VenafiTPPBuilder extends VenafiTPPFluent<VenafiTPPBuilder> implements VisitableBuilder<VenafiTPP,VenafiTPPBuilder>{
  public VenafiTPPBuilder() {
    this(false);
  }
  public VenafiTPPBuilder(Boolean validationEnabled) {
    this(new VenafiTPP(), validationEnabled);
  }
  public VenafiTPPBuilder(VenafiTPPFluent<?> fluent) {
    this(fluent, false);
  }
  public VenafiTPPBuilder(VenafiTPPFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VenafiTPP(), validationEnabled);
  }
  public VenafiTPPBuilder(VenafiTPPFluent<?> fluent,VenafiTPP instance) {
    this(fluent, instance, false);
  }
  public VenafiTPPBuilder(VenafiTPPFluent<?> fluent,VenafiTPP instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new VenafiTPP());

    if (instance != null) {
      fluent.withCaBundle(instance.getCaBundle());
      fluent.withCredentialsRef(instance.getCredentialsRef());
      fluent.withUrl(instance.getUrl());
      fluent.withCaBundle(instance.getCaBundle());
      fluent.withCredentialsRef(instance.getCredentialsRef());
      fluent.withUrl(instance.getUrl());
    }
    this.validationEnabled = validationEnabled; 
  }
  public VenafiTPPBuilder(VenafiTPP instance) {
    this(instance,false);
  }
  public VenafiTPPBuilder(VenafiTPP instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new VenafiTPP());

    if (instance != null) {
      this.withCaBundle(instance.getCaBundle());
      this.withCredentialsRef(instance.getCredentialsRef());
      this.withUrl(instance.getUrl());
      this.withCaBundle(instance.getCaBundle());
      this.withCredentialsRef(instance.getCredentialsRef());
      this.withUrl(instance.getUrl());
    }
    this.validationEnabled = validationEnabled; 
  }
  VenafiTPPFluent<?> fluent;
  Boolean validationEnabled;
  public VenafiTPP build() {
    VenafiTPP buildable = new VenafiTPP(fluent.getCaBundle(),fluent.buildCredentialsRef(),fluent.getUrl());
    return buildable;
  }
  
}